/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.jobscheduler;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.geospatial.annotation.VisibleForTesting;
import org.opensearch.geospatial.ip2geo.common.DatasourceManifest;
import org.opensearch.geospatial.ip2geo.common.DatasourceState;
import org.opensearch.geospatial.ip2geo.common.URLDenyListChecker;
import org.opensearch.geospatial.ip2geo.dao.DatasourceDao;
import org.opensearch.geospatial.ip2geo.dao.GeoIpDataDao;
import org.opensearch.geospatial.ip2geo.jobscheduler.Datasource;
import org.opensearch.geospatial.ip2geo.jobscheduler.DatasourceTask;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;

public class DatasourceUpdateService {
    @Generated
    private static final Logger log = LogManager.getLogger(DatasourceUpdateService.class);
    private static final int SLEEP_TIME_IN_MILLIS = 5000;
    private static final int MAX_WAIT_TIME_FOR_REPLICATION_TO_COMPLETE_IN_MILLIS = 36000000;
    private final ClusterService clusterService;
    private final ClusterSettings clusterSettings;
    private final DatasourceDao datasourceDao;
    private final GeoIpDataDao geoIpDataDao;
    private final URLDenyListChecker urlDenyListChecker;

    public DatasourceUpdateService(ClusterService clusterService, DatasourceDao datasourceDao, GeoIpDataDao geoIpDataDao, URLDenyListChecker urlDenyListChecker) {
        this.clusterService = clusterService;
        this.clusterSettings = clusterService.getClusterSettings();
        this.datasourceDao = datasourceDao;
        this.geoIpDataDao = geoIpDataDao;
        this.urlDenyListChecker = urlDenyListChecker;
    }

    public void updateOrCreateGeoIpData(Datasource datasource, Runnable renewLock) throws IOException {
        List<String> fieldsToStore;
        URL url = this.urlDenyListChecker.toUrlIfNotInDenyList(datasource.getEndpoint());
        DatasourceManifest manifest = DatasourceManifest.Builder.build(url);
        if (!this.shouldUpdate(datasource, manifest)) {
            log.info("Skipping GeoIP database update. Update is not required for {}", (Object)datasource.getName());
            datasource.getUpdateStats().setLastSkippedAt(Instant.now());
            this.datasourceDao.updateDatasource(datasource);
            return;
        }
        Instant startTime = Instant.now();
        String indexName = this.setupIndex(datasource);
        try (CSVParser reader = this.geoIpDataDao.getDatabaseReader(manifest);){
            CSVRecord headerLine = (CSVRecord)reader.iterator().next();
            String[] header = this.validateHeader(headerLine).values();
            fieldsToStore = Arrays.asList(header).subList(1, header.length);
            if (!datasource.isCompatible(fieldsToStore)) {
                throw new OpenSearchException("new fields [{}] does not contain all old fields [{}]", new Object[]{fieldsToStore.toString(), datasource.getDatabase().getFields().toString()});
            }
            this.geoIpDataDao.putGeoIpData(indexName, header, reader.iterator(), renewLock);
        }
        this.waitUntilAllShardsStarted(indexName, 36000000);
        Instant endTime = Instant.now();
        this.updateDatasourceAsSucceeded(indexName, datasource, manifest, fieldsToStore, startTime, endTime);
    }

    @VisibleForTesting
    protected void waitUntilAllShardsStarted(String indexName, int timeout) {
        Instant start = Instant.now();
        try {
            while (Instant.now().toEpochMilli() - start.toEpochMilli() < (long)timeout) {
                if (this.clusterService.state().routingTable().allShards(indexName).stream().allMatch(shard -> shard.started())) {
                    return;
                }
                Thread.sleep(5000L);
            }
            throw new OpenSearchException("index[{}] replication did not complete after {} millis", new Object[]{36000000});
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getHeaderFields(String manifestUrl) throws IOException {
        URL url = URI.create(manifestUrl).toURL();
        DatasourceManifest manifest = DatasourceManifest.Builder.build(url);
        try (CSVParser reader = this.geoIpDataDao.getDatabaseReader(manifest);){
            String[] fields = ((CSVRecord)reader.iterator().next()).values();
            List<String> list = Arrays.asList(fields).subList(1, fields.length);
            return list;
        }
    }

    public void deleteUnusedIndices(Datasource datasource) {
        try {
            List<String> indicesToDelete = datasource.getIndices().stream().filter(index -> !index.equals(datasource.currentIndexName())).collect(Collectors.toList());
            List<String> deletedIndices = this.deleteIndices(indicesToDelete);
            if (!deletedIndices.isEmpty()) {
                datasource.getIndices().removeAll(deletedIndices);
                this.datasourceDao.updateDatasource(datasource);
            }
        }
        catch (Exception e) {
            log.error("Failed to delete old indices for {}", (Object)datasource.getName(), (Object)e);
        }
    }

    public void updateDatasource(Datasource datasource, IntervalSchedule systemSchedule, DatasourceTask task) {
        boolean updated = false;
        if (!datasource.getSystemSchedule().equals((Object)systemSchedule)) {
            datasource.setSystemSchedule(systemSchedule);
            updated = true;
        }
        if (!datasource.getTask().equals((Object)task)) {
            datasource.setTask(task);
            updated = true;
        }
        if (updated) {
            this.datasourceDao.updateDatasource(datasource);
        }
    }

    private List<String> deleteIndices(List<String> indicesToDelete) {
        ArrayList<String> deletedIndices = new ArrayList<String>(indicesToDelete.size());
        for (String index : indicesToDelete) {
            if (!this.clusterService.state().metadata().hasIndex(index)) {
                deletedIndices.add(index);
                continue;
            }
            try {
                this.geoIpDataDao.deleteIp2GeoDataIndex(index);
                deletedIndices.add(index);
            }
            catch (Exception e) {
                log.error("Failed to delete an index [{}]", (Object)index, (Object)e);
            }
        }
        return deletedIndices;
    }

    private CSVRecord validateHeader(CSVRecord header) {
        if (header == null) {
            throw new OpenSearchException("geoip database is empty", new Object[0]);
        }
        if (header.values().length < 2) {
            throw new OpenSearchException("geoip database should have at least two fields", new Object[0]);
        }
        return header;
    }

    private void updateDatasourceAsSucceeded(String newIndexName, Datasource datasource, DatasourceManifest manifest, List<String> fields, Instant startTime, Instant endTime) {
        datasource.setCurrentIndex(newIndexName);
        datasource.setDatabase(manifest, fields);
        datasource.getUpdateStats().setLastSucceededAt(endTime);
        datasource.getUpdateStats().setLastProcessingTimeInMillis(endTime.toEpochMilli() - startTime.toEpochMilli());
        datasource.enable();
        datasource.setState(DatasourceState.AVAILABLE);
        this.datasourceDao.updateDatasource(datasource);
        log.info("GeoIP database creation succeeded for {} and took {} seconds", (Object)datasource.getName(), (Object)Duration.between(startTime, endTime));
    }

    private String setupIndex(Datasource datasource) {
        String indexName = datasource.newIndexName(UUID.randomUUID().toString());
        datasource.getIndices().add(indexName);
        this.datasourceDao.updateDatasource(datasource);
        this.geoIpDataDao.createIndexIfNotExists(indexName);
        return indexName;
    }

    private boolean shouldUpdate(Datasource datasource, DatasourceManifest manifest) {
        if (datasource.getDatabase().getUpdatedAt() != null && datasource.getDatabase().getUpdatedAt().toEpochMilli() > manifest.getUpdatedAt()) {
            return false;
        }
        return !manifest.getSha256Hash().equals(datasource.getDatabase().getSha256Hash());
    }
}

