/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mac;

import java.io.File;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;

public class MacFileUtils {
    private static final int FSREF_SIZE = 80;
    private static final int kFSPathMakeRefDoNotFollowLeafSymlink = 1;

    public static void moveToTrash(File ... files) throws IOException {
        ArrayList<CallSite> failed = new ArrayList<CallSite>();
        try (Arena arena = Arena.ofConfined();){
            Linker linker = Linker.nativeLinker();
            SymbolLookup cfLookup = SymbolLookup.libraryLookup("/System/Library/Frameworks/Carbon.framework/Carbon", Arena.global());
            MemorySegment msfsp1 = cfLookup.find("FSPathMakeRefWithOptions").orElseThrow(() -> new RuntimeException("FSPathMakeRefWithOptions not found"));
            MethodHandle FSPathMakeRefWithOptions = linker.downcallHandle(msfsp1, FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
            MethodHandle FSMoveObjectToTrashSync = linker.downcallHandle(cfLookup.find("FSMoveObjectToTrashSync").orElseThrow(() -> new RuntimeException("FSMoveObjectToTrashSync not found")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT), new Linker.Option[0]);
            for (File src : files) {
                MemorySegment fsref = arena.allocate(80L);
                MemorySegment path = arena.allocateFrom(src.getAbsolutePath());
                int status = FSPathMakeRefWithOptions.invoke(path, 1, fsref, MemorySegment.NULL);
                if (status != 0) {
                    failed.add((CallSite)((Object)(String.valueOf(src) + " (FSRefMakeRefWithOptions: " + status + ")")));
                    continue;
                }
                status = FSMoveObjectToTrashSync.invoke(fsref, MemorySegment.NULL, 0);
                if (status == 0) continue;
                failed.add((CallSite)((Object)(String.valueOf(src) + " (FSMoveObjectToTrashSync: " + status + ")")));
            }
        }
        catch (Throwable t) {
            throw new IOException("Error while calling native functions", t);
        }
        if (!failed.isEmpty()) {
            throw new IOException("The following files could not be trashed: " + String.valueOf(failed));
        }
    }
}

