/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models;

import io.smallrye.openapi.internal.models.AbstractPathItem;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;

public class PathItem
extends AbstractPathItem {
    private static final Map<String, PathItem.HttpMethod> OPERATIONS = Arrays.stream(PathItem.HttpMethod.values()).collect(Collectors.toMap(m -> m.name().toLowerCase(), Function.identity()));

    public Map<PathItem.HttpMethod, Operation> getOperations() {
        LinkedHashMap<PathItem.HttpMethod, Operation> ops = new LinkedHashMap<PathItem.HttpMethod, Operation>(OPERATIONS.size());
        for (Map.Entry property : this.getProperties(Operation.class).entrySet()) {
            String name = (String)property.getKey();
            if (!OPERATIONS.containsKey(name)) continue;
            ops.put(OPERATIONS.get(name), (Operation)property.getValue());
        }
        return ops;
    }

    public void setOperation(PathItem.HttpMethod httpMethod, Operation operation) {
        this.setProperty(httpMethod.name().toLowerCase(), operation);
    }
}

