/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.builder;

import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.impl.DefaultJavaParameterizedType;
import com.thoughtworks.qdox.model.impl.DefaultJavaType;
import com.thoughtworks.qdox.model.impl.DefaultJavaWildcardType;
import com.thoughtworks.qdox.parser.structs.TypeDef;
import com.thoughtworks.qdox.parser.structs.WildcardTypeDef;
import com.thoughtworks.qdox.type.TypeResolver;
import java.util.LinkedList;

public final class TypeAssembler {
    private TypeAssembler() {
    }

    public static DefaultJavaType createUnresolved(TypeDef typeDef, int dimensions, TypeResolver typeResolver) {
        DefaultJavaType result;
        if (typeDef instanceof WildcardTypeDef) {
            WildcardTypeDef wildcard = (WildcardTypeDef)typeDef;
            if (wildcard.getTypeDef() != null) {
                DefaultJavaType type = TypeAssembler.createUnresolved(wildcard.getTypeDef(), typeResolver);
                DefaultJavaWildcardType.BoundType boundType = null;
                if ("extends".equals(wildcard.getWildcardExpressionType())) {
                    boundType = DefaultJavaWildcardType.BoundType.EXTENDS;
                } else if ("super".equals(wildcard.getWildcardExpressionType())) {
                    boundType = DefaultJavaWildcardType.BoundType.SUPER;
                }
                result = new DefaultJavaWildcardType(type, boundType);
            } else {
                result = new DefaultJavaWildcardType();
            }
        } else {
            DefaultJavaParameterizedType typeResult = new DefaultJavaParameterizedType(null, typeDef.getName(), typeDef.getDimensions() + dimensions, typeResolver);
            if (typeDef.getActualArgumentTypes() != null && !typeDef.getActualArgumentTypes().isEmpty()) {
                LinkedList<JavaType> actualArgumentTypes = new LinkedList<JavaType>();
                for (TypeDef actualArgType : typeDef.getActualArgumentTypes()) {
                    actualArgumentTypes.add(TypeAssembler.createUnresolved(actualArgType, typeResolver));
                }
                typeResult.setActualArgumentTypes(actualArgumentTypes);
            }
            result = typeResult;
        }
        return result;
    }

    public static DefaultJavaType createUnresolved(TypeDef typeDef, TypeResolver typeResolver) {
        return TypeAssembler.createUnresolved(typeDef, 0, typeResolver);
    }
}

