/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.Table;

public abstract class BaseTable
implements Table {
    private int _version;
    private int _horizAxisOffset;
    private int _vertAxisOffset;
    private Axis _horizAxis;
    private Axis _vertAxis;
    private byte[] _buf;

    protected BaseTable(DataInput dataInput, int n) throws IOException {
        this._buf = new byte[n];
        dataInput.readFully(this._buf);
        DataInput dataInput2 = this.getDataInputForOffset(0);
        this._version = dataInput2.readInt();
        this._horizAxisOffset = dataInput2.readUnsignedShort();
        this._vertAxisOffset = dataInput2.readUnsignedShort();
        if (this._horizAxisOffset != 0) {
            this._horizAxis = new Axis(this._horizAxisOffset);
        }
        if (this._vertAxisOffset != 0) {
            this._vertAxis = new Axis(this._vertAxisOffset);
        }
        this._buf = null;
    }

    private DataInput getDataInputForOffset(int n) {
        return new DataInputStream(new ByteArrayInputStream(this._buf, n, this._buf.length - n));
    }

    private static String tagAsString(int n) {
        char[] cArray = new char[]{(char)(n >> 24 & 0xFF), (char)(n >> 16 & 0xFF), (char)(n >> 8 & 0xFF), (char)(n & 0xFF)};
        return String.valueOf(cArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("; 'BASE' Table - Baseline\n;-------------------------------------\n\n").append("BASEHeader BASEHeaderT").append(Integer.toHexString(0)).append("\n").append(Integer.toHexString(this._version)).append("\nAxisT").append(Integer.toHexString(this._horizAxisOffset)).append("\nAxisT").append(Integer.toHexString(this._vertAxisOffset));
        if (this._horizAxis != null) {
            stringBuilder.append("\n").append(this._horizAxis.toString());
        }
        if (this._vertAxis != null) {
            stringBuilder.append("\n").append(this._vertAxis.toString());
        }
        return stringBuilder.toString();
    }

    private class Axis {
        private final int _thisOffset;
        private int _baseTagListOffset;
        private int _baseScriptListOffset;
        private BaseTagList _baseTagList;
        private BaseScriptList _baseScriptList;

        Axis(int n) throws IOException {
            this._thisOffset = n;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n);
            this._baseTagListOffset = dataInput.readUnsignedShort();
            this._baseScriptListOffset = dataInput.readUnsignedShort();
            if (this._baseTagListOffset != 0) {
                this._baseTagList = new BaseTagList(n + this._baseTagListOffset);
            }
            if (this._baseScriptListOffset != 0) {
                this._baseScriptList = new BaseScriptList(n + this._baseScriptListOffset);
            }
        }

        public String toString() {
            return "\nAxis AxisT" + Integer.toHexString(this._thisOffset) + "\nBaseTagListT" + Integer.toHexString(this._thisOffset + this._baseTagListOffset) + "\nBaseScriptListT" + Integer.toHexString(this._thisOffset + this._baseScriptListOffset) + "\n" + this._baseTagList + "\n" + this._baseScriptList;
        }
    }

    private class BaseTagList {
        private final int _thisOffset;
        private int _baseTagCount;
        private int[] _baselineTag;

        BaseTagList(int n) throws IOException {
            this._thisOffset = n;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n);
            this._baseTagCount = dataInput.readUnsignedShort();
            this._baselineTag = new int[this._baseTagCount];
            for (int i = 0; i < this._baseTagCount; ++i) {
                this._baselineTag[i] = dataInput.readInt();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("\nBaseTagList BaseTagListT").append(Integer.toHexString(this._thisOffset)).append("\n").append(Integer.toHexString(this._baseTagCount));
            for (int i = 0; i < this._baseTagCount; ++i) {
                stringBuilder.append("\n'").append(BaseTable.tagAsString(this._baselineTag[i])).append("'");
            }
            return stringBuilder.toString();
        }
    }

    private class BaseScriptList {
        private final int _thisOffset;
        private int _baseScriptCount;
        private BaseScriptRecord[] _baseScriptRecord;
        private BaseScript[] _baseScripts;

        BaseScriptList(int n) throws IOException {
            int n2;
            this._thisOffset = n;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n);
            this._baseScriptCount = dataInput.readUnsignedShort();
            this._baseScriptRecord = new BaseScriptRecord[this._baseScriptCount];
            for (n2 = 0; n2 < this._baseScriptCount; ++n2) {
                this._baseScriptRecord[n2] = new BaseScriptRecord(dataInput);
            }
            this._baseScripts = new BaseScript[this._baseScriptCount];
            for (n2 = 0; n2 < this._baseScriptCount; ++n2) {
                this._baseScripts[n2] = new BaseScript(n + this._baseScriptRecord[n2].getBaseScriptOffset());
            }
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder().append("\nBaseScriptList BaseScriptListT").append(Integer.toHexString(this._thisOffset)).append("\n").append(Integer.toHexString(this._baseScriptCount));
            for (n = 0; n < this._baseScriptCount; ++n) {
                stringBuilder.append("\n                          ; BaseScriptRecord[").append(n);
                stringBuilder.append("]\n'").append(BaseTable.tagAsString(this._baseScriptRecord[n].getBaseScriptTag())).append("'");
                stringBuilder.append("\nBaseScriptT").append(Integer.toHexString(this._thisOffset + this._baseScriptRecord[n].getBaseScriptOffset()));
            }
            for (n = 0; n < this._baseScriptCount; ++n) {
                stringBuilder.append("\n").append(this._baseScripts[n].toString());
            }
            return stringBuilder.toString();
        }
    }

    private static class BaseScriptRecord {
        private int _baseScriptTag;
        private int _baseScriptOffset;

        BaseScriptRecord(DataInput dataInput) throws IOException {
            this._baseScriptTag = dataInput.readInt();
            this._baseScriptOffset = dataInput.readUnsignedShort();
        }

        int getBaseScriptTag() {
            return this._baseScriptTag;
        }

        int getBaseScriptOffset() {
            return this._baseScriptOffset;
        }
    }

    private class BaseScript {
        private final int _thisOffset;
        private int _baseValuesOffset;
        private int _defaultMinMaxOffset;
        private int _baseLangSysCount;
        private BaseLangSysRecord[] _baseLangSysRecord;
        private BaseValues _baseValues;
        private MinMax[] _minMax;

        BaseScript(int n) throws IOException {
            int n2;
            this._thisOffset = n;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n);
            this._baseValuesOffset = dataInput.readUnsignedShort();
            this._defaultMinMaxOffset = dataInput.readUnsignedShort();
            this._baseLangSysCount = dataInput.readUnsignedShort();
            this._baseLangSysRecord = new BaseLangSysRecord[this._baseLangSysCount];
            for (n2 = 0; n2 < this._baseLangSysCount; ++n2) {
                this._baseLangSysRecord[n2] = new BaseLangSysRecord(dataInput);
            }
            if (this._baseValuesOffset > 0) {
                this._baseValues = new BaseValues(n + this._baseValuesOffset);
            }
            for (n2 = 0; n2 < this._baseLangSysCount; ++n2) {
                this._minMax[n2] = new MinMax(n + this._baseLangSysRecord[n2].getMinMaxOffset());
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("\nBaseScript BaseScriptT").append(Integer.toHexString(this._thisOffset)).append("\nBaseValuesT").append(Integer.toHexString(this._thisOffset + this._baseValuesOffset)).append("\nMinMaxT").append(Integer.toHexString(this._thisOffset + this._defaultMinMaxOffset)).append("\n").append(Integer.toHexString(this._baseLangSysCount));
            if (this._baseValues != null) {
                stringBuilder.append("\n").append(this._baseValues.toString());
            }
            return stringBuilder.toString();
        }
    }

    private static class BaseLangSysRecord {
        private int _baseLangSysTag;
        private int _minMaxOffset;

        BaseLangSysRecord(DataInput dataInput) throws IOException {
            this._baseLangSysTag = dataInput.readInt();
            this._minMaxOffset = dataInput.readUnsignedShort();
        }

        public int getBaseLangSysTag() {
            return this._baseLangSysTag;
        }

        int getMinMaxOffset() {
            return this._minMaxOffset;
        }
    }

    private class BaseValues {
        private int _defaultIndex;
        private int _baseCoordCount;
        private int[] _baseCoordOffset;
        private BaseCoord[] _baseCoords;

        BaseValues(int n) throws IOException {
            int n2;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n);
            this._defaultIndex = dataInput.readUnsignedShort();
            this._baseCoordCount = dataInput.readUnsignedShort();
            this._baseCoordOffset = new int[this._baseCoordCount];
            for (n2 = 0; n2 < this._baseCoordCount; ++n2) {
                this._baseCoordOffset[n2] = dataInput.readUnsignedShort();
            }
            this._baseCoords = new BaseCoord[this._baseCoordCount];
            block6: for (n2 = 0; n2 < this._baseCoordCount; ++n2) {
                int n3 = dataInput.readUnsignedShort();
                switch (n3) {
                    case 1: {
                        this._baseCoords[n2] = new BaseCoordFormat1(dataInput);
                        continue block6;
                    }
                    case 2: {
                        this._baseCoords[n2] = new BaseCoordFormat2(dataInput);
                        continue block6;
                    }
                    case 3: {
                        this._baseCoords[n2] = new BaseCoordFormat3(dataInput);
                    }
                }
            }
        }
    }

    private class MinMax {
        private int _minCoordOffset;
        private int _maxCoordOffset;
        private int _featMinMaxCount;
        private FeatMinMaxRecord[] _featMinMaxRecord;

        MinMax(int n) throws IOException {
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n);
            this._minCoordOffset = dataInput.readUnsignedShort();
            this._maxCoordOffset = dataInput.readUnsignedShort();
            this._featMinMaxCount = dataInput.readUnsignedShort();
            this._featMinMaxRecord = new FeatMinMaxRecord[this._featMinMaxCount];
            for (int i = 0; i < this._featMinMaxCount; ++i) {
                this._featMinMaxRecord[i] = new FeatMinMaxRecord(dataInput);
            }
        }
    }

    private static class FeatMinMaxRecord {
        private int _tag;
        private int _minCoordOffset;
        private int _maxCoordOffset;

        FeatMinMaxRecord(DataInput dataInput) throws IOException {
            this._tag = dataInput.readInt();
            this._minCoordOffset = dataInput.readUnsignedShort();
            this._maxCoordOffset = dataInput.readUnsignedShort();
        }
    }

    private static class BaseCoordFormat3
    extends BaseCoord {
        private short _coordinate;
        private int _deviceTableOffset;

        BaseCoordFormat3(DataInput dataInput) throws IOException {
            this._coordinate = dataInput.readShort();
            this._deviceTableOffset = dataInput.readUnsignedShort();
        }

        @Override
        public int getBaseCoordFormat() {
            return 2;
        }

        @Override
        public short getCoordinate() {
            return this._coordinate;
        }
    }

    private static class BaseCoordFormat2
    extends BaseCoord {
        private short _coordinate;
        private int _referenceGlyph;
        private int _baseCoordPoint;

        BaseCoordFormat2(DataInput dataInput) throws IOException {
            this._coordinate = dataInput.readShort();
            this._referenceGlyph = dataInput.readUnsignedShort();
            this._baseCoordPoint = dataInput.readUnsignedShort();
        }

        @Override
        public int getBaseCoordFormat() {
            return 2;
        }

        @Override
        public short getCoordinate() {
            return this._coordinate;
        }
    }

    private static class BaseCoordFormat1
    extends BaseCoord {
        private short _coordinate;

        BaseCoordFormat1(DataInput dataInput) throws IOException {
            this._coordinate = dataInput.readShort();
        }

        @Override
        public int getBaseCoordFormat() {
            return 1;
        }

        @Override
        public short getCoordinate() {
            return this._coordinate;
        }
    }

    private static abstract class BaseCoord {
        private BaseCoord() {
        }

        public abstract int getBaseCoordFormat();

        public abstract short getCoordinate();
    }
}

