/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.dependencies;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.Convertible;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.library.dependencies.Slice;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class SliceDependency
implements HasDescription,
Convertible {
    private final Slice origin;
    private final SortedSet<Dependency> relevantDependencies;
    private final Slice target;

    static SliceDependency of(Slice origin, Iterable<Dependency> dependenciesToConsider, Slice target) {
        return new SliceDependency(origin, dependenciesToConsider, target);
    }

    private SliceDependency(Slice origin, Iterable<Dependency> dependenciesToConsider, Slice target) {
        this.origin = origin;
        this.relevantDependencies = this.filterTarget(dependenciesToConsider, target);
        this.target = target;
    }

    private SortedSet<Dependency> filterTarget(Iterable<Dependency> dependenciesToConsider, Slice target) {
        return StreamSupport.stream(dependenciesToConsider.spliterator(), false).filter(input -> target.contains(input.getTargetClass())).collect(Collectors.toCollection(TreeSet::new));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Slice getOrigin() {
        return this.origin;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Slice getTarget() {
        return this.target;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        return String.format("%s depends on %s:%n%s", this.origin.getDescription(), this.target.getDescription(), this.joinDependencies(this.relevantDependencies));
    }

    private String joinDependencies(Iterable<Dependency> dependencies) {
        ArrayList<String> parts = new ArrayList<String>();
        for (Dependency dependency : dependencies) {
            parts.add(dependency.getDescription());
        }
        return Joiner.on(System.lineSeparator()).join(parts);
    }

    @Override
    public <T> Set<T> convertTo(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return Collections.singleton(this);
        }
        return this.relevantDependencies.stream().flatMap(it -> it.convertTo(type).stream()).collect(Collectors.toSet());
    }

    public int hashCode() {
        return Objects.hash(this.origin, this.target);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SliceDependency other = (SliceDependency)obj;
        return Objects.equals(this.origin, other.origin) && Objects.equals(this.target, other.target);
    }

    public String toString() {
        return "SliceDependency{origin=" + this.origin + ", target=" + this.target + '}';
    }
}

