/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.cycle_detection.rules;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.Convertible;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.library.cycle_detection.Cycle;
import com.tngtech.archunit.library.cycle_detection.CycleDetector;
import com.tngtech.archunit.library.cycle_detection.Cycles;
import com.tngtech.archunit.library.cycle_detection.Edge;
import com.tngtech.archunit.library.cycle_detection.rules.CycleRuleConfiguration;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Strings;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.MultimapBuilder;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SortedSetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
public final class CycleArchCondition<COMPONENT>
extends ArchCondition<COMPONENT> {
    private static final Logger log = LoggerFactory.getLogger(CycleArchCondition.class);
    private final Function<COMPONENT, Iterable<JavaClass>> getClasses;
    private final Function<COMPONENT, String> getDescription;
    private final Function<COMPONENT, Set<Dependency>> getOutgoingDependencies;
    private final Predicate<Dependency> relevantClassDependenciesPredicate;
    private ClassesToComponentsMapping<COMPONENT> classesToComponentsMapping;
    private ComponentCycleDetector<COMPONENT> cycleDetector;
    private EventRecorder<COMPONENT> eventRecorder;

    private CycleArchCondition(Function<? super COMPONENT, Iterable<JavaClass>> retrieveClasses, Function<? super COMPONENT, String> retrieveDescription, Function<? super COMPONENT, Set<Dependency>> retrieveOutgoingDependencies, Predicate<? super Dependency> relevantClassDependenciesPredicate) {
        super("be free of cycles", new Object[0]);
        this.getClasses = retrieveClasses;
        this.getDescription = retrieveDescription;
        this.getOutgoingDependencies = retrieveOutgoingDependencies;
        this.relevantClassDependenciesPredicate = relevantClassDependenciesPredicate;
    }

    @Override
    public void init(Collection<COMPONENT> allComponents) {
        this.classesToComponentsMapping = new ClassesToComponentsMapping(allComponents, this.getClasses);
        this.cycleDetector = new ComponentCycleDetector<COMPONENT>(allComponents);
        this.eventRecorder = new EventRecorder(this.getDescription);
    }

    @Override
    public void check(COMPONENT component, ConditionEvents events) {
        this.cycleDetector.addEdges(this.createComponentDependencies(component));
    }

    private Set<ComponentDependency<COMPONENT>> createComponentDependencies(COMPONENT component) {
        SortedSetMultimap<COMPONENT, Dependency> targetComponentsWithDependencies = this.targetsOf(component);
        return this.sortedEntries(targetComponentsWithDependencies).stream().map(entry -> new ComponentDependency(component, entry.getKey(), (SortedSet)entry.getValue())).collect(ImmutableSet.toImmutableSet());
    }

    private SortedSetMultimap<COMPONENT, Dependency> targetsOf(COMPONENT component) {
        SetMultimap result = MultimapBuilder.hashKeys().treeSetValues().build();
        this.getOutgoingDependencies.apply(component).stream().filter(this.relevantClassDependenciesPredicate).filter(dependency -> this.classesToComponentsMapping.containsKey(dependency.getTargetClass())).forEach(arg_0 -> this.lambda$targetsOf$2((SortedSetMultimap)result, arg_0));
        return result;
    }

    private Set<Map.Entry<COMPONENT, SortedSet<Dependency>>> sortedEntries(SortedSetMultimap<COMPONENT, Dependency> multimap) {
        return multimap.asMap().entrySet();
    }

    @Override
    public void finish(ConditionEvents events) {
        Cycles<ComponentDependency<COMPONENT>> cycles = this.cycleDetector.findCycles();
        if (cycles.maxNumberOfCyclesReached()) {
            events.setInformationAboutNumberOfViolations(String.format(" >= %d times - the maximum number of cycles to detect has been reached; this limit can be adapted using the `archunit.properties` value `%s=xxx`", cycles.size(), "cycles.maxNumberToDetect"));
        }
        for (Cycle cycle : cycles) {
            this.eventRecorder.record(cycle, events);
        }
        this.releaseResources();
    }

    private void releaseResources() {
        this.classesToComponentsMapping = null;
        this.cycleDetector = null;
        this.eventRecorder = null;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static <COMPONENT> NeedsRetrieveClasses<COMPONENT> builder() {
        return new Builder();
    }

    private /* synthetic */ void lambda$targetsOf$2(SortedSetMultimap result, Dependency dependency) {
        result.put(this.classesToComponentsMapping.get(dependency.getTargetClass()), dependency);
    }

    private static class ClassesToComponentsMapping<COMPONENT> {
        private final Iterable<COMPONENT> allComponents;
        private final Function<COMPONENT, Iterable<JavaClass>> getClassesOfComponent;
        private Map<JavaClass, COMPONENT> mapping;

        private ClassesToComponentsMapping(Iterable<COMPONENT> allComponents, Function<COMPONENT, Iterable<JavaClass>> getClassesOfComponent) {
            this.allComponents = allComponents;
            this.getClassesOfComponent = getClassesOfComponent;
        }

        public COMPONENT get(JavaClass javaClass) {
            return this.mapping().get(javaClass);
        }

        private Map<JavaClass, COMPONENT> mapping() {
            if (this.mapping != null) {
                return this.mapping;
            }
            ImmutableMap.Builder<JavaClass, COMPONENT> result = ImmutableMap.builder();
            for (COMPONENT component : this.allComponents) {
                for (JavaClass javaClass : this.getClassesOfComponent.apply(component)) {
                    result.put(javaClass, component);
                }
            }
            this.mapping = result.build();
            return this.mapping;
        }

        public boolean containsKey(JavaClass javaClass) {
            return this.mapping().containsKey(javaClass);
        }
    }

    private static class ComponentCycleDetector<COMPONENT> {
        private final Collection<COMPONENT> components;
        private final Set<ComponentDependency<COMPONENT>> componentDependencies = new HashSet<ComponentDependency<COMPONENT>>();

        ComponentCycleDetector(Collection<COMPONENT> components) {
            this.components = Preconditions.checkNotNull(components);
        }

        void addEdges(Collection<ComponentDependency<COMPONENT>> componentDependencies) {
            this.componentDependencies.addAll(componentDependencies);
        }

        Cycles<ComponentDependency<COMPONENT>> findCycles() {
            return CycleDetector.detectCycles(this.components, this.componentDependencies);
        }
    }

    private static class EventRecorder<COMPONENT> {
        private static final String CYCLE_DETECTED_SECTION_INTRO = "Cycle detected: ";
        private static final String CYCLE_EDGE_DESCRIPTION_SEPARATOR = " -> " + System.lineSeparator() + Strings.repeat(" ", "Cycle detected: ".length());
        private static final String DEPENDENCY_DETAILS_INDENT = Strings.repeat(" ", 4);
        private final CycleRuleConfiguration cycleConfiguration = new CycleRuleConfiguration();
        private final Function<COMPONENT, String> getDescriptionOfComponent;

        private EventRecorder(Function<COMPONENT, String> getDescriptionOfComponent) {
            this.getDescriptionOfComponent = getDescriptionOfComponent;
            log.trace("Maximum number of dependencies to report per edge is set to {}; this limit can be adapted using the `archunit.properties` value `{}=xxx`", (Object)this.cycleConfiguration.getMaxNumberOfDependenciesToShowPerEdge(), (Object)"cycles.maxNumberOfDependenciesPerEdge");
        }

        void record(Cycle<ComponentDependency<COMPONENT>> cycle, ConditionEvents events) {
            events.add(this.newEvent(cycle));
        }

        private ConditionEvent newEvent(Cycle<ComponentDependency<COMPONENT>> cycle) {
            Map<String, ComponentDependency<COMPONENT>> descriptionsToEdges = this.sortEdgesByDescription(cycle);
            String description = this.createDescription(descriptionsToEdges.keySet());
            String details = this.createDetails(descriptionsToEdges);
            return SimpleConditionEvent.violated(cycle, CYCLE_DETECTED_SECTION_INTRO + description + System.lineSeparator() + details);
        }

        private Map<String, ComponentDependency<COMPONENT>> sortEdgesByDescription(Cycle<ComponentDependency<COMPONENT>> cycle) {
            LinkedList<ComponentDependency<COMPONENT>> edges = new LinkedList<ComponentDependency<COMPONENT>>(cycle.getEdges());
            ComponentDependency<COMPONENT> startEdge = this.findStartEdge(cycle);
            while (!edges.getFirst().equals(startEdge)) {
                edges.addLast(edges.pollFirst());
            }
            LinkedHashMap<String, ComponentDependency<COMPONENT>> descriptionToEdge = new LinkedHashMap<String, ComponentDependency<COMPONENT>>();
            for (ComponentDependency componentDependency : edges) {
                descriptionToEdge.put(this.getDescriptionOfComponent.apply(componentDependency.getOrigin()), componentDependency);
            }
            return descriptionToEdge;
        }

        private ComponentDependency<COMPONENT> findStartEdge(Cycle<ComponentDependency<COMPONENT>> cycle) {
            return cycle.getEdges().stream().min(Comparator.comparing(input -> this.getDescriptionOfComponent.apply(input.getOrigin()))).get();
        }

        private String createDescription(Collection<String> edgeDescriptions) {
            ArrayList<String> descriptions = new ArrayList<String>(edgeDescriptions);
            descriptions.add((String)descriptions.get(0));
            return Joiner.on(CYCLE_EDGE_DESCRIPTION_SEPARATOR).join(descriptions);
        }

        private String createDetails(Map<String, ComponentDependency<COMPONENT>> descriptionsToEdges) {
            ArrayList details = new ArrayList();
            AtomicInteger componentIndex = new AtomicInteger(0);
            descriptionsToEdges.forEach((description, dependencies) -> {
                details.add(String.format("  %d. Dependencies of %s", componentIndex.incrementAndGet(), description));
                details.addAll(this.dependenciesDescription((ComponentDependency<COMPONENT>)dependencies));
            });
            return Joiner.on(System.lineSeparator()).join(details);
        }

        private List<String> dependenciesDescription(ComponentDependency<COMPONENT> edge) {
            int maxDependencies = this.cycleConfiguration.getMaxNumberOfDependenciesToShowPerEdge();
            SortedSet<Dependency> allDependencies = edge.toClassDependencies();
            boolean tooManyDependenciesToDisplay = allDependencies.size() > maxDependencies;
            List result = allDependencies.stream().limit(maxDependencies).map(dependency -> DEPENDENCY_DETAILS_INDENT + "- " + dependency.getDescription()).collect(Collectors.toCollection(ArrayList::new));
            if (tooManyDependenciesToDisplay) {
                result.add(DEPENDENCY_DETAILS_INDENT + String.format("(%d further dependencies have been omitted...)", allDependencies.size() - maxDependencies));
            }
            return result;
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static final class Builder<COMPONENT>
    implements NeedsRetrieveClasses<COMPONENT>,
    NeedsRetrieveDescription<COMPONENT>,
    NeedsRetrieveOutgoingDependencies<COMPONENT> {
        private Function<? super COMPONENT, Iterable<JavaClass>> retrieveClasses;
        private Function<? super COMPONENT, String> retrieveDescription;
        private Function<? super COMPONENT, Set<Dependency>> retrieveOutgoingDependencies;
        private Predicate<? super Dependency> relevantClassDependenciesPredicate = __ -> true;

        private Builder() {
        }

        @Override
        public NeedsRetrieveDescription<COMPONENT> retrieveClassesBy(Function<? super COMPONENT, Iterable<JavaClass>> retrieveClasses) {
            this.retrieveClasses = Preconditions.checkNotNull(retrieveClasses);
            return this;
        }

        @Override
        public NeedsRetrieveOutgoingDependencies<COMPONENT> retrieveDescriptionBy(Function<? super COMPONENT, String> retrieveDescription) {
            this.retrieveDescription = Preconditions.checkNotNull(retrieveDescription);
            return this;
        }

        @Override
        public Builder<COMPONENT> retrieveOutgoingDependenciesBy(Function<? super COMPONENT, Set<Dependency>> retrieveOutgoingDependencies) {
            this.retrieveOutgoingDependencies = Preconditions.checkNotNull(retrieveOutgoingDependencies);
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public Builder<COMPONENT> onlyConsiderDependencies(Predicate<? super Dependency> relevantClassDependenciesPredicate) {
            this.relevantClassDependenciesPredicate = Preconditions.checkNotNull(relevantClassDependenciesPredicate);
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public CycleArchCondition<COMPONENT> build() {
            return new CycleArchCondition(this.retrieveClasses, this.retrieveDescription, this.retrieveOutgoingDependencies, this.relevantClassDependenciesPredicate);
        }
    }

    private static class ComponentDependency<COMPONENT>
    implements Edge<COMPONENT>,
    Convertible {
        private final COMPONENT origin;
        private final COMPONENT target;
        private final SortedSet<Dependency> classDependencies;

        private ComponentDependency(COMPONENT origin, COMPONENT target, SortedSet<Dependency> classDependencies) {
            this.origin = origin;
            this.target = target;
            this.classDependencies = classDependencies;
        }

        @Override
        public COMPONENT getOrigin() {
            return this.origin;
        }

        @Override
        public COMPONENT getTarget() {
            return this.target;
        }

        SortedSet<Dependency> toClassDependencies() {
            return this.classDependencies;
        }

        @Override
        public <T> Set<T> convertTo(Class<T> type) {
            if (type.isAssignableFrom(this.getClass())) {
                return Collections.singleton(this);
            }
            return this.toClassDependencies().stream().flatMap(it -> it.convertTo(type).stream()).collect(Collectors.toSet());
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static interface NeedsRetrieveOutgoingDependencies<COMPONENT> {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public Builder<COMPONENT> retrieveOutgoingDependenciesBy(Function<? super COMPONENT, Set<Dependency>> var1);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static interface NeedsRetrieveDescription<COMPONENT> {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public NeedsRetrieveOutgoingDependencies<COMPONENT> retrieveDescriptionBy(Function<? super COMPONENT, String> var1);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static interface NeedsRetrieveClasses<COMPONENT> {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public NeedsRetrieveDescription<COMPONENT> retrieveClassesBy(Function<? super COMPONENT, Iterable<JavaClass>> var1);
    }
}

