/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util.collection.notifymap;

import net.infonode.util.ValueChange;
import net.infonode.util.collection.map.MapAdapter;
import net.infonode.util.collection.map.base.ConstMapIterator;
import net.infonode.util.collection.map.base.Map;
import net.infonode.util.collection.map.base.MapIterator;
import net.infonode.util.collection.notifymap.AbstractChangeNotifyMap;

public class ChangeNotifyMapWrapper
extends AbstractChangeNotifyMap {
    private Map map;

    public ChangeNotifyMapWrapper(Map map) {
        this.map = map;
    }

    public Map getMap() {
        return this.map;
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Object put(Object key, Object value) {
        Object oldValue = this.map.put(key, value);
        this.fireEntryChanged(key, oldValue, value);
        return oldValue;
    }

    @Override
    public Object remove(Object key) {
        Object oldValue = this.map.remove(key);
        this.fireEntryRemoved(key, oldValue);
        return oldValue;
    }

    @Override
    public void clear() {
        MapAdapter changeMap = new MapAdapter();
        ConstMapIterator iterator = this.map.constIterator();
        while (iterator.atEntry()) {
            changeMap.put(iterator.getKey(), new ValueChange(iterator.getValue(), null));
            iterator.next();
        }
        this.map.clear();
        this.fireEntriesChanged(changeMap);
    }

    @Override
    public MapIterator iterator() {
        return new Iterator(this.map.iterator());
    }

    private class Iterator
    implements MapIterator {
        private MapIterator iterator;

        public Iterator(MapIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            ChangeNotifyMapWrapper.this.fireEntryRemoved(this.iterator.getKey(), this.iterator.getValue());
        }

        @Override
        public Object getKey() {
            return this.iterator.getKey();
        }

        @Override
        public Object getValue() {
            return this.iterator.getValue();
        }

        @Override
        public void next() {
            this.iterator.next();
        }

        @Override
        public boolean atEntry() {
            return this.iterator.atEntry();
        }
    }
}

