/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import net.infonode.gui.ButtonFactory;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.ScrollButtonBoxListener;
import net.infonode.gui.icon.button.ArrowIcon;
import net.infonode.gui.layout.DirectionLayout;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.util.Direction;

public class ScrollButtonBox
extends SimplePanel {
    private AbstractButton upButton;
    private AbstractButton downButton;
    private AbstractButton leftButton;
    private AbstractButton rightButton;
    private boolean button1Enabled;
    private boolean button2Enabled;
    private boolean vertical;
    private ArrayList listeners;
    private ActionListener button1Listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ScrollButtonBox.this.fireButton1();
        }
    };
    private ActionListener button2Listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ScrollButtonBox.this.fireButton2();
        }
    };

    public ScrollButtonBox(boolean vertical, int iconSize) {
        this(vertical, ButtonFactory.createFlatHighlightButton(new ArrowIcon(iconSize, Direction.UP), "", 0, null), ButtonFactory.createFlatHighlightButton(new ArrowIcon(iconSize, Direction.DOWN), "", 0, null), ButtonFactory.createFlatHighlightButton(new ArrowIcon(iconSize, Direction.LEFT), "", 0, null), ButtonFactory.createFlatHighlightButton(new ArrowIcon(iconSize, Direction.RIGHT), "", 0, null));
    }

    public ScrollButtonBox(boolean vertical, AbstractButton upButton, AbstractButton downButton, AbstractButton leftButton, AbstractButton rightButton) {
        this.vertical = vertical;
        this.setLayout(new DirectionLayout(vertical ? Direction.DOWN : Direction.RIGHT));
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() < 0) {
                    ScrollButtonBox.this.fireButton1();
                } else {
                    ScrollButtonBox.this.fireButton2();
                }
            }
        });
        this.setButtons(upButton, downButton, leftButton, rightButton);
    }

    public void setButton1Enabled(boolean enabled) {
        this.button1Enabled = enabled;
        if (this.getComponentCount() > 0) {
            ((AbstractButton)this.getComponent(0)).setEnabled(enabled);
        }
    }

    public void setButton2Enabled(boolean enabled) {
        this.button2Enabled = enabled;
        if (this.getComponentCount() > 0) {
            ((AbstractButton)this.getComponent(1)).setEnabled(enabled);
        }
    }

    public boolean isButton1Enabled() {
        return this.button1Enabled;
    }

    public boolean isButton2Enabled() {
        return this.button2Enabled;
    }

    public void addListener(ScrollButtonBoxListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(listener);
    }

    public void removeListener(ScrollButtonBoxListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        if (vertical != this.vertical) {
            this.vertical = vertical;
            this.initialize();
        }
    }

    public void setButtons(AbstractButton upButton, AbstractButton downButton, AbstractButton leftButton, AbstractButton rightButton) {
        if (upButton != this.upButton || downButton != this.downButton || leftButton != this.leftButton || rightButton != this.rightButton) {
            this.upButton = upButton;
            this.downButton = downButton;
            this.leftButton = leftButton;
            this.rightButton = rightButton;
            this.initialize();
        }
    }

    public AbstractButton getUpButton() {
        return this.upButton;
    }

    public AbstractButton getDownButton() {
        return this.downButton;
    }

    public AbstractButton getLeftButton() {
        return this.leftButton;
    }

    public AbstractButton getRightButton() {
        return this.rightButton;
    }

    private void fireButton1() {
        if (this.listeners != null) {
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((ScrollButtonBoxListener)l[i]).scrollButton1();
                ++i;
            }
        }
    }

    private void fireButton2() {
        if (this.listeners != null) {
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((ScrollButtonBoxListener)l[i]).scrollButton2();
                ++i;
            }
        }
    }

    private void initialize() {
        AbstractButton button2;
        AbstractButton button1;
        if (this.getComponentCount() > 0) {
            ((AbstractButton)this.getComponent(0)).removeActionListener(this.button1Listener);
            ((AbstractButton)this.getComponent(1)).removeActionListener(this.button2Listener);
            this.removeAll();
        }
        ((DirectionLayout)this.getLayout()).setDirection(this.vertical ? Direction.DOWN : Direction.RIGHT);
        if (this.vertical) {
            button1 = this.upButton;
            button2 = this.downButton;
        } else {
            button1 = this.leftButton;
            button2 = this.rightButton;
        }
        if (button1 != null && button2 != null) {
            this.add(button1);
            this.add(button2);
            button1.setFocusable(false);
            button2.setFocusable(false);
            button1.setEnabled(this.button1Enabled);
            button2.setEnabled(this.button2Enabled);
            button1.addActionListener(this.button1Listener);
            button2.addActionListener(this.button2Listener);
        }
        if (this.getParent() != null) {
            ComponentUtil.validate(this.getParent());
        }
    }
}

