/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.knopflerfish.framework.Alias;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.FrameworkFactoryImpl;
import org.knopflerfish.framework.ReferenceURLStreamHandler;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.framework.startlevel.FrameworkStartLevel;

public class Main {
    static Main main;
    int verbosity;
    String version = "<unknown>";
    String topDir = "";
    boolean bZeroArgs;
    boolean saveStartLevel = true;
    public String bootText;
    Map<String, String> fwProps = new HashMap<String, String>();
    Map<String, String> sysProps = new HashMap<String, String>();
    public static final String JARDIR_PROP = "org.knopflerfish.gosg.jars";
    public static final String JARDIR_DEFAULT = "file:jars/;fwresource:jars/";
    public static final String XARGS_INIT = "init.xargs";
    public static final String XARGS_RESTART = "restart.xargs";
    public static final String FWPROPS_XARGS = "fwprops.xargs";
    public static final String CMDIR_PROP = "org.knopflerfish.bundle.cm.store";
    public static final String CMDIR_DEFAULT = "cmdir";
    public static final String VERBOSITY_PROP = "org.knopflerfish.framework.main.verbosity";
    public static final String VERBOSITY_DEFAULT = "0";
    public static final String WRITE_FWPROPS_XARGS_PROP = "org.knopflerfish.framework.main.write.fwprops.xargs";
    public static final String XARGS_WRITESYSPROPS_PROP = "org.knopflerfish.framework.main.xargs.writesysprops";
    public static final String XARGS_DEFAULT = "default";
    public static final String PRODVERSION_PROP = "org.knopflerfish.prodver";
    public static final String BOOT_TEXT_PROP = "org.knopflerfish.framework.main.bootText";
    Map<String, String> defaultFwProps = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Main.CMDIR_PROP, Main.CMDIR_DEFAULT);
        }
    };
    FrameworkFactory ff;
    Framework framework;

    public static void main(String[] args) {
        main = new Main();
        System.out.println(Main.main.bootText);
        main.start(args);
        System.exit(0);
    }

    public Main() {
        try {
            String vpv = System.getProperty(VERBOSITY_PROP);
            this.verbosity = Integer.parseInt(null == vpv ? VERBOSITY_DEFAULT : vpv);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.populateSysProps();
        FrameworkContext.setupURLStreamHandleFactory();
        String tstampYear = Util.readTstampYear();
        this.bootText = "Knopflerfish OSGi framework launcher, version " + this.version + "\n" + "Copyright 2003-" + tstampYear + " Knopflerfish. All Rights Reserved.\n" + "See http://www.knopflerfish.org for more information.\n";
    }

    public Framework start(String[] args) {
        this.version = Util.readFrameworkVersion();
        boolean bl = this.bZeroArgs = args.length == 0;
        if (!this.bZeroArgs) {
            this.bZeroArgs = true;
            for (int i = 0; this.bZeroArgs && i < args.length; ++i) {
                if ("-ff".equals(args[i])) {
                    if (null != this.framework) {
                        throw new IllegalArgumentException("a framework instance is already created.");
                    }
                    if (i + 1 < args.length) {
                        this.ff = this.getFrameworkFactory(args[++i]);
                        continue;
                    }
                    throw new IllegalArgumentException("No framework factory argument");
                }
                this.bZeroArgs = args[i].startsWith("-D") || args[i].startsWith("-F") || "-init".equals(args[i]);
            }
        }
        this.processProperties(args);
        if (this.bZeroArgs) {
            if (0 == args.length) {
                args = new String[]{"--xargs", XARGS_DEFAULT};
            } else {
                String[] newArgs = new String[args.length + 2];
                newArgs[0] = "--xargs";
                newArgs[1] = XARGS_DEFAULT;
                System.arraycopy(args, 0, newArgs, 2, args.length);
                args = newArgs;
            }
        }
        args = this.expandArgs(args);
        return this.handleArgs(args);
    }

    private boolean writeSysProps() {
        String val = this.fwProps.get(XARGS_WRITESYSPROPS_PROP);
        if (val == null) {
            val = this.sysProps.get(XARGS_WRITESYSPROPS_PROP);
        }
        this.println("writeSysProps? '" + val + "'", 2);
        return "true".equals(val);
    }

    public FrameworkFactory getFrameworkFactory() {
        String factoryClassName = FrameworkFactoryImpl.class.getName();
        try {
            String factoryS = new String(Util.readResource("/META-INF/services/org.osgi.framework.launch.FrameworkFactory"), "UTF-8");
            String[] w = Util.splitwords(factoryS, "\n\r");
            for (int i = 0; i < w.length; ++i) {
                if (w[i].length() <= 0 || w[i].startsWith("#")) continue;
                factoryClassName = w[i].trim();
                break;
            }
        }
        catch (Exception e) {
            this.println("failed to get FrameworkFactory, using default", 6, e);
        }
        return this.getFrameworkFactory(factoryClassName);
    }

    public FrameworkFactory getFrameworkFactory(String factoryClassName) {
        try {
            this.println("getFrameworkFactory(" + factoryClassName + ")", 2);
            Class<?> clazz = Class.forName(factoryClassName);
            Constructor<?> cons = clazz.getConstructor(new Class[0]);
            FrameworkFactory ff = (FrameworkFactory)cons.newInstance(new Object[0]);
            return ff;
        }
        catch (Exception e) {
            this.error("failed to create " + factoryClassName, e);
            throw new RuntimeException("failed to create " + factoryClassName + ": " + e);
        }
    }

    URL[] getJarBase() {
        this.assertFramework();
        String jars = this.framework.getBundleContext().getProperty(JARDIR_PROP);
        if (jars == null) {
            jars = JARDIR_DEFAULT;
        }
        String[] ja = Util.splitwords(jars, ";");
        ArrayList<URL> res = new ArrayList<URL>();
        for (int i = 0; i < ja.length; ++i) {
            String u = ja[i].trim();
            try {
                res.add(ReferenceURLStreamHandler.createURL(u));
                this.println("jar base[" + i + "]=" + u, 3);
                continue;
            }
            catch (MalformedURLException ignored) {
                System.err.println("Skip illegal jar base: " + u);
            }
        }
        return res.toArray(new URL[res.size()]);
    }

    void setProperty(String prefix, String arg, Map<String, String> props) {
        int ix = arg.indexOf("=");
        if (ix != -1) {
            String key = arg.substring(2, ix);
            String value = arg.substring(ix + 1);
            this.println(prefix + key + "=" + value, 1);
            props.put(key, value);
            if ("org.osgi.framework.startlevel.beginning".equals(key)) {
                this.saveStartLevel = false;
            }
            if (VERBOSITY_PROP.equals(key)) {
                try {
                    int old = this.verbosity;
                    this.verbosity = Integer.parseInt(value.length() == 0 ? VERBOSITY_DEFAULT : value);
                    if (old != this.verbosity) {
                        this.println("Verbosity changed to " + this.verbosity, 1);
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
    }

    void processProperties(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            try {
                if (args[i].startsWith("-D")) {
                    this.setProperty("-D", args[i], this.sysProps);
                    continue;
                }
                if (args[i].startsWith("-F")) {
                    this.setProperty("-F", args[i], this.fwProps);
                    continue;
                }
                if ("-init".equals(args[i])) {
                    this.fwProps.put("org.osgi.framework.storage.clean", "onFirstInit");
                    continue;
                }
                if ("-launch".equals(args[i])) {
                    this.saveStartLevel = false;
                    continue;
                }
                if (!this.saveStartLevel || i + 1 >= args.length || !"-startlevel".equals(args[i])) continue;
                this.fwProps.put("org.osgi.framework.startlevel.beginning", args[i + 1]);
                this.saveStartLevel = false;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.error("Command \"" + args[i] + "\" failed, " + e.getMessage());
            }
        }
    }

    private void save_restart_props(Map<String, String> props) {
        String ro = this.framework.getBundleContext().getProperty("org.knopflerfish.framework.readonly");
        if ("true".equalsIgnoreCase(ro)) {
            return;
        }
        String xrwp = this.framework.getBundleContext().getProperty(WRITE_FWPROPS_XARGS_PROP);
        if ("false".equalsIgnoreCase(xrwp)) {
            return;
        }
        PrintWriter pr = null;
        try {
            String fwDirStr = Util.getFrameworkDir(props);
            File fwDir = new File(fwDirStr);
            fwDir.mkdirs();
            File propsFile = new File(fwDir, FWPROPS_XARGS);
            pr = new PrintWriter(new BufferedWriter(new FileWriter(propsFile)));
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if ("org.osgi.framework.storage.clean".equals(key) && "onFirstInit".equals(value)) continue;
                pr.println("-F" + key + "=" + value);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException("Failed to create fwprops.xargs: " + e);
        }
        finally {
            if (null != pr) {
                pr.close();
            }
        }
    }

    void assertFramework() {
        if (this.ff == null) {
            this.ff = this.getFrameworkFactory();
            this.println("Created FrameworkFactory " + this.ff.getClass().getName(), 1);
        }
        if (this.framework == null) {
            this.finalizeProperties();
            this.framework = this.ff.newFramework(this.fwProps);
            try {
                this.framework.init();
                this.save_restart_props(this.fwProps);
                this.fwProps.put(BOOT_TEXT_PROP, this.bootText);
            }
            catch (BundleException be) {
                this.error("Failed to initialize the framework: " + be.getMessage(), be);
            }
            this.println("Framework class " + this.framework.getClass().getName(), 1);
            System.out.println("Created Framework: " + this.framework.getSymbolicName() + ", version=" + this.framework.getVersion() + ".");
        }
    }

    private Framework handleArgs(String[] args) {
        File propsFile;
        boolean bLaunched = false;
        if (!"onFirstInit".equals(this.fwProps.get("org.osgi.framework.storage.clean")) && (propsFile = new File(Util.getFrameworkDir(this.fwProps), FWPROPS_XARGS)).exists()) {
            String[] newArgs = new String[args.length + 2];
            newArgs[0] = "-xargs";
            newArgs[1] = propsFile.getAbsolutePath();
            System.arraycopy(args, 0, newArgs, 2, args.length);
            args = this.expandArgs(newArgs);
        }
        this.processProperties(args);
        if (this.verbosity > 5) {
            for (int i = 0; i < args.length; ++i) {
                this.println("argv[" + i + "]=" + args[i], 5);
            }
        }
        boolean bg = false;
        for (int i = 0; i < args.length; ++i) {
            try {
                Bundle b;
                if ("-bg".equals(args[i])) {
                    this.println("Background mode.", 0);
                    bg = true;
                    continue;
                }
                if ("-exit".equals(args[i])) {
                    this.println("Exit.", 0);
                    System.exit(0);
                    continue;
                }
                if (args[i].startsWith("-F") || args[i].startsWith("-D") || "-init".equals(args[i])) continue;
                if ("-version".equals(args[i])) {
                    System.out.println("Knopflerfish release: " + Main.readRelease());
                    System.out.println("Framework version: " + Util.readFrameworkVersion());
                    this.printResource("/tstamp");
                    System.exit(0);
                    continue;
                }
                if ("-help".equals(args[i])) {
                    this.printResource("/help.txt");
                    System.exit(0);
                    continue;
                }
                if ("-jvminfo".equals(args[i])) {
                    this.assertFramework();
                    this.printJVMInfo(this.framework);
                    System.exit(0);
                    continue;
                }
                if ("-ff".equals(args[i])) {
                    ++i;
                    continue;
                }
                if ("-create".equals(args[i])) {
                    if (null != this.framework && (4 & this.framework.getState()) == 0) {
                        throw new IllegalArgumentException("a framework instance is already created. The '-create' command must either be the first command or come directly after a '-shutdown mSEC' command.");
                    }
                    this.framework = null;
                    continue;
                }
                if ("-install".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        String bundle = args[i + 1];
                        Bundle b2 = this.framework.getBundleContext().installBundle(this.completeLocation(bundle), null);
                        this.println("Installed: ", b2);
                        ++i;
                        continue;
                    }
                    this.error("No URL for install command");
                    continue;
                }
                if ("-istart".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        String bundle = args[i + 1];
                        Bundle b3 = this.framework.getBundleContext().installBundle(this.completeLocation(bundle), null);
                        b3.start(2);
                        this.println("Installed and started (policy): ", b3);
                        ++i;
                        continue;
                    }
                    this.error("No URL for install command");
                    continue;
                }
                if ("-launch".equals(args[i])) {
                    bLaunched = this.doLaunch();
                    continue;
                }
                if ("-shutdown".equals(args[i])) {
                    if (i + 1 < args.length) {
                        long timeout = Long.parseLong(args[++i]);
                        try {
                            if (this.framework != null) {
                                this.framework.stop();
                                FrameworkEvent stopEvent = this.framework.waitForStop(timeout);
                                switch (stopEvent.getType()) {
                                    case 64: {
                                        this.println("Framework terminated", 0);
                                        break;
                                    }
                                    case 128: {
                                        this.println("Framework stopped for update", 0);
                                        break;
                                    }
                                    case 256: {
                                        this.println("Framework stopped for bootclasspath update", 0);
                                        break;
                                    }
                                    case 2: {
                                        this.error("Fatal framework error, terminating.", stopEvent.getThrowable());
                                        break;
                                    }
                                    case 512: {
                                        this.error("Framework waitForStop(" + timeout + ") timed out!", stopEvent.getThrowable());
                                    }
                                }
                            } else {
                                throw new IllegalArgumentException("No framework to shutdown");
                            }
                            this.println("Framework shutdown", 0);
                        }
                        catch (Exception e) {
                            this.error("Failed to shutdown", e);
                        }
                        continue;
                    }
                    this.error("No timout for shutdown command");
                    continue;
                }
                if ("-sleep".equals(args[i])) {
                    if (i + 1 < args.length) {
                        long t = Long.parseLong(args[i + 1]);
                        try {
                            this.println("Sleeping " + t + " seconds...", 0);
                            Thread.sleep(t * 1000L);
                        }
                        catch (InterruptedException e) {
                            this.error("Sleep interrupted.");
                        }
                        ++i;
                        continue;
                    }
                    this.error("No time for sleep command");
                    continue;
                }
                if ("-start".equals(args[i])) {
                    i = this.doStartBundle(args, i, 2, "Started (policy): ");
                    continue;
                }
                if ("-start_e".equals(args[i])) {
                    i = this.doStartBundle(args, i, 0, "Started (eager): ");
                    continue;
                }
                if ("-start_et".equals(args[i])) {
                    i = this.doStartBundle(args, i, 1, "Started (eager,transient): ");
                    continue;
                }
                if ("-start_pt".equals(args[i])) {
                    i = this.doStartBundle(args, i, 3, "Start (policy,transient): ");
                    continue;
                }
                if ("-stop".equals(args[i])) {
                    i = this.doStopBundle(args, i, 0);
                    continue;
                }
                if ("-stop_t".equals(args[i])) {
                    i = this.doStopBundle(args, i, 1);
                    continue;
                }
                if ("-uninstall".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        long id = this.getBundleID(this.framework, args[i + 1]);
                        b = this.framework.getBundleContext().getBundle(id);
                        b.uninstall();
                        this.println("Uninstalled: ", b);
                        ++i;
                        continue;
                    }
                    this.error("No id for uninstall command");
                    continue;
                }
                if ("-update".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        Bundle[] bl = null;
                        bl = "ALL".equals(args[i + 1]) ? this.framework.getBundleContext().getBundles() : new Bundle[]{this.framework.getBundleContext().getBundle(this.getBundleID(this.framework, args[i + 1]))};
                        for (int n = 0; bl != null && n < bl.length; ++n) {
                            b = bl[n];
                            b.update();
                            this.println("Updated: ", b);
                        }
                        ++i;
                        continue;
                    }
                    this.error("No id for update command");
                    continue;
                }
                if ("-initlevel".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        int n = Integer.parseInt(args[i + 1]);
                        FrameworkStartLevel fsl = this.framework.adapt(FrameworkStartLevel.class);
                        if (fsl != null) {
                            fsl.setInitialBundleStartLevel(n);
                        }
                        ++i;
                        continue;
                    }
                    this.error("No integer level for initlevel command");
                    continue;
                }
                if ("-startlevel".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        int n = Integer.parseInt(args[i + 1]);
                        if ((0x20 & this.framework.getState()) != 0) {
                            FrameworkStartLevel fsl = this.framework.adapt(FrameworkStartLevel.class);
                            if (fsl != null) {
                                fsl.setStartLevel(n, new FrameworkListener[0]);
                            }
                        } else {
                            this.error("Startlevel command not available before framework started.\nUse property 'org.osgi.framework.startlevel.beginning' instead");
                        }
                        ++i;
                        continue;
                    }
                    this.error("No integer level for startlevel command");
                    continue;
                }
                this.error("Unknown option: " + args[i] + "\nUse option -help to see all options");
                continue;
            }
            catch (BundleException e) {
                Throwable ne = e.getNestedException();
                if (ne != null) {
                    e.getNestedException().printStackTrace(System.err);
                } else {
                    e.printStackTrace(System.err);
                }
                this.error("Command \"" + args[i] + (i + 1 < args.length && !args[i + 1].startsWith("-") ? " " + args[i + 1] : "") + "\" failed, " + e.getMessage());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.error("Command \"" + args[i] + (i + 1 < args.length && !args[i + 1].startsWith("-") ? " " + args[i + 1] : "") + "\" failed, " + e.getMessage());
            }
        }
        this.assertFramework();
        if (!bLaunched) {
            try {
                bLaunched = this.doLaunch();
            }
            catch (Throwable t) {
                BundleException be;
                Throwable ne;
                if (t instanceof BundleException && (ne = (be = (BundleException)t).getNestedException()) != null) {
                    t = ne;
                }
                this.error("Framework launch failed, " + t.getMessage(), t);
            }
        }
        if (bg) {
            return this.framework;
        }
        FrameworkEvent stopEvent = null;
        while (true) {
            try {
                while (true) {
                    stopEvent = this.framework.waitForStop(0L);
                    switch (stopEvent.getType()) {
                        case 64: {
                            this.println("Framework terminated", 0);
                            return this.framework;
                        }
                        case 128: {
                            break;
                        }
                        case 256: {
                            return this.framework;
                        }
                        case 2: {
                            this.error("Fatal framework error, terminating.", stopEvent.getThrowable());
                            return this.framework;
                        }
                        case 512: {
                            this.error("Framework waitForStop(0) timed out!", stopEvent.getThrowable());
                        }
                    }
                }
            }
            catch (InterruptedException ie) {
                continue;
            }
            break;
        }
    }

    private int doStopBundle(String[] args, int i, int options) {
        this.assertFramework();
        if (i + 1 < args.length) {
            long id = this.getBundleID(this.framework, args[i + 1]);
            Bundle b = this.framework.getBundleContext().getBundle(id);
            try {
                b.stop(options);
                this.println("Stopped: ", b);
            }
            catch (Exception e) {
                this.error("Failed to stop", e);
            }
            ++i;
        } else {
            this.error("No ID for stop command");
        }
        return i;
    }

    private boolean doLaunch() throws BundleException {
        if (null != this.framework && (0x20 & this.framework.getState()) != 0) {
            throw new IllegalArgumentException("a framework instance is already active.");
        }
        this.assertFramework();
        this.framework.start();
        boolean bLaunched = true;
        this.closeSplash();
        this.println("Framework launched", 0);
        return bLaunched;
    }

    private int doStartBundle(String[] args, int i, int options, String logMsg) throws BundleException {
        this.assertFramework();
        if (i + 1 < args.length) {
            long id = this.getBundleID(this.framework, args[i + 1]);
            Bundle b = this.framework.getBundleContext().getBundle(id);
            b.start(options);
            this.println(logMsg, b);
            ++i;
        } else {
            this.error("No ID for start command");
        }
        return i;
    }

    private long getBundleID(Framework fw, String idLocation) {
        try {
            return Long.parseLong(idLocation);
        }
        catch (NumberFormatException nfe) {
            Bundle[] bl = fw.getBundleContext().getBundles();
            String loc = this.completeLocation(idLocation);
            for (int i = 0; bl != null && i < bl.length; ++i) {
                if (!loc.equals(bl[i].getLocation())) continue;
                return bl[i].getBundleId();
            }
            throw new IllegalArgumentException("Invalid bundle id/location: " + idLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String completeLocation(String location) {
        int ic;
        if (location.startsWith("file:jars/") && !this.topDir.equals("")) {
            location = ("file:" + this.topDir + "/" + location.substring(5)).replace('\\', '/');
            this.println("mangled bundle location to " + location, 2);
        }
        if ((ic = location.indexOf(":")) < 2 || ic > location.indexOf("/")) {
            this.println("location=" + location, 2);
            URL[] base = this.getJarBase();
            for (int i = 0; i < base.length; ++i) {
                this.println("base[" + i + "]=" + base[i], 2);
                try {
                    URL url = new URL(base[i], location);
                    this.println("check " + url, 2);
                    if ("file".equals(url.getProtocol())) {
                        File f = new File(url.getFile()).getAbsoluteFile();
                        if (!f.exists() || !f.canRead()) {
                            continue;
                        }
                    } else if ("http".equals(url.getProtocol())) {
                        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
                        uc.connect();
                        int rc = uc.getResponseCode();
                        uc.disconnect();
                        if (rc != 200) {
                            this.println("Can't access HTTP bundle: " + url + ", response code=" + rc, 0);
                            continue;
                        }
                    } else {
                        InputStream is = null;
                        try {
                            is = url.openStream();
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    location = url.toString();
                    this.println("found location=" + location, 5);
                    break;
                }
                catch (Exception _ignore) {
                    // empty catch block
                }
            }
        }
        return location;
    }

    String[] expandArgs(String[] argv) {
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < argv.length; ++i) {
            if ("-xargs".equals(argv[i]) || "--xargs".equals(argv[i])) {
                boolean bIgnoreException = argv[i].equals("--xargs");
                if (i + 1 < argv.length) {
                    String xargsPath = argv[i + 1];
                    ++i;
                    try {
                        String[] r;
                        String[] moreArgs = this.loadArgs(xargsPath, argv);
                        for (String element : r = this.expandArgs(moreArgs)) {
                            v.add(element);
                        }
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (bIgnoreException) {
                            this.println("Failed to load --xargs " + xargsPath, 1, e);
                            continue;
                        }
                        throw e;
                    }
                }
                throw new IllegalArgumentException("-xargs without argument");
            }
            v.add(argv[i]);
        }
        String[] r = new String[v.size()];
        v.toArray(r);
        return r;
    }

    void printResource(String name) {
        try {
            System.out.println(new String(Util.readResource(name)));
        }
        catch (Exception e) {
            System.out.println("No resource '" + name + "' available");
        }
    }

    void printJVMInfo(Framework framework) {
        try {
            String[] keys;
            Properties props = System.getProperties();
            System.out.println("--- System properties ---");
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                System.out.println(key + ": " + props.get(key));
            }
            System.out.println("\n");
            System.out.println("--- Framework properties ---");
            String keyStr = framework.getBundleContext().getProperty("org.knopflerfish.framework.bundleprops.keys");
            for (String key : keys = Util.splitwords(keyStr != null ? keyStr : "", ",")) {
                System.out.println(key + ": " + framework.getBundleContext().getProperty(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String readRelease() {
        return Util.readResource("/release", "0.0.0.snapshot", "UTF-8");
    }

    BufferedReader getDefaultXArgs() throws IOException {
        String[] stringArray;
        File[] dirs;
        File[] fileArray;
        boolean bInit = "onFirstInit".equals(this.fwProps.get("org.osgi.framework.storage.clean"));
        String fwDirStr = Util.getFrameworkDir(this.fwProps);
        File fwDir = new File(new File(fwDirStr).getAbsolutePath());
        this.println("fwdir is " + fwDir, 1);
        if (!bInit) {
            boolean bl = bInit = !fwDir.exists() || !fwDir.isDirectory();
            if (bInit) {
                this.println("Implicit -init since fwdir does not exist.", 2);
            }
        }
        this.println("init is " + bInit, 2);
        String defDirStr = fwDir.getParent();
        File defDir = defDirStr != null ? new File(defDirStr) : null;
        this.println("defDir=" + defDir, 5);
        if (null != defDir) {
            File[] fileArray2 = new File[2];
            fileArray2[0] = fwDir;
            fileArray = fileArray2;
            fileArray2[1] = defDir;
        } else {
            File[] fileArray3 = new File[1];
            fileArray = fileArray3;
            fileArray3[0] = fwDir;
        }
        for (File dir : dirs = fileArray) {
            File jarsDir = new File(dir, "jars");
            if (!jarsDir.exists() || !jarsDir.isDirectory()) continue;
            this.topDir = dir.getAbsolutePath();
            break;
        }
        this.println("Knopflerfish root directory is " + this.topDir, 2);
        String osName = Alias.unifyOsName(System.getProperty("os.name"));
        if (bInit) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "init_" + osName + ".xargs";
            stringArray2[1] = XARGS_INIT;
            stringArray = stringArray2;
            stringArray2[2] = "remote-init.xargs";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = XARGS_RESTART;
        }
        String[] xargNames = stringArray;
        String xargsFound = null;
        this.println("Searching for default xargs file:", 5);
        block3: for (int i = 0; i < dirs.length; ++i) {
            for (int k = 0; k < xargNames.length; ++k) {
                File xargsFile = new File(dirs[i], xargNames[k]);
                this.println("  trying " + xargsFile.getAbsolutePath(), 5);
                if (!xargsFile.exists()) continue;
                xargsFound = xargsFile.getAbsolutePath();
                break block3;
            }
        }
        if (xargsFound != null) {
            this.println("default xargs file is " + xargsFound, 2);
            return this.getXargsReader(xargsFound);
        }
        IOException failure = null;
        for (int i = 0; i < xargNames.length; ++i) {
            try {
                return this.getXargsReader(xargNames[i]);
            }
            catch (IOException e) {
                failure = e;
                continue;
            }
        }
        throw failure;
    }

    protected void addDefaultProps() {
        String jars;
        for (Map.Entry<String, String> entry : this.defaultFwProps.entrySet()) {
            String key = entry.getKey();
            if (!this.fwProps.containsKey(key)) {
                String val = entry.getValue();
                this.println("Using default " + key + "=" + val, 1);
                this.fwProps.put(key, val);
                continue;
            }
            this.println("framework prop " + key + "=" + this.fwProps.get(key), 1);
        }
        if (null == this.fwProps.get(PRODVERSION_PROP)) {
            this.fwProps.put(PRODVERSION_PROP, this.version);
        }
        if ((jars = this.fwProps.get(JARDIR_PROP)) == null) {
            jars = this.sysProps.get(JARDIR_PROP);
        }
        if (jars != null && !"".equals(jars)) {
            this.println("old jars=" + jars, 1);
        } else {
            String jarBaseDir = this.topDir + File.separator + "jars";
            this.println("jarBaseDir=" + jarBaseDir, 2);
            File jarDir = new File(new File(jarBaseDir).getAbsolutePath());
            if (jarDir.exists() && jarDir.isDirectory()) {
                String[] names = jarDir.list();
                ArrayList<String> v = new ArrayList<String>();
                for (String name : names) {
                    File f = new File(jarDir, name);
                    if (!f.isDirectory()) continue;
                    v.add(name);
                }
                String[] subdirs = new String[v.size()];
                v.toArray(subdirs);
                StringBuffer sb = new StringBuffer();
                sb.append("file:" + jarBaseDir + "/");
                for (String subdir : subdirs) {
                    sb.append(";file:" + jarBaseDir + "/" + subdir + "/");
                }
                sb.append("fwresource:jars/");
                jars = sb.toString().replace('\\', '/');
                this.fwProps.put(JARDIR_PROP, jars);
                this.println("scanned org.knopflerfish.gosg.jars=" + jars, 2);
            }
        }
    }

    void populateSysProps() {
        Properties systemProperties = System.getProperties();
        Enumeration<?> systemPropertiesNames = systemProperties.propertyNames();
        while (systemPropertiesNames.hasMoreElements()) {
            try {
                String name = (String)systemPropertiesNames.nextElement();
                String value = systemProperties.getProperty(name);
                this.sysProps.put(name, value);
                if ("org.osgi.framework.startlevel.beginning".equals(name)) {
                    this.saveStartLevel = false;
                }
                this.println("Initial system property: " + name + "=" + value, 3);
            }
            catch (Exception e) {
                this.println("Failed to process system property: " + e, 1, e);
            }
        }
    }

    void mergeSystemProperties(Map<String, String> props) {
        Properties p = System.getProperties();
        p.putAll(props);
        System.setProperties(p);
    }

    void finalizeProperties() {
        this.expandPropValues(this.sysProps, null);
        this.expandPropValues(this.fwProps, this.sysProps);
        this.addDefaultProps();
        this.mergeSystemProperties(this.sysProps);
        if (this.writeSysProps()) {
            this.mergeSystemProperties(this.fwProps);
            this.println("merged Framework to System properties " + this.fwProps, 2);
        }
    }

    void expandPropValues(Map<String, String> toExpand, Map<String, String> fallback) {
        HashMap<String, String> all = null;
        for (Map.Entry<String, String> entry : toExpand.entrySet()) {
            String value = entry.getValue();
            if (-1 == value.indexOf("${")) continue;
            if (null == all) {
                all = new HashMap<String, String>();
                if (null != fallback) {
                    all.putAll(fallback);
                }
                all.putAll(toExpand);
            }
            for (Map.Entry allEntry : all.entrySet()) {
                String rk = "${" + (String)allEntry.getKey() + "}";
                String rv = (String)allEntry.getValue();
                value = Util.replace(value, rk, rv);
            }
            entry.setValue(value);
            this.println("Expanded property: " + entry.getKey() + "=" + value, 1);
        }
    }

    private void addArg(List<String> args, String arg) {
        if (0 == args.size()) {
            args.add(arg);
        } else {
            String lastArg = args.get(args.size() - 1);
            if ("-xargs".equals(lastArg) || "--xargs".equals(lastArg)) {
                String[] exArgs = this.expandArgs(new String[]{lastArg, arg});
                args.remove(args.size() - 1);
                for (String exArg : exArgs) {
                    args.add(exArg);
                }
            } else {
                args.add(arg);
            }
        }
    }

    String[] loadArgs(String xargsPath, String[] oldArgs) {
        ArrayList<String> v = new ArrayList<String>();
        BufferedReader in = null;
        try {
            if (XARGS_DEFAULT.equals(xargsPath)) {
                this.processProperties(oldArgs);
                in = this.getDefaultXArgs();
            } else {
                in = this.getXargsReader(xargsPath);
            }
            StringBuffer contLine = new StringBuffer();
            String line = null;
            String tmpline = null;
            tmpline = in.readLine();
            while (tmpline != null) {
                if ((tmpline = tmpline.trim()).endsWith("\\")) {
                    tmpline = tmpline.substring(0, tmpline.length() - 1);
                    if (contLine == null) {
                        contLine = new StringBuffer(tmpline);
                    } else {
                        contLine.append(tmpline);
                    }
                } else {
                    if (contLine != null) {
                        contLine.append(tmpline);
                        line = contLine.toString();
                        contLine = null;
                    } else {
                        line = tmpline;
                    }
                    if (line.startsWith("-D")) {
                        this.addArg(v, line);
                    } else if (line.startsWith("-F")) {
                        this.addArg(v, line);
                    } else if (!line.startsWith("#")) {
                        if (line.startsWith("-")) {
                            int i = line.indexOf(32);
                            if (i != -1) {
                                this.addArg(v, line.substring(0, i));
                                line = line.substring(i).trim();
                                if (line.length() > 0) {
                                    this.addArg(v, line);
                                }
                            } else {
                                this.addArg(v, line);
                            }
                        } else if (line.length() > 0) {
                            this.addArg(v, line);
                        }
                    }
                }
                tmpline = in.readLine();
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException("xargs loading failed: " + e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
        String[] args2 = new String[v.size()];
        v.toArray(args2);
        return args2;
    }

    private BufferedReader getXargsReader(String xargsPath) throws IOException {
        File f;
        File defDir;
        BufferedReader in = null;
        this.println("Searching for xargs file with '" + xargsPath + "'.", 2);
        String fwDirStr = Util.getFrameworkDir(this.fwProps);
        File fwDir = new File(new File(fwDirStr).getAbsolutePath());
        String defDirStr = fwDir.getParent();
        File file = defDir = defDirStr != null ? new File(defDirStr) : null;
        if (null != defDir) {
            f = new File(new File(defDir, xargsPath).getAbsolutePath());
            this.println(" trying " + f, 5);
            if (f.exists()) {
                this.println("Loading xargs file " + f, 1);
                in = new BufferedReader(new FileReader(f));
            }
        }
        if (null == in) {
            f = new File(new File(xargsPath).getAbsolutePath());
            this.println(" trying " + f, 5);
            if (f.exists()) {
                this.println("Loading xargs file " + f, 1);
                in = new BufferedReader(new FileReader(f));
            }
        }
        if (in == null && xargsPath.indexOf(58) != -1) {
            try {
                this.println(" trying URL " + xargsPath, 5);
                URL url = new URL(xargsPath);
                this.println("Loading xargs url " + url, 1);
                in = new BufferedReader(new InputStreamReader(url.openStream()));
            }
            catch (MalformedURLException _ignore) {
                // empty catch block
            }
        }
        if (null == in) {
            for (ClassLoader cl = this.getClass().getClassLoader(); cl != null; cl = cl.getParent()) {
                InputStream is = cl.getResourceAsStream(xargsPath);
                if (is == null) continue;
                in = new BufferedReader(new InputStreamReader(is));
                break;
            }
        }
        if (null == in) {
            throw new FileNotFoundException("Didn't find xargs file: " + xargsPath);
        }
        return in;
    }

    void closeSplash() {
        try {
            Class<?> splashScreenCls = Class.forName("java.awt.SplashScreen");
            Method getSplashScreenMethod = splashScreenCls.getMethod("getSplashScreen", null);
            Object splashScreen = getSplashScreenMethod.invoke((Object)null, (Object[])null);
            if (null != splashScreen) {
                Method closeMethod = splashScreenCls.getMethod("close", null);
                closeMethod.invoke(splashScreen, (Object[])null);
            }
        }
        catch (Exception e) {
            this.println("close splash screen: ", 6, e);
        }
    }

    void println(String s, int level) {
        this.println(s, level, null);
    }

    void println(String s, Bundle b) {
        this.println(s + b.getLocation() + " (id#" + b.getBundleId() + ")", 1);
    }

    void println(String s, int level, Exception e) {
        if (this.verbosity >= level) {
            System.out.println((level > 0 ? "#" + level + ": " : "") + s);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    void error(String s) {
        this.error(s, null);
    }

    void error(String s, Throwable t) {
        System.err.println("Error: " + s);
        if (t != null) {
            t.printStackTrace();
        }
        System.exit(1);
    }
}

