/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oceanbase.model;

import java.sql.ResultSet;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLEngine;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPrivilege;
import org.jkiss.dbeaver.ext.oceanbase.model.OceanbaseMySQLCatalog;
import org.jkiss.dbeaver.ext.oceanbase.model.plan.OceanbasePlanAnalyzer;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStandardValueHandlerProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class OceanbaseMySQLDataSource
extends MySQLDataSource {
    private final String tenantType;

    public OceanbaseMySQLDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container);
        this.tenantType = container.getConnectionConfiguration().getProviderProperty("tenantType");
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBCQueryPlanner.class) {
            return adapter.cast((Object)new OceanbasePlanAnalyzer(this));
        }
        if (adapter == DBDValueHandlerProvider.class) {
            return adapter.cast(new JDBCStandardValueHandlerProvider());
        }
        return (T)super.getAdapter(adapter);
    }

    public MySQLEngine getEngine(String name) {
        return (MySQLEngine)DBUtils.findObject((Collection)this.getEngines(), (String)name, (boolean)true);
    }

    public MySQLEngine getDefaultEngine() {
        return this.getEngine("oceanbase");
    }

    public MySQLPrivilege getPrivilege(DBRProgressMonitor monitor, String name) throws DBException {
        if (name.equalsIgnoreCase("SHOW DB")) {
            return (MySQLPrivilege)DBUtils.findObject((Collection)this.getPrivileges(monitor), (String)"Show databases", (boolean)true);
        }
        return (MySQLPrivilege)DBUtils.findObject((Collection)this.getPrivileges(monitor), (String)name, (boolean)true);
    }

    public boolean isMySQLMode() {
        return this.tenantType.equals("MySQL");
    }

    @NotNull
    public Class<? extends MySQLCatalog> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) {
        return OceanbaseMySQLCatalog.class;
    }

    @NotNull
    public MySQLCatalog createCatalogInstance(@NotNull MySQLDataSource owner, @NotNull JDBCResultSet resultSet) {
        return new OceanbaseMySQLCatalog(owner, (ResultSet)resultSet);
    }

    public boolean supportsInformationSchema() {
        return true;
    }

    public boolean supportsPartitions() {
        return this.isServerVersionAtLeast(5, 1);
    }
}

