﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/swf/SWF_EXPORTS.h>
#include <aws/swf/model/ChildPolicy.h>
#include <aws/swf/model/WorkflowExecutionTerminatedCause.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SWF {
namespace Model {

/**
 * <p>Provides the details of the <code>WorkflowExecutionTerminated</code>
 * event.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/swf-2012-01-25/WorkflowExecutionTerminatedEventAttributes">AWS
 * API Reference</a></p>
 */
class WorkflowExecutionTerminatedEventAttributes {
 public:
  AWS_SWF_API WorkflowExecutionTerminatedEventAttributes() = default;
  AWS_SWF_API WorkflowExecutionTerminatedEventAttributes(Aws::Utils::Json::JsonView jsonValue);
  AWS_SWF_API WorkflowExecutionTerminatedEventAttributes& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SWF_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The reason provided for the termination.</p>
   */
  inline const Aws::String& GetReason() const { return m_reason; }
  inline bool ReasonHasBeenSet() const { return m_reasonHasBeenSet; }
  template <typename ReasonT = Aws::String>
  void SetReason(ReasonT&& value) {
    m_reasonHasBeenSet = true;
    m_reason = std::forward<ReasonT>(value);
  }
  template <typename ReasonT = Aws::String>
  WorkflowExecutionTerminatedEventAttributes& WithReason(ReasonT&& value) {
    SetReason(std::forward<ReasonT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The details provided for the termination.</p>
   */
  inline const Aws::String& GetDetails() const { return m_details; }
  inline bool DetailsHasBeenSet() const { return m_detailsHasBeenSet; }
  template <typename DetailsT = Aws::String>
  void SetDetails(DetailsT&& value) {
    m_detailsHasBeenSet = true;
    m_details = std::forward<DetailsT>(value);
  }
  template <typename DetailsT = Aws::String>
  WorkflowExecutionTerminatedEventAttributes& WithDetails(DetailsT&& value) {
    SetDetails(std::forward<DetailsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The policy used for the child workflow executions of this workflow
   * execution.</p> <p>The supported child policies are:</p> <ul> <li> <p>
   * <code>TERMINATE</code> – The child executions are terminated.</p> </li> <li> <p>
   * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child
   * execution by recording a <code>WorkflowExecutionCancelRequested</code> event in
   * its history. It is up to the decider to take appropriate actions when it
   * receives an execution history with this event.</p> </li> <li> <p>
   * <code>ABANDON</code> – No action is taken. The child executions continue to
   * run.</p> </li> </ul>
   */
  inline ChildPolicy GetChildPolicy() const { return m_childPolicy; }
  inline bool ChildPolicyHasBeenSet() const { return m_childPolicyHasBeenSet; }
  inline void SetChildPolicy(ChildPolicy value) {
    m_childPolicyHasBeenSet = true;
    m_childPolicy = value;
  }
  inline WorkflowExecutionTerminatedEventAttributes& WithChildPolicy(ChildPolicy value) {
    SetChildPolicy(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If set, indicates that the workflow execution was automatically terminated,
   * and specifies the cause. This happens if the parent workflow execution times out
   * or is terminated and the child policy is set to terminate child executions.</p>
   */
  inline WorkflowExecutionTerminatedCause GetCause() const { return m_cause; }
  inline bool CauseHasBeenSet() const { return m_causeHasBeenSet; }
  inline void SetCause(WorkflowExecutionTerminatedCause value) {
    m_causeHasBeenSet = true;
    m_cause = value;
  }
  inline WorkflowExecutionTerminatedEventAttributes& WithCause(WorkflowExecutionTerminatedCause value) {
    SetCause(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_reason;
  bool m_reasonHasBeenSet = false;

  Aws::String m_details;
  bool m_detailsHasBeenSet = false;

  ChildPolicy m_childPolicy{ChildPolicy::NOT_SET};
  bool m_childPolicyHasBeenSet = false;

  WorkflowExecutionTerminatedCause m_cause{WorkflowExecutionTerminatedCause::NOT_SET};
  bool m_causeHasBeenSet = false;
};

}  // namespace Model
}  // namespace SWF
}  // namespace Aws
