/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.crypt;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.wicket.core.random.ISecureRandomSupplier;
import org.apache.wicket.core.util.crypt.AbstractJceCrypt;
import org.apache.wicket.util.lang.Args;

public class AESCrypt
extends AbstractJceCrypt {
    private final SecretKey secretKey;
    private final String algorithm;
    private final ISecureRandomSupplier randomSupplier;

    public AESCrypt(SecretKey secretKey, ISecureRandomSupplier randomSupplier) {
        this(secretKey, "AES/CBC/PKCS5Padding", randomSupplier);
    }

    public AESCrypt(SecretKey secretKey, String algorithm, ISecureRandomSupplier randomSupplier) {
        Args.notNull(secretKey, "secretKey");
        Args.notNull(algorithm, "algorithm");
        Args.notNull(randomSupplier, "randomSupplier");
        this.secretKey = secretKey;
        this.algorithm = algorithm;
        this.randomSupplier = randomSupplier;
    }

    @Override
    protected byte[] decrypt(byte[] encrypted) {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            int ivSize = cipher.getBlockSize();
            byte[] iv = new byte[ivSize];
            byte[] ciphertext = new byte[encrypted.length - ivSize];
            System.arraycopy(encrypted, 0, iv, 0, ivSize);
            System.arraycopy(encrypted, ivSize, ciphertext, 0, ciphertext.length);
            cipher.init(2, (Key)this.secretKey, new IvParameterSpec(iv));
            return cipher.doFinal(ciphertext);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected byte[] encrypt(byte[] plainBytes) {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            int ivSize = cipher.getBlockSize();
            byte[] iv = this.randomSupplier.getRandomBytes(ivSize);
            cipher.init(1, (Key)this.secretKey, new IvParameterSpec(iv));
            byte[] ciphertext = cipher.doFinal(plainBytes);
            byte[] finalRes = new byte[ciphertext.length + ivSize];
            System.arraycopy(iv, 0, finalRes, 0, ivSize);
            System.arraycopy(ciphertext, 0, finalRes, ivSize, ciphertext.length);
            return finalRes;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }
}

