/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore.crypt;

import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.pageStore.crypt.ICrypter;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;

public class GCMSIVCrypter
implements ICrypter {
    protected Cipher getCipher() throws GeneralSecurityException {
        return Cipher.getInstance("AES/GCM-SIV/NoPadding");
    }

    @Override
    public SecretKey generateKey(SecureRandom random) {
        try {
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            generator.init(256, random);
            return generator.generateKey();
        }
        catch (GeneralSecurityException ex) {
            throw new WicketRuntimeException(ex);
        }
    }

    @Override
    public byte[] encrypt(byte[] decrypted, SecretKey key, SecureRandom random) {
        try {
            Cipher cipher = this.getCipher();
            cipher.init(1, (Key)key, random);
            AlgorithmParameters params = cipher.getParameters();
            byte[] nonce = params.getParameterSpec(AEADParameterSpec.class).getNonce();
            byte[] ciphertext = cipher.doFinal(decrypted);
            byte[] encrypted = Arrays.copyOf(nonce, nonce.length + ciphertext.length);
            System.arraycopy(ciphertext, 0, encrypted, nonce.length, ciphertext.length);
            return encrypted;
        }
        catch (GeneralSecurityException ex) {
            throw new WicketRuntimeException(ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] encrypted, SecretKey key) {
        try {
            byte[] nonce = new byte[12];
            byte[] ciphertext = new byte[encrypted.length - nonce.length];
            System.arraycopy(encrypted, 0, nonce, 0, nonce.length);
            System.arraycopy(encrypted, nonce.length, ciphertext, 0, ciphertext.length);
            Cipher cipher = this.getCipher();
            cipher.init(2, (Key)key, (AlgorithmParameterSpec)new AEADParameterSpec(nonce, 128));
            byte[] decrypted = cipher.doFinal(ciphertext);
            return decrypted;
        }
        catch (GeneralSecurityException ex) {
            throw new WicketRuntimeException(ex);
        }
    }
}

