/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Objects;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;

public class CssUrlReferenceHeaderItem
extends CssHeaderItem {
    private static final long serialVersionUID = 1L;
    private final String url;
    private final String media;
    private final String rel;

    public CssUrlReferenceHeaderItem(String url, String media, String condition, String rel) {
        super(condition);
        this.url = url;
        this.media = media;
        this.rel = rel;
    }

    public CssUrlReferenceHeaderItem(String url, String media, String condition) {
        super(condition);
        this.url = url;
        this.media = media;
        this.rel = null;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMedia() {
        return this.media;
    }

    public String getRel() {
        return this.rel;
    }

    @Override
    public void render(Response response) {
        this.internalRenderCSSReference(response, UrlUtils.rewriteToContextRelative((String)this.getUrl(), (IRequestCycle)RequestCycle.get()), this.getMedia(), this.getCondition(), this.getRel());
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Arrays.asList("css-" + UrlUtils.rewriteToContextRelative((String)this.getUrl(), (IRequestCycle)RequestCycle.get()) + "-" + this.media);
    }

    public String toString() {
        return "CSSUrlReferenceHeaderItem(" + this.getUrl() + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.url, this.media, this.rel);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CssUrlReferenceHeaderItem that = (CssUrlReferenceHeaderItem)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.media, that.media) && Objects.equals(this.rel, that.rel);
    }
}

