/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;

public class CssContentHeaderItem
extends CssHeaderItem {
    private final CharSequence css;

    public CssContentHeaderItem(CharSequence css, String id, String condition) {
        super(condition);
        this.css = css;
        this.setId(id);
    }

    public CharSequence getCss() {
        return this.css;
    }

    @Override
    public void render(Response response) {
        boolean hasCondition;
        boolean bl = hasCondition = !Strings.isEmpty((CharSequence)this.getCondition());
        if (hasCondition) {
            response.write((CharSequence)"<!--[if ");
            response.write((CharSequence)this.getCondition());
            response.write((CharSequence)"]>");
        }
        CssUtils.writeCss(response, this.getCss(), this.getId());
        if (hasCondition) {
            response.write((CharSequence)"<![endif]-->\n");
        }
    }

    @Override
    public Iterable<?> getRenderTokens() {
        if (Strings.isEmpty((CharSequence)this.getId())) {
            return Collections.singletonList(this.getCss());
        }
        return Arrays.asList(this.getId(), this.getCss());
    }

    public String toString() {
        return "CSSHeaderItem(" + this.getCss() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CssContentHeaderItem that = (CssContentHeaderItem)o;
        return Objects.equals(this.css, that.css);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.css);
    }
}

