/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.pages.BrowserInfoPage;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;

public class WebSession
extends Session {
    private static final long serialVersionUID = 1L;

    public static WebSession get() {
        return (WebSession)Session.get();
    }

    public WebSession(Request request) {
        super(request);
    }

    @Override
    public void invalidate() {
        if (!this.isSessionInvalidated()) {
            this.getApplication().getSecuritySettings().getAuthenticationStrategy().remove();
            super.invalidate();
        }
    }

    @Override
    public WebClientInfo getClientInfo() {
        if (this.clientInfo == null) {
            RequestCycle requestCycle = RequestCycle.get();
            this.clientInfo = new WebClientInfo(requestCycle);
            if (this.getApplication().getRequestCycleSettings().getGatherExtendedBrowserInfo()) {
                WebPage browserInfoPage = this.newBrowserInfoPage();
                throw new RestartResponseAtInterceptPageException(browserInfoPage);
            }
        }
        return (WebClientInfo)this.clientInfo;
    }

    protected WebPage newBrowserInfoPage() {
        return new BrowserInfoPage();
    }
}

