/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.modal;

import java.io.Serializable;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.AbstractRepeater;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.CoreLibrariesContributor;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.EnumeratedType;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

public class ModalWindow
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String CSS_CLASS_BLUE = "w_blue";
    public static final String CSS_CLASS_GRAY = "w_silver";
    private static final ResourceReference JAVASCRIPT = new JavaScriptResourceReference(ModalWindow.class, "res/modal.js");
    private static final ResourceReference CSS = new CssResourceReference(ModalWindow.class, "res/modal.css");
    public static final String CONTENT_ID = "content";
    private boolean shown = false;
    private WebMarkupContainer empty;
    private int minimalWidth = 200;
    private int minimalHeight = 200;
    private String cssClassName = "w_blue";
    private int initialWidth = 600;
    private int initialHeight = 400;
    private boolean useInitialHeight = true;
    private boolean resizable = true;
    private String widthUnit = "px";
    private String heightUnit = "px";
    private String cookieName;
    private IModel<String> title = null;
    private MaskType maskType = MaskType.SEMI_TRANSPARENT;
    private boolean autoSize = false;
    private boolean unloadConfirmation = true;
    private PageCreator pageCreator = null;
    private CloseButtonCallback closeButtonCallback = null;
    private WindowClosedCallback windowClosedCallback = null;

    public ModalWindow(String id) {
        super(id);
        this.init();
    }

    public ModalWindow(String id, IModel<?> model) {
        super(id, model);
        this.init();
    }

    private void init() {
        this.setVersioned(false);
        this.cookieName = null;
        Component[] componentArray = new Component[1];
        this.empty = new WebMarkupContainer(this.getContentId());
        componentArray[0] = this.empty;
        this.add(componentArray);
        this.add(new Behavior[]{this.newCloseButtonBehavior()});
        this.add(new Behavior[]{new WindowClosedBehavior()});
        this.setWindowClosedCallback(new WindowClosedCallback(){

            @Override
            public void onClose(AjaxRequestTarget target) {
            }
        });
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        CoreLibrariesContributor.contributeAjax((Application)this.getApplication(), (IHeaderResponse)response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JAVASCRIPT));
        ResourceReference cssResource = this.newCssResource();
        if (cssResource != null) {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)cssResource));
        }
    }

    protected ResourceReference newCssResource() {
        return CSS;
    }

    public boolean isShown() {
        return this.shown;
    }

    public ModalWindow setPageCreator(PageCreator creator) {
        this.setContent((Component)this.empty);
        this.pageCreator = creator;
        return this;
    }

    public ModalWindow setCloseButtonCallback(CloseButtonCallback callback) {
        this.closeButtonCallback = callback;
        return this;
    }

    public ModalWindow setWindowClosedCallback(WindowClosedCallback callback) {
        this.windowClosedCallback = callback;
        return this;
    }

    public void show(IPartialPageRequestHandler target) {
        if (!this.shown) {
            this.getContent().setVisible(true);
            target.add(new Component[]{this});
            target.appendJavaScript((CharSequence)this.getWindowOpenJavaScript());
            this.shown = true;
        }
    }

    public static void closeCurrent(IPartialPageRequestHandler target) {
        target.appendJavaScript((CharSequence)ModalWindow.getCloseJavacriptInternal());
    }

    public void close(IPartialPageRequestHandler target) {
        this.getContent().setVisible(false);
        if (this.isCustomComponent()) {
            target.add(new Component[]{this.getContent()});
        }
        target.appendJavaScript((CharSequence)this.getCloseJavacript());
        this.shown = false;
    }

    protected CharSequence getShowJavaScript() {
        return "window.setTimeout(function(){\n  Wicket.Window.create(settings).show();\n}, 0);\n";
    }

    private static String getCloseJavacriptInternal() {
        return "var win;\ntry {\n\twin = window.parent.Wicket.Window;\n} catch (ignore) {\n}\nif (typeof(win) == \"undefined\" || typeof(win.current) == \"undefined\") {\n  try {\n     win = window.Wicket.Window;\n  } catch (ignore) {\n  }\n}\nif (win && win.current) {\n var close = function(w) { w.setTimeout(function() {\n\t\twin.current.close();\n\t}, 0);  };\n\ttry { close(window.parent); } catch (ignore) { close(window); }\n}";
    }

    protected String getCloseJavacript() {
        return ModalWindow.getCloseJavacriptInternal();
    }

    public String getContentId() {
        return CONTENT_ID;
    }

    public ModalWindow setMinimalWidth(int minimalWidth) {
        this.minimalWidth = minimalWidth;
        return this;
    }

    public int getMinimalWidth() {
        return this.minimalWidth;
    }

    public ModalWindow setMinimalHeight(int minimalHeight) {
        this.minimalHeight = minimalHeight;
        return this;
    }

    public int getMinimalHeight() {
        return this.minimalHeight;
    }

    public ModalWindow setCssClassName(String cssClassName) {
        this.cssClassName = cssClassName;
        return this;
    }

    public String getCssClassName() {
        return this.cssClassName;
    }

    public ModalWindow setInitialWidth(int initialWidth) {
        this.initialWidth = initialWidth;
        return this;
    }

    public int getInitialWidth() {
        return this.initialWidth;
    }

    public ModalWindow setInitialHeight(int initialHeight) {
        this.initialHeight = initialHeight;
        return this;
    }

    public int getInitialHeight() {
        return this.initialHeight;
    }

    public ModalWindow setUseInitialHeight(boolean useInitialHeight) {
        this.useInitialHeight = useInitialHeight;
        return this;
    }

    public boolean isUseInitialHeight() {
        return this.useInitialHeight;
    }

    public ModalWindow setResizable(boolean resizable) {
        this.resizable = resizable;
        return this;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public ModalWindow showUnloadConfirmation(boolean unloadConfirmation) {
        this.unloadConfirmation = unloadConfirmation;
        return this;
    }

    public boolean showUnloadConfirmation() {
        return this.unloadConfirmation;
    }

    public ModalWindow setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
        return this;
    }

    public String getWidthUnit() {
        return this.widthUnit;
    }

    public ModalWindow setHeightUnit(String heightUnit) {
        this.heightUnit = heightUnit;
        return this;
    }

    public String getHeightUnit() {
        return this.heightUnit;
    }

    public ModalWindow setCookieName(String cookieName) {
        if (cookieName != null && (cookieName.contains(",") || cookieName.contains("|"))) {
            throw new IllegalArgumentException("Cookie name may not contain ',' or '|' characters.");
        }
        this.cookieName = cookieName;
        return this;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public ModalWindow setTitle(String title) {
        this.title = new Model((Serializable)((Object)title));
        return this;
    }

    public ModalWindow setTitle(IModel<String> title) {
        this.title = title = this.wrap(title);
        return this;
    }

    public IModel<String> getTitle() {
        return this.title;
    }

    public ModalWindow setMaskType(MaskType mask) {
        this.maskType = mask;
        return this;
    }

    public MaskType getMaskType() {
        return this.maskType;
    }

    private Page createPage() {
        if (this.pageCreator == null) {
            return null;
        }
        return this.pageCreator.createPage();
    }

    protected void onBeforeRender() {
        this.shown = this.makeContentVisible();
        this.getContent().setOutputMarkupId(true);
        this.getContent().setVisible(this.shown);
        super.onBeforeRender();
    }

    protected boolean makeContentVisible() {
        if (!this.getWebRequest().isAjax()) {
            return false;
        }
        return this.shown;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("style", (CharSequence)"display:none");
    }

    protected final Component getContent() {
        return this.get(this.getContentId());
    }

    protected boolean isCustomComponent() {
        return this.getContent() != this.empty;
    }

    public ModalWindow remove(Component component) {
        super.remove(component);
        if (component.getId().equals(this.getContentId())) {
            Component[] componentArray = new Component[1];
            this.empty = new WebMarkupContainer(this.getContentId());
            componentArray[0] = this.empty;
            this.add(componentArray);
        }
        return this;
    }

    public ModalWindow setContent(Component component) {
        if (!component.getId().equals(this.getContentId())) {
            throw new WicketRuntimeException("Modal window content id is wrong. Component ID:" + component.getId() + "; content ID: " + this.getContentId());
        }
        if (component instanceof AbstractRepeater) {
            throw new WicketRuntimeException("A repeater component cannot be used as the content of a modal window, please use repeater's parent");
        }
        component.setOutputMarkupPlaceholderTag(true);
        component.setVisible(false);
        this.replace(component);
        this.shown = false;
        this.pageCreator = null;
        return this;
    }

    private String getContentMarkupId() {
        return this.getContent().getMarkupId();
    }

    protected final String getWindowOpenJavaScript() {
        AbstractDefaultAjaxBehavior behavior;
        String title;
        AppendingStringBuffer buffer = new AppendingStringBuffer(500);
        if (this.isCustomComponent()) {
            buffer.append("var element = document.getElementById(\"");
            buffer.append(this.getContentMarkupId());
            buffer.append("\");\n");
        }
        buffer.append("var settings = new Object();\n");
        this.appendAssignment(buffer, (CharSequence)"settings.minWidth", this.getMinimalWidth());
        this.appendAssignment(buffer, (CharSequence)"settings.minHeight", this.getMinimalHeight());
        this.appendAssignment(buffer, (CharSequence)"settings.className", this.getCssClassName());
        this.appendAssignment(buffer, (CharSequence)"settings.width", this.getInitialWidth());
        if (this.isUseInitialHeight() || !this.isCustomComponent()) {
            this.appendAssignment(buffer, (CharSequence)"settings.height", this.getInitialHeight());
        } else {
            buffer.append("settings.height=null;\n");
        }
        this.appendAssignment(buffer, (CharSequence)"settings.resizable", this.isResizable());
        if (!this.isResizable()) {
            this.appendAssignment(buffer, (CharSequence)"settings.widthUnit", this.getWidthUnit());
            this.appendAssignment(buffer, (CharSequence)"settings.heightUnit", this.getHeightUnit());
        }
        if (!this.isCustomComponent()) {
            CharSequence pageUrl;
            Page page = this.createPage();
            if (page == null) {
                throw new WicketRuntimeException("Error creating page for modal dialog.");
            }
            RequestCycle requestCycle = RequestCycle.get();
            page.getSession().getPageManager().touchPage((IManageablePage)page);
            if (page.isPageStateless()) {
                pageUrl = requestCycle.urlFor(page.getClass(), page.getPageParameters());
            } else {
                RenderPageRequestHandler handler = new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)page));
                pageUrl = requestCycle.urlFor((IRequestHandler)handler);
            }
            this.appendAssignment(buffer, (CharSequence)"settings.src", pageUrl);
        } else {
            buffer.append("settings.element=element;\n");
        }
        if (this.getCookieName() != null) {
            this.appendAssignment(buffer, (CharSequence)"settings.cookieId", this.getCookieName());
        }
        String string = title = this.getTitle() != null ? (String)this.getTitle().getObject() : null;
        if (title != null) {
            String escaped = this.getDefaultModelObjectAsString(title);
            this.appendAssignment(buffer, (CharSequence)"settings.title", escaped);
        }
        if (this.getMaskType() == MaskType.TRANSPARENT) {
            buffer.append("settings.mask=\"transparent\";\n");
        } else if (this.getMaskType() == MaskType.SEMI_TRANSPARENT) {
            buffer.append("settings.mask=\"semi-transparent\";\n");
        }
        this.appendAssignment(buffer, (CharSequence)"settings.autoSize", this.autoSize);
        this.appendAssignment(buffer, (CharSequence)"settings.unloadConfirmation", this.showUnloadConfirmation());
        boolean haveCloseCallback = false;
        if (this.windowClosedCallback != null) {
            behavior = (WindowClosedBehavior)((Object)this.getBehaviors(WindowClosedBehavior.class).get(0));
            buffer.append("settings.onClose = function() { ");
            buffer.append((Object)behavior.getCallbackScript());
            buffer.append(" };\n");
            haveCloseCallback = true;
        }
        if (this.closeButtonCallback != null || !haveCloseCallback) {
            behavior = (CloseButtonBehavior)((Object)this.getBehaviors(CloseButtonBehavior.class).get(0));
            buffer.append("settings.onCloseButton = function() { ");
            buffer.append((Object)behavior.getCallbackScript());
            buffer.append(";return false;};\n");
        }
        this.postProcessSettings(buffer);
        buffer.append((Object)this.getShowJavaScript());
        return buffer.toString();
    }

    private void appendAssignment(AppendingStringBuffer buffer, CharSequence key, int value) {
        buffer.append((Object)key).append('=');
        buffer.append(value);
        buffer.append(";\n");
    }

    private void appendAssignment(AppendingStringBuffer buffer, CharSequence key, boolean value) {
        buffer.append((Object)key).append('=');
        buffer.append(Boolean.toString(value));
        buffer.append(";\n");
    }

    private void appendAssignment(AppendingStringBuffer buffer, CharSequence key, CharSequence value) {
        buffer.append((Object)key).append("=\"");
        if (value != null) {
            value = Strings.replaceAll((CharSequence)value, (CharSequence)"\"", (CharSequence)"\\\"");
            value = Strings.replaceAll((CharSequence)value, (CharSequence)"\n", (CharSequence)"\\n");
        }
        buffer.append((Object)value);
        buffer.append("\";\n");
    }

    protected AppendingStringBuffer postProcessSettings(AppendingStringBuffer settings) {
        return settings;
    }

    protected void onDetach() {
        super.onDetach();
        if (this.title != null) {
            this.title.detach();
        }
    }

    public ModalWindow setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
        return this;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    protected CloseButtonBehavior newCloseButtonBehavior() {
        return new CloseButtonBehavior();
    }

    protected class CloseButtonBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        protected final void respond(AjaxRequestTarget target) {
            if (ModalWindow.this.closeButtonCallback == null || ModalWindow.this.closeButtonCallback.onCloseButtonClicked(target)) {
                ModalWindow.this.close((IPartialPageRequestHandler)target);
            }
        }
    }

    private class WindowClosedBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        private WindowClosedBehavior() {
        }

        protected void respond(AjaxRequestTarget target) {
            ModalWindow.this.shown = false;
            if (ModalWindow.this.windowClosedCallback != null) {
                ModalWindow.this.windowClosedCallback.onClose(target);
            }
        }
    }

    public static final class MaskType
    extends EnumeratedType {
        private static final long serialVersionUID = 1L;
        public static final MaskType TRANSPARENT = new MaskType("TRANSPARENT");
        public static final MaskType SEMI_TRANSPARENT = new MaskType("SEMI_TRANSPARENT");

        public MaskType(String name) {
            super(name);
        }
    }

    public static interface WindowClosedCallback
    extends IClusterable {
        public void onClose(AjaxRequestTarget var1);
    }

    public static interface CloseButtonCallback
    extends IClusterable {
        public boolean onCloseButtonClicked(AjaxRequestTarget var1);
    }

    public static interface PageCreator
    extends IClusterable {
        public Page createPage();
    }
}

