/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authentication.strategy;

import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.util.cookies.CookieDefaults;
import org.apache.wicket.util.cookies.CookieUtils;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthenticationStrategy
implements IAuthenticationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAuthenticationStrategy.class);
    protected final String cookieKey;
    protected final String VALUE_SEPARATOR = "-sep-";
    private CookieUtils cookieUtils;
    private ICrypt crypt;

    public DefaultAuthenticationStrategy(String cookieKey, ICrypt crypt) {
        this.cookieKey = Args.notEmpty((String)cookieKey, (String)"cookieKey");
        this.crypt = (ICrypt)Args.notNull((Object)crypt, (String)"crypt");
    }

    protected CookieUtils getCookieUtils() {
        if (this.cookieUtils == null) {
            CookieDefaults settings = new CookieDefaults();
            settings.setHttpOnly(true);
            this.cookieUtils = new CookieUtils(settings);
        }
        return this.cookieUtils;
    }

    protected ICrypt getCrypt() {
        return this.crypt;
    }

    @Override
    public String[] load() {
        String value = this.getCookieUtils().load(this.cookieKey);
        if (!Strings.isEmpty((String)value)) {
            try {
                value = this.getCrypt().decryptUrlSafe(value);
            }
            catch (RuntimeException e) {
                logger.info("Error decrypting login cookie: {}. The cookie will be deleted. Possible cause is that a session-relative encryption key was used to encrypt this cookie while this decryption attempt is happening in a different session, eg user coming back to the application after session expiration", (Object)this.cookieKey);
                this.getCookieUtils().remove(this.cookieKey);
                value = null;
            }
            return this.decode(value);
        }
        return null;
    }

    protected String[] decode(String value) {
        if (!Strings.isEmpty((String)value)) {
            String username = null;
            String password = null;
            String[] values = value.split("-sep-");
            if (values.length > 0 && !Strings.isEmpty((String)values[0])) {
                username = values[0];
            }
            if (values.length > 1 && !Strings.isEmpty((String)values[1])) {
                password = values[1];
            }
            return new String[]{username, password};
        }
        return null;
    }

    @Override
    public void save(String credential, String ... extraCredentials) {
        String encryptedValue = this.getCrypt().encryptUrlSafe(this.encode(credential, extraCredentials));
        this.getCookieUtils().save(this.cookieKey, encryptedValue);
    }

    protected String encode(String credential, String ... extraCredentials) {
        StringBuilder value = new StringBuilder(credential);
        if (extraCredentials != null) {
            for (String extraCredential : extraCredentials) {
                value.append("-sep-").append(extraCredential);
            }
        }
        return value.toString();
    }

    @Override
    public void remove() {
        this.getCookieUtils().remove(this.cookieKey);
    }
}

