/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.gcp;

import com.hazelcast.gcp.RestClient;
import com.hazelcast.internal.json.Json;

class GcpMetadataApi {
    private static final String METADATA_ENDPOINT = "http://metadata.google.internal";
    private final String endpoint;

    GcpMetadataApi() {
        this.endpoint = METADATA_ENDPOINT;
    }

    GcpMetadataApi(String endpoint) {
        this.endpoint = endpoint;
    }

    String currentProject() {
        String urlString = String.format("%s/computeMetadata/v1/project/project-id", this.endpoint);
        return GcpMetadataApi.callGet(urlString);
    }

    String currentZone() {
        String urlString = String.format("%s/computeMetadata/v1/instance/zone", this.endpoint);
        String zoneResponse = GcpMetadataApi.callGet(urlString);
        return GcpMetadataApi.lastPartOf(zoneResponse);
    }

    private static String lastPartOf(String string) {
        String[] parts = string.split("/");
        return parts[parts.length - 1];
    }

    String accessToken() {
        String urlString = String.format("%s/computeMetadata/v1/instance/service-accounts/default/token", this.endpoint);
        String accessTokenResponse = GcpMetadataApi.callGet(urlString);
        return GcpMetadataApi.extractAccessToken(accessTokenResponse);
    }

    private static String extractAccessToken(String accessTokenResponse) {
        return Json.parse(accessTokenResponse).asObject().get("access_token").asString();
    }

    private static String callGet(String urlString) {
        return RestClient.create(urlString).withHeader("Metadata-Flavor", "Google").get();
    }
}

