/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.gzip;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class GZipUtils {
    public static InputStream detectCompression(InputStream stream) throws IOException {
        InputStream buffered = stream.markSupported() ? stream : new BufferedInputStream(stream);
        buffered.mark(2);
        int magic = GZipUtils.readUnsignedShort(buffered);
        buffered.reset();
        InputStream result = magic == 35615 ? new GZIPInputStream(buffered) : buffered;
        return result;
    }

    private static int readUnsignedShort(InputStream in) throws IOException {
        int b2;
        int b1 = in.read();
        if ((b1 | (b2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (b1 << 0) + (b2 << 8);
    }
}

