/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.print;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Constants;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Packages;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.stream.MapStream;
import aQute.lib.collections.MultiMap;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.unmodifiable.Sets;
import aQute.libg.generics.Create;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Manifest;
import java.util.zip.ZipException;

public class JarPrinter
extends Processor {
    final Formatter out = new Formatter();
    public static final int VERIFY = 1;
    public static final int MANIFEST = 2;
    public static final int LIST = 4;
    public static final int IMPEXP = 16;
    public static final int USES = 32;
    public static final int USEDBY = 64;
    public static final int COMPONENT = 128;
    public static final int METATYPE = 256;
    public static final int API = 512;
    public static final int CAPABILITIES = 1024;
    public static final int HEX = 0;
    private static final Set<String> syntax_headers = Sets.of(OSGI_SYNTAX_HEADERS);

    public JarPrinter(Processor bnd) {
        super(bnd);
    }

    public JarPrinter() {
    }

    public JarPrinter doPrint(Jar jar, int options, boolean java, boolean xport) throws ZipException, IOException, Exception {
        if (jar.getManifest() != null) {
            if ((options & 1) != 0) {
                this.doVerify(jar);
            }
            if ((options & 2) != 0) {
                this.header("MANIFEST");
                this.doManifest(jar);
            }
            if ((options & 0x10) != 0) {
                this.header("IMPEXP");
                this.doImpExp(jar);
                this.println();
            }
            if ((options & 0x400) != 0) {
                this.header("CAPABILITIES");
                this.doCapabilities(jar);
                this.println();
            }
            if ((options & 0x80) != 0) {
                this.header("COMPONENTS");
                this.doComponents(jar);
                this.println();
            }
            if ((options & 0x100) != 0) {
                this.header("METATYPE");
                this.doMetatype(jar);
                this.println();
            }
            if ((options & 0x260) != 0) {
                this.doXref(jar, options, java, xport);
                this.println();
            }
        }
        if ((options & 4) != 0) {
            this.header("LIST");
            this.doList(jar);
            this.println();
        }
        return this;
    }

    private void header(String string) {
        this.out.format("[%s]%n%n", string);
    }

    public void doXref(Jar jar, int options, boolean java, boolean xport) throws Exception, IOException {
        this.println();
        try (Analyzer analyzer = new Analyzer();){
            String s;
            analyzer.setPedantic(this.isPedantic());
            analyzer.setJar(jar);
            analyzer.removeClose(jar);
            Manifest m = jar.getManifest();
            if (m != null && (s = m.getMainAttributes().getValue("Export-Package")) != null) {
                analyzer.setExportPackage(s);
            }
            analyzer.analyze();
            Packages exports = analyzer.getExports();
            if ((options & 0x200) != 0) {
                Map<Descriptors.PackageRef, List<Descriptors.PackageRef>> apiUses = analyzer.cleanupUses(analyzer.getAPIUses(), !java);
                if (!xport) {
                    if (exports.isEmpty()) {
                        this.warning("Not filtering on exported only since exports are empty", new Object[0]);
                    } else {
                        apiUses.keySet().retainAll(analyzer.getExports().keySet());
                    }
                }
                this.header("API USES");
                MultiMap.format(apiUses);
                Set<Descriptors.PackageRef> privates = analyzer.getPrivates();
                for (Descriptors.PackageRef export : exports.keySet()) {
                    Map<Clazz.Def, List<Descriptors.TypeRef>> xRef = analyzer.getXRef(export, privates, 5);
                    if (xRef.isEmpty()) continue;
                    this.println();
                    this.out.format("%s refers to private Packages (not good)\n\n", export);
                    for (Map.Entry<Clazz.Def, List<Descriptors.TypeRef>> e : xRef.entrySet()) {
                        TreeSet<Descriptors.PackageRef> refs = new TreeSet<Descriptors.PackageRef>();
                        for (Descriptors.TypeRef ref : e.getValue()) {
                            refs.add(ref.getPackageRef());
                        }
                        refs.retainAll(privates);
                        this.out.format("%60s %-40s %s\n", e.getKey().getOwnerType().getFQN(), e.getKey().getName(), refs);
                    }
                    this.println();
                }
                this.println();
            }
            Map<Descriptors.PackageRef, List<Descriptors.PackageRef>> uses = analyzer.cleanupUses(analyzer.getUses(), !java);
            if ((options & 0x20) != 0) {
                this.header("USES");
                this.println(MultiMap.format(uses));
                this.println();
            }
            if ((options & 0x40) != 0) {
                this.header("USEDBY");
                MultiMap<Descriptors.PackageRef, Descriptors.PackageRef> usedBy = new MultiMap<Descriptors.PackageRef, Descriptors.PackageRef>(uses).transpose();
                this.println(MultiMap.format(usedBy));
            }
        }
    }

    public void doList(Jar jar) {
        for (Map.Entry<String, Map<String, Resource>> entry : jar.getDirectories().entrySet()) {
            String name = entry.getKey();
            Map<String, Resource> contents = entry.getValue();
            this.println(name);
            if (contents != null) {
                for (String element : contents.keySet()) {
                    String extra;
                    Resource r;
                    int n = element.lastIndexOf(47);
                    if (n > 0) {
                        element = element.substring(n + 1);
                    }
                    this.out.format("  %s", element);
                    String path = element;
                    if (name.length() != 0) {
                        path = name + "/" + element;
                    }
                    if ((r = contents.get(path)) != null && (extra = r.getExtra()) != null) {
                        this.out.format(" extra='%s'", JarPrinter.escapeUnicode(extra));
                    }
                    this.println();
                }
                continue;
            }
            this.println(name + " <no contents>");
        }
        this.println();
    }

    public void doCapabilities(Jar jar) throws Exception {
        Manifest m = jar.getManifest();
        Domain domain = Domain.domain(m);
        if (m != null) {
            Parameters provide = domain.getProvideCapability();
            Parameters require = domain.getRequireCapability();
            this.print("Provide-Capability", new TreeMap<String, Attrs>(provide));
            this.print("Require-Capability", new TreeMap<String, Attrs>(require));
        } else {
            this.warning("File has no manifest", new Object[0]);
        }
    }

    public void doImpExp(Jar jar) throws Exception {
        Manifest m = jar.getManifest();
        if (m != null) {
            Domain domain = Domain.domain(m);
            Parameters imports = domain.getImportPackage();
            Parameters exports = domain.getExportPackage();
            for (String p : exports.keySet()) {
                Attrs attrs;
                if (!imports.containsKey(p) || !(attrs = imports.get(p)).containsKey("version")) continue;
                exports.get(p).put("imported-as", attrs.get("version"));
            }
            this.print("Import-Package", new TreeMap<String, Attrs>(imports));
            this.println();
            this.print("Export-Package", new TreeMap<String, Attrs>(exports));
        } else {
            this.warning("File has no manifest", new Object[0]);
        }
    }

    public void doVerify(Jar jar) throws Exception, IOException {
        try (Verifier verifier = new Verifier(jar);){
            verifier.setPedantic(this.isPedantic());
            verifier.verify();
            this.getInfo(verifier);
        }
    }

    public void doManifest(Jar jar) throws Exception {
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            this.warning("JAR has no manifest %s", jar);
        } else {
            this.doManifest(manifest);
        }
        this.println();
    }

    private JarPrinter println(String string) {
        this.out.format("%s\n", string);
        return this;
    }

    public JarPrinter println() {
        this.out.format("%n", new Object[0]);
        return this;
    }

    public JarPrinter doManifest(Manifest manifest) {
        MultiMap table = new MultiMap();
        MapStream.of(manifest.getMainAttributes()).forEach((? super K k, ? super V v) -> {
            String key = k.toString();
            if (syntax_headers.contains(key)) {
                table.put(key, Strings.splitQuoted(v.toString()));
            } else {
                table.add(key, v.toString());
            }
        });
        this.println(MultiMap.format(table));
        return this;
    }

    private static char nibble(int i) {
        return "0123456789ABCDEF".charAt(i & 0xF);
    }

    private static String escapeUnicode(String value) {
        int len = value.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c <= '~' && c != '\\') {
                sb.append(c);
                continue;
            }
            sb.append('\\').append('u').append(JarPrinter.nibble(c >> 12)).append(JarPrinter.nibble(c >> 8)).append(JarPrinter.nibble(c >> 4)).append(JarPrinter.nibble(c));
        }
        return len == sb.length() ? value : sb.toString();
    }

    private void doComponents(Jar jar) throws Exception {
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            this.println("No manifest");
            return;
        }
        String componentHeader = manifest.getMainAttributes().getValue("Service-Component");
        Parameters clauses = new Parameters(componentHeader, this);
        for (String path : clauses.keySet()) {
            this.println(path);
            Resource r = jar.getResource(path);
            if (r != null) {
                InputStreamReader ir = new InputStreamReader(r.openInputStream(), Constants.DEFAULT_CHARSET);
                Throwable throwable = null;
                try {
                    IO.copy((Reader)ir, this.getWriter());
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ir == null) continue;
                    if (throwable != null) {
                        try {
                            ir.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ir.close();
                    continue;
                }
            }
            this.println("  - no resource");
            this.warning("No Resource found for service component: %s", path);
        }
        this.println();
    }

    public Writer getWriter() {
        return IO.appendableToWriter(this.out.out());
    }

    public void doMetatype(Jar jar) throws Exception {
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            this.println("No manifest");
            return;
        }
        Map<String, Resource> map = jar.getDirectories().get("OSGI-INF/metatype");
        if (map != null) {
            for (Map.Entry<String, Resource> entry : map.entrySet()) {
                this.println(entry.getKey());
                IO.copy(entry.getValue().openInputStream(), this.getWriter());
                this.println();
            }
            this.println();
        }
    }

    public void print(String msg, Map<?, ? extends Map<?, ?>> ports) {
        if (ports.isEmpty()) {
            return;
        }
        this.out.format("%s%n", msg);
        for (Map.Entry<?, Map<?, ?>> entry : ports.entrySet()) {
            Object key = entry.getKey();
            Map<?, ?> clause = Create.copy(entry.getValue());
            clause.remove("uses:");
            this.out.format("  %-38s %s\n", Processor.removeDuplicateMarker(key.toString().trim()), clause.isEmpty() ? "" : clause.toString());
        }
    }

    @Override
    public String toString() {
        return this.out.toString();
    }
}

