/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.bv.money;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import java.util.List;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import org.hibernate.validator.constraints.Currency;
import org.hibernate.validator.internal.util.CollectionHelper;

public class CurrencyValidatorForMonetaryAmount
implements ConstraintValidator<Currency, MonetaryAmount> {
    private List<CurrencyUnit> acceptedCurrencies;

    public void initialize(Currency currency) {
        ArrayList<CurrencyUnit> acceptedCurrencies = new ArrayList<CurrencyUnit>();
        for (String currencyCode : currency.value()) {
            acceptedCurrencies.add(Monetary.getCurrency((String)currencyCode, (String[])new String[0]));
        }
        this.acceptedCurrencies = CollectionHelper.toImmutableList(acceptedCurrencies);
    }

    public boolean isValid(MonetaryAmount value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return this.acceptedCurrencies.contains(value.getCurrency());
    }
}

