/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.language.simple.ast.LiteralExpression;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.StringHelper;

public class SimpleFunctionExpression
extends LiteralExpression {
    private LRUCache<String, Expression> cacheExpression;

    @Deprecated
    public SimpleFunctionExpression(SimpleToken token) {
        super(token);
    }

    public SimpleFunctionExpression(SimpleToken token, LRUCache<String, Expression> cacheExpression) {
        super(token);
        this.cacheExpression = cacheExpression;
    }

    @Override
    public Expression createExpression(String expression) {
        Expression answer;
        String function = this.text.toString();
        Expression expression2 = answer = this.cacheExpression != null ? this.cacheExpression.get(function) : null;
        if (answer == null) {
            answer = this.createSimpleExpression(function, true);
            if (this.cacheExpression != null && answer != null) {
                this.cacheExpression.put(function, answer);
            }
        }
        return answer;
    }

    public Expression createExpression(String expression, boolean strict) {
        Expression answer;
        String function = this.text.toString();
        Expression expression2 = answer = this.cacheExpression != null ? this.cacheExpression.get(function) : null;
        if (answer == null) {
            answer = this.createSimpleExpression(function, strict);
            if (this.cacheExpression != null && answer != null) {
                this.cacheExpression.put(function, answer);
            }
        }
        return answer;
    }

    private Expression createSimpleExpression(String function, boolean strict) {
        String[] parts;
        Expression fileExpression;
        Expression answer = this.createSimpleExpressionDirectly(function);
        if (answer != null) {
            return answer;
        }
        answer = this.createSimpleExpressionBodyOrHeader(function, strict);
        if (answer != null) {
            return answer;
        }
        String remainder = this.ifStartsWithReturnRemainder("camelContext", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${camelContext.OGNL} was: " + function, this.token.getIndex());
            }
            return ExpressionBuilder.camelContextOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("exception", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exception.OGNL} was: " + function, this.token.getIndex());
            }
            return ExpressionBuilder.exchangeExceptionOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("property", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("exchangeProperty", function);
        }
        if (remainder != null) {
            boolean invalid;
            if (remainder.startsWith(".") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            if (invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder)) {
                throw new SimpleParserException("Valid syntax: ${exchangeProperty.OGNL} was: " + function, this.token.getIndex());
            }
            if (OgnlHelper.isValidOgnlExpression(remainder)) {
                return ExpressionBuilder.propertyOgnlExpression(remainder);
            }
            return ExpressionBuilder.exchangePropertyExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("sys.", function);
        if (remainder != null) {
            return ExpressionBuilder.systemPropertyExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("sysenv.", function);
        if (remainder != null) {
            return ExpressionBuilder.systemEnvironmentExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("exchange", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exchange.OGNL} was: " + function, this.token.getIndex());
            }
            return ExpressionBuilder.exchangeOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("file:", function);
        if (remainder != null && (fileExpression = this.createSimpleFileExpression(remainder, strict)) != null) {
            return fileExpression;
        }
        remainder = this.ifStartsWithReturnRemainder("date:", function);
        if (remainder != null) {
            parts = remainder.split(":", 2);
            if (parts.length == 1) {
                return ExpressionBuilder.dateExpression(parts[0]);
            }
            if (parts.length == 2) {
                return ExpressionBuilder.dateExpression(parts[0], parts[1]);
            }
        }
        if ((remainder = this.ifStartsWithReturnRemainder("date-with-timezone:", function)) != null) {
            parts = remainder.split(":", 3);
            if (parts.length < 3) {
                throw new SimpleParserException("Valid syntax: ${date-with-timezone:command:timezone:pattern} was: " + function, this.token.getIndex());
            }
            return ExpressionBuilder.dateExpression(parts[0], parts[1], parts[2]);
        }
        remainder = this.ifStartsWithReturnRemainder("bean:", function);
        if (remainder != null) {
            return ExpressionBuilder.beanExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("properties:", function);
        if (remainder != null) {
            parts = remainder.split(":");
            if (parts.length > 2) {
                throw new SimpleParserException("Valid syntax: ${properties:key[:default]} was: " + function, this.token.getIndex());
            }
            return ExpressionBuilder.propertiesComponentExpression(remainder, null, null);
        }
        remainder = this.ifStartsWithReturnRemainder("properties-location:", function);
        if (remainder != null) {
            parts = remainder.split(":");
            if (parts.length > 3) {
                throw new SimpleParserException("Valid syntax: ${properties-location:location:key[:default]} was: " + function, this.token.getIndex());
            }
            String locations = null;
            String key = remainder;
            if (parts.length >= 2) {
                locations = ObjectHelper.before(remainder, ":");
                key = ObjectHelper.after(remainder, ":");
            }
            return ExpressionBuilder.propertiesComponentExpression(key, locations, null);
        }
        remainder = this.ifStartsWithReturnRemainder("ref:", function);
        if (remainder != null) {
            return ExpressionBuilder.refExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("type:", function);
        if (remainder != null) {
            Expression exp = ExpressionBuilder.typeExpression(remainder);
            return ExpressionBuilder.cacheExpression(exp);
        }
        Expression misc = this.createSimpleExpressionMisc(function);
        if (misc != null) {
            return misc;
        }
        if (strict) {
            throw new SimpleParserException("Unknown function: " + function, this.token.getIndex());
        }
        return null;
    }

    private Expression createSimpleExpressionBodyOrHeader(String function, boolean strict) {
        String remainder = this.ifStartsWithReturnRemainder("bodyAs(", function);
        if (remainder != null) {
            String type = ObjectHelper.before(remainder, ")");
            if (type == null) {
                throw new SimpleParserException("Valid syntax: ${bodyAs(type)} was: " + function, this.token.getIndex());
            }
            type = StringHelper.removeQuotes(type);
            if (ObjectHelper.isNotEmpty(remainder = ObjectHelper.after(remainder, ")"))) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${bodyAs(type).OGNL} was: " + function, this.token.getIndex());
                }
                return ExpressionBuilder.bodyOgnlExpression(type, remainder);
            }
            return ExpressionBuilder.bodyExpression(type);
        }
        remainder = this.ifStartsWithReturnRemainder("mandatoryBodyAs(", function);
        if (remainder != null) {
            String type = ObjectHelper.before(remainder, ")");
            if (type == null) {
                throw new SimpleParserException("Valid syntax: ${mandatoryBodyAs(type)} was: " + function, this.token.getIndex());
            }
            type = StringHelper.removeQuotes(type);
            if (ObjectHelper.isNotEmpty(remainder = ObjectHelper.after(remainder, ")"))) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${mandatoryBodyAs(type).OGNL} was: " + function, this.token.getIndex());
                }
                return ExpressionBuilder.mandatoryBodyOgnlExpression(type, remainder);
            }
            return ExpressionBuilder.mandatoryBodyExpression(type);
        }
        remainder = this.ifStartsWithReturnRemainder("body", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.body", function);
        }
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${body.OGNL} was: " + function, this.token.getIndex());
            }
            return ExpressionBuilder.bodyOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("headerAs(", function);
        if (remainder != null) {
            String keyAndType = ObjectHelper.before(remainder, ")");
            if (keyAndType == null) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type)} was: " + function, this.token.getIndex());
            }
            String key = ObjectHelper.before(keyAndType, ",");
            String type = ObjectHelper.after(keyAndType, ",");
            remainder = ObjectHelper.after(remainder, ")");
            if (ObjectHelper.isEmpty(key) || ObjectHelper.isEmpty(type) || ObjectHelper.isNotEmpty(remainder)) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type)} was: " + function, this.token.getIndex());
            }
            key = StringHelper.removeQuotes(key);
            type = StringHelper.removeQuotes(type);
            return ExpressionBuilder.headerExpression(key, type);
        }
        if ("in.headers".equals(function) || "headers".equals(function)) {
            return ExpressionBuilder.headersExpression();
        }
        remainder = this.ifStartsWithReturnRemainder("in.headers", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.header", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("headers", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("header", function);
        }
        if (remainder != null) {
            String key;
            boolean invalid;
            if (remainder.startsWith(".") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            if (invalid = OgnlHelper.isInvalidValidOgnlExpression(key = StringHelper.removeLeadingAndEndingQuotes(remainder))) {
                throw new SimpleParserException("Valid syntax: ${header.name[key]} was: " + function, this.token.getIndex());
            }
            if (OgnlHelper.isValidOgnlExpression(key)) {
                return ExpressionBuilder.headersOgnlExpression(key);
            }
            return ExpressionBuilder.headerExpression(key);
        }
        remainder = this.ifStartsWithReturnRemainder("out.header.", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("out.headers.", function);
        }
        if (remainder != null) {
            return ExpressionBuilder.outHeaderExpression(remainder);
        }
        return null;
    }

    private Expression createSimpleExpressionDirectly(String expression) {
        if (ObjectHelper.isEqualToAny(expression, "body", "in.body")) {
            return ExpressionBuilder.bodyExpression();
        }
        if (ObjectHelper.equal(expression, "out.body")) {
            return ExpressionBuilder.outBodyExpression();
        }
        if (ObjectHelper.equal(expression, "id")) {
            return ExpressionBuilder.messageIdExpression();
        }
        if (ObjectHelper.equal(expression, "exchangeId")) {
            return ExpressionBuilder.exchangeIdExpression();
        }
        if (ObjectHelper.equal(expression, "exchange")) {
            return ExpressionBuilder.exchangeExpression();
        }
        if (ObjectHelper.equal(expression, "exception")) {
            return ExpressionBuilder.exchangeExceptionExpression();
        }
        if (ObjectHelper.equal(expression, "exception.message")) {
            return ExpressionBuilder.exchangeExceptionMessageExpression();
        }
        if (ObjectHelper.equal(expression, "exception.stacktrace")) {
            return ExpressionBuilder.exchangeExceptionStackTraceExpression();
        }
        if (ObjectHelper.equal(expression, "threadName")) {
            return ExpressionBuilder.threadNameExpression();
        }
        if (ObjectHelper.equal(expression, "camelId")) {
            return ExpressionBuilder.camelContextNameExpression();
        }
        if (ObjectHelper.equal(expression, "routeId")) {
            return ExpressionBuilder.routeIdExpression();
        }
        if (ObjectHelper.equal(expression, "null")) {
            return ExpressionBuilder.nullExpression();
        }
        return null;
    }

    private Expression createSimpleFileExpression(String remainder, boolean strict) {
        if (ObjectHelper.equal(remainder, "name")) {
            return ExpressionBuilder.fileNameExpression();
        }
        if (ObjectHelper.equal(remainder, "name.noext")) {
            return ExpressionBuilder.fileNameNoExtensionExpression();
        }
        if (ObjectHelper.equal(remainder, "name.noext.single")) {
            return ExpressionBuilder.fileNameNoExtensionSingleExpression();
        }
        if (ObjectHelper.equal(remainder, "name.ext") || ObjectHelper.equal(remainder, "ext")) {
            return ExpressionBuilder.fileExtensionExpression();
        }
        if (ObjectHelper.equal(remainder, "name.ext.single")) {
            return ExpressionBuilder.fileExtensionSingleExpression();
        }
        if (ObjectHelper.equal(remainder, "onlyname")) {
            return ExpressionBuilder.fileOnlyNameExpression();
        }
        if (ObjectHelper.equal(remainder, "onlyname.noext")) {
            return ExpressionBuilder.fileOnlyNameNoExtensionExpression();
        }
        if (ObjectHelper.equal(remainder, "onlyname.noext.single")) {
            return ExpressionBuilder.fileOnlyNameNoExtensionSingleExpression();
        }
        if (ObjectHelper.equal(remainder, "parent")) {
            return ExpressionBuilder.fileParentExpression();
        }
        if (ObjectHelper.equal(remainder, "path")) {
            return ExpressionBuilder.filePathExpression();
        }
        if (ObjectHelper.equal(remainder, "absolute")) {
            return ExpressionBuilder.fileAbsoluteExpression();
        }
        if (ObjectHelper.equal(remainder, "absolute.path")) {
            return ExpressionBuilder.fileAbsolutePathExpression();
        }
        if (ObjectHelper.equal(remainder, "length") || ObjectHelper.equal(remainder, "size")) {
            return ExpressionBuilder.fileSizeExpression();
        }
        if (ObjectHelper.equal(remainder, "modified")) {
            return ExpressionBuilder.fileLastModifiedExpression();
        }
        if (strict) {
            throw new SimpleParserException("Unknown file language syntax: " + remainder, this.token.getIndex());
        }
        return null;
    }

    private Expression createSimpleExpressionMisc(String function) {
        String remainder = this.ifStartsWithReturnRemainder("random(", function);
        if (remainder != null) {
            String values = ObjectHelper.before(remainder, ")");
            if (values == null || ObjectHelper.isEmpty(values)) {
                throw new SimpleParserException("Valid syntax: ${random(min,max)} or ${random(max)} was: " + function, this.token.getIndex());
            }
            if (values.contains(",")) {
                String[] tokens = values.split(",", -1);
                if (tokens.length > 2) {
                    throw new SimpleParserException("Valid syntax: ${random(min,max)} or ${random(max)} was: " + function, this.token.getIndex());
                }
                return ExpressionBuilder.randomExpression(tokens[0].trim(), tokens[1].trim());
            }
            return ExpressionBuilder.randomExpression("0", values.trim());
        }
        remainder = this.ifStartsWithReturnRemainder("skip(", function);
        if (remainder != null) {
            String values = ObjectHelper.before(remainder, ")");
            if (values == null || ObjectHelper.isEmpty(values)) {
                throw new SimpleParserException("Valid syntax: ${skip(number)} was: " + function, this.token.getIndex());
            }
            String exp = "${body}";
            int num = Integer.parseInt(values.trim());
            return ExpressionBuilder.skipExpression(exp, num);
        }
        remainder = this.ifStartsWithReturnRemainder("collate(", function);
        if (remainder != null) {
            String values = ObjectHelper.before(remainder, ")");
            if (values == null || ObjectHelper.isEmpty(values)) {
                throw new SimpleParserException("Valid syntax: ${collate(group)} was: " + function, this.token.getIndex());
            }
            String exp = "${body}";
            int num = Integer.parseInt(values.trim());
            return ExpressionBuilder.collateExpression(exp, num);
        }
        remainder = this.ifStartsWithReturnRemainder("messageHistory", function);
        if (remainder != null) {
            String values = ObjectHelper.between(remainder, "(", ")");
            boolean detailed = values == null || ObjectHelper.isEmpty(values) ? true : Boolean.valueOf(values);
            return ExpressionBuilder.messageHistoryExpression(detailed);
        }
        if (ObjectHelper.equal(function, "messageHistory")) {
            return ExpressionBuilder.messageHistoryExpression(true);
        }
        return null;
    }

    private String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && (remainder = text.substring(prefix.length())).length() > 0) {
            return remainder;
        }
        return null;
    }
}

