/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.codec;

import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.blueprint.BlueprintMetadataMBean;
import org.apache.aries.jmx.blueprint.codec.BPComponentMetadata;
import org.apache.aries.jmx.blueprint.codec.BPMapEntry;
import org.apache.aries.jmx.blueprint.codec.BPRegistrationListener;
import org.apache.aries.jmx.blueprint.codec.BPTarget;
import org.apache.aries.jmx.blueprint.codec.Util;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.RegistrationListener;
import org.osgi.service.blueprint.reflect.ServiceMetadata;

public class BPServiceMetadata
extends BPComponentMetadata {
    private int autoExport;
    private String[] interfaces;
    private int ranking;
    private BPRegistrationListener[] listeners;
    private BPMapEntry[] properties;
    private BPTarget serviceComponent;

    public BPServiceMetadata(CompositeData service) {
        super(service);
        this.autoExport = (Integer)service.get("AutoExport");
        this.interfaces = (String[])service.get("Interfaces");
        this.ranking = (Integer)service.get("Ranking");
        CompositeData[] cd_listeners = (CompositeData[])service.get("RegistrationListeners");
        this.listeners = new BPRegistrationListener[cd_listeners.length];
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i] = new BPRegistrationListener(cd_listeners[i]);
        }
        CompositeData[] cd_props = (CompositeData[])service.get("ServiceProperties");
        this.properties = new BPMapEntry[cd_props.length];
        for (int i = 0; i < this.properties.length; ++i) {
            this.properties[i] = new BPMapEntry(cd_props[i]);
        }
        Byte[] buf = (Byte[])service.get("ServiceComponent");
        this.serviceComponent = (BPTarget)Util.boxedBinary2BPMetadata(buf);
    }

    public BPServiceMetadata(ServiceMetadata service) {
        super((ComponentMetadata)service);
        this.autoExport = service.getAutoExport();
        this.interfaces = service.getInterfaces().toArray(new String[0]);
        this.ranking = service.getRanking();
        this.listeners = new BPRegistrationListener[service.getRegistrationListeners().size()];
        int i = 0;
        for (Object listener : service.getRegistrationListeners()) {
            this.listeners[i++] = new BPRegistrationListener((RegistrationListener)listener);
        }
        this.properties = new BPMapEntry[service.getServiceProperties().size()];
        i = 0;
        for (Object prop : service.getServiceProperties()) {
            this.properties[i++] = new BPMapEntry((MapEntry)prop);
        }
        this.serviceComponent = (BPTarget)Util.metadata2BPMetadata((Metadata)service.getServiceComponent());
    }

    @Override
    protected Map<String, Object> getItemsMap() {
        Map<String, Object> items = super.getItemsMap();
        items.put("AutoExport", this.autoExport);
        items.put("Interfaces", this.interfaces);
        items.put("Ranking", this.ranking);
        CompositeData[] cd_listeners = new CompositeData[this.listeners.length];
        for (int i = 0; i < this.listeners.length; ++i) {
            cd_listeners[i] = this.listeners[i].asCompositeData();
        }
        items.put("RegistrationListeners", cd_listeners);
        CompositeData[] cd_props = new CompositeData[this.properties.length];
        for (int i = 0; i < this.properties.length; ++i) {
            cd_props[i] = this.properties[i].asCompositeData();
        }
        items.put("ServiceProperties", cd_props);
        items.put("ServiceComponent", Util.bpMetadata2BoxedBinary(this.serviceComponent));
        return items;
    }

    @Override
    public CompositeData asCompositeData() {
        try {
            return new CompositeDataSupport(BlueprintMetadataMBean.SERVICE_METADATA_TYPE, this.getItemsMap());
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public int getAutoExport() {
        return this.autoExport;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public int getRanking() {
        return this.ranking;
    }

    public BPRegistrationListener[] getRegistrationListeners() {
        return this.listeners;
    }

    public BPTarget getServiceComponent() {
        return this.serviceComponent;
    }

    public BPMapEntry[] getServiceProperties() {
        return this.properties;
    }
}

