/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast.management.internal;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.command.Command;
import org.apache.karaf.cellar.core.command.ExecutionContext;
import org.apache.karaf.cellar.core.control.ManageGroupAction;
import org.apache.karaf.cellar.core.control.ManageGroupCommand;
import org.apache.karaf.cellar.core.management.CellarGroupMBean;

public class CellarGroupMBeanImpl
extends StandardMBean
implements CellarGroupMBean {
    private ClusterManager clusterManager;
    private ExecutionContext executionContext;
    private GroupManager groupManager;

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public CellarGroupMBeanImpl() throws NotCompliantMBeanException {
        super(CellarGroupMBean.class);
    }

    public void create(String name) throws Exception {
        Group group = this.groupManager.findGroupByName(name);
        if (group != null) {
            throw new IllegalArgumentException("Cluster group " + name + " already exists");
        }
        this.groupManager.createGroup(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String name) throws Exception {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Group g = this.groupManager.findGroupByName(name);
            LinkedList<String> nodes = new LinkedList<String>();
            if (g.getNodes() != null && !g.getNodes().isEmpty()) {
                for (Node n : g.getNodes()) {
                    nodes.add(n.getId());
                }
                ManageGroupCommand command = new ManageGroupCommand(this.clusterManager.generateId());
                command.setAction(ManageGroupAction.QUIT);
                command.setGroupName(name);
                Set recipientList = this.clusterManager.listNodes(nodes);
                command.setDestination(recipientList);
                this.executionContext.execute((Command)command);
            }
            this.groupManager.deleteGroup(name);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public void join(String groupName, String nodeIdOrAlias) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        Node node = this.clusterManager.findNodeByIdOrAlias(nodeIdOrAlias);
        if (node == null) {
            throw new IllegalArgumentException("Cluster node " + nodeIdOrAlias + " doesn't exist");
        }
        HashSet<Node> nodes = new HashSet<Node>();
        nodes.add(node);
        ManageGroupCommand command = new ManageGroupCommand(this.clusterManager.generateId());
        command.setAction(ManageGroupAction.JOIN);
        command.setGroupName(groupName);
        command.setDestination(nodes);
        this.executionContext.execute((Command)command);
    }

    public void quit(String groupName, String nodeIdOrAlias) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        Node node = this.clusterManager.findNodeByIdOrAlias(nodeIdOrAlias);
        if (node == null) {
            throw new IllegalArgumentException("Cluster node " + nodeIdOrAlias + " doesn't exist");
        }
        HashSet<Node> nodes = new HashSet<Node>();
        nodes.add(node);
        ManageGroupCommand command = new ManageGroupCommand(this.clusterManager.generateId());
        command.setAction(ManageGroupAction.QUIT);
        command.setGroupName(groupName);
        command.setDestination(nodes);
        this.executionContext.execute((Command)command);
    }

    public TabularData getGroups() throws Exception {
        Set allGroups = this.groupManager.listAllGroups();
        CompositeType groupType = new CompositeType("Group", "Karaf Cellar cluster group", new String[]{"name", "members"}, new String[]{"Name of the cluster group", "Members of the cluster group"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
        TabularType tableType = new TabularType("Groups", "Table of all Karaf Cellar groups", groupType, new String[]{"name"});
        TabularDataSupport table = new TabularDataSupport(tableType);
        for (Group group : allGroups) {
            StringBuffer members = new StringBuffer();
            for (Node node : group.getNodes()) {
                if (this.clusterManager.findNodeById(node.getId()) == null) continue;
                if (node.getAlias() != null) {
                    members.append(node.getAlias());
                } else {
                    members.append(node.getId());
                }
                members.append(" ");
            }
            CompositeDataSupport data = new CompositeDataSupport(groupType, new String[]{"name", "members"}, new Object[]{group.getName(), members.toString()});
            table.put(data);
        }
        return table;
    }
}

