/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.service.result;

import aQute.bnd.service.result.ConsumerWithException;
import aQute.bnd.service.result.Exceptions;
import aQute.bnd.service.result.FunctionWithException;
import aQute.bnd.service.result.Result;
import aQute.bnd.service.result.ResultException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Ok<V, E>
implements Result<V, E> {
    private final V value;

    Ok(V value) {
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public boolean isOk() {
        return true;
    }

    @Override
    public boolean isErr() {
        return false;
    }

    @Override
    public Optional<V> value() {
        return Optional.of(this.value);
    }

    @Override
    public Optional<E> error() {
        return Optional.empty();
    }

    @Override
    public V unwrap() {
        return this.value;
    }

    @Override
    public V unwrap(String message) throws ResultException {
        return this.value;
    }

    @Override
    public V orElse(V orElse) {
        return this.value;
    }

    @Override
    public V orElseGet(Supplier<? extends V> orElseSupplier) {
        Objects.requireNonNull(orElseSupplier);
        return this.value;
    }

    @Override
    public <R extends Throwable> V orElseThrow(FunctionWithException<? super E, ? extends R> throwableSupplier) throws R {
        Objects.requireNonNull(throwableSupplier);
        return this.value;
    }

    @Override
    public <U> Result<U, E> map(FunctionWithException<? super V, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        try {
            return new Ok<U, E>(mapper.apply(this.value));
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    private <F> Result<V, F> coerce() {
        return this;
    }

    @Override
    public <F> Result<V, F> mapErr(FunctionWithException<? super E, ? extends F> mapper) {
        Objects.requireNonNull(mapper);
        return this.coerce();
    }

    @Override
    public <U> Result<U, E> flatMap(FunctionWithException<? super V, ? extends Result<? extends U, ? extends E>> mapper) {
        Objects.requireNonNull(mapper);
        try {
            Result<? extends U, ? extends E> result = Objects.requireNonNull(mapper.apply(this.value));
            return result;
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    @Override
    public Result<V, E> recover(FunctionWithException<? super E, ? extends V> recover) {
        Objects.requireNonNull(recover);
        return this;
    }

    public String toString() {
        return String.format("Ok(%s)", this.value);
    }

    @Override
    public void accept(ConsumerWithException<? super V> ok, ConsumerWithException<? super E> err) {
        Objects.requireNonNull(err);
        try {
            ok.accept(this.value);
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    @Override
    public <X> Result<X, E> asError() {
        throw new IllegalArgumentException("must be an error");
    }

    @Override
    public <X extends Throwable> V unwrap(Function<E, X> constructor) {
        return this.unwrap();
    }
}

