/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.action.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public abstract class MultiServiceTracker<T> {
    private final BundleContext ctx;
    private final Class<T> clazz;
    private String filter;
    private final Map<ServiceReference<T>, T> refs = new HashMap<ServiceReference<T>, T>();
    private final AtomicBoolean open = new AtomicBoolean(false);
    private final ServiceListener listener = event -> {
        if (this.open.get()) {
            if (event.getType() == 4) {
                this.removeRef(event.getServiceReference());
            } else if (event.getType() == 1) {
                this.addRef(event.getServiceReference());
            }
            this.updateState();
        }
    };

    public MultiServiceTracker(BundleContext context, Class<T> clazz, String filter) {
        this.ctx = context;
        this.clazz = clazz;
        this.filter = filter;
    }

    protected abstract void updateState(List<T> var1);

    public void open() {
        if (this.open.compareAndSet(false, true)) {
            try {
                String filterString = "(objectClass=" + this.clazz.getName() + ')';
                if (this.filter != null && !this.filter.isEmpty()) {
                    filterString = "(&" + filterString + this.filter + ')';
                }
                this.ctx.addServiceListener(this.listener, filterString);
                Collection refs = this.ctx.getServiceReferences(this.clazz, null);
                if (refs != null) {
                    for (ServiceReference ref : refs) {
                        this.addRef(ref);
                    }
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            this.updateState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            ArrayList<ServiceReference<T>> oldRefs;
            this.ctx.removeServiceListener(this.listener);
            Map<ServiceReference<T>, T> map = this.refs;
            synchronized (map) {
                oldRefs = new ArrayList<ServiceReference<T>>(this.refs.keySet());
                this.refs.clear();
            }
            for (ServiceReference serviceReference : oldRefs) {
                this.ctx.ungetService(serviceReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState() {
        ArrayList<T> svcs = new ArrayList<T>();
        Map<ServiceReference<T>, T> map = this.refs;
        synchronized (map) {
            svcs.addAll(this.refs.values());
        }
        this.updateState(svcs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRef(ServiceReference<T> ref) {
        Object service = this.ctx.getService(ref);
        Map<ServiceReference<T>, T> map = this.refs;
        synchronized (map) {
            if (!this.refs.containsKey(ref)) {
                this.refs.put(ref, service);
                return;
            }
        }
        this.ctx.ungetService(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRef(ServiceReference<T> ref) {
        Map<ServiceReference<T>, T> map = this.refs;
        synchronized (map) {
            if (this.refs.remove(ref) == null) {
                return;
            }
        }
        this.ctx.ungetService(ref);
    }
}

