/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.exporter.executable;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.JarResource;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.export.Exporter;
import aQute.lib.converter.Converter;
import aQute.lib.strings.Strings;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

@BndPlugin(name="exporter.executablejar", hide=true)
public class ExecutableJarExporter
implements Exporter {
    public static final String EXECUTABLE_JAR = "bnd.executablejar";
    public static final String EXECUTABLE_PACK = "bnd.executablejar.pack";

    @Override
    public String[] getTypes() {
        return new String[]{EXECUTABLE_JAR, EXECUTABLE_PACK};
    }

    @Override
    public Map.Entry<String, Resource> export(String type, Project project, Map<String, String> options) throws Exception {
        project.prepare();
        Jar jar = null;
        if (EXECUTABLE_JAR.equals(type)) {
            jar = this.defaultExporter(project, options);
        } else if (EXECUTABLE_PACK.equals(type)) {
            String profile = options.getOrDefault("-profile", project.getProfile());
            jar = ExecutableJarExporter.pack(project, profile);
        } else {
            project.error("Unknown type %s", type);
        }
        if (jar == null) {
            return null;
        }
        String name = jar.getName();
        String[] baseext = Strings.extension(name);
        if (baseext != null && ("bnd".equals(baseext[1]) || "bndrun".equals(baseext[1]))) {
            name = baseext[0];
        }
        name = name + ".jar";
        return new AbstractMap.SimpleEntry<String, Resource>(name, new JarResource(jar, true));
    }

    private Jar defaultExporter(Project project, Map<String, String> options) throws Exception, IOException {
        Jar jar;
        try (ProjectLauncher launcher = project.getProjectLauncher();){
            Configuration configuration = Converter.cnv(Configuration.class, options);
            launcher.setKeep(configuration.keep() || project.getRunKeep());
            jar = launcher.executable();
            launcher.removeClose(jar);
            project.getInfo(launcher);
        }
        return jar;
    }

    /*
     * Exception decompiling
     */
    public static Jar pack(Project project, String profile) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static interface Configuration {
        public boolean keep();
    }
}

