/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.NumberFieldMapper;

public class DynamicTemplate
implements ToXContentObject {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(DynamicTemplate.class));
    private final String name;
    private final String pathMatch;
    private final String pathUnmatch;
    private final String match;
    private final String unmatch;
    private final MatchType matchType;
    private final XContentFieldType xcontentFieldType;
    private final Map<String, Object> mapping;

    public static DynamicTemplate parse(String name, Map<String, Object> conf, Version indexVersionCreated) throws MapperParsingException {
        String match = null;
        String pathMatch = null;
        String unmatch = null;
        String pathUnmatch = null;
        Map mapping = null;
        String matchMappingType = null;
        String matchPattern = MatchType.SIMPLE.toString();
        for (Map.Entry<String, Object> entry : conf.entrySet()) {
            String propName = entry.getKey();
            if ("match".equals(propName)) {
                match = entry.getValue().toString();
                continue;
            }
            if ("path_match".equals(propName)) {
                pathMatch = entry.getValue().toString();
                continue;
            }
            if ("unmatch".equals(propName)) {
                unmatch = entry.getValue().toString();
                continue;
            }
            if ("path_unmatch".equals(propName)) {
                pathUnmatch = entry.getValue().toString();
                continue;
            }
            if ("match_mapping_type".equals(propName)) {
                matchMappingType = entry.getValue().toString();
                continue;
            }
            if ("match_pattern".equals(propName)) {
                matchPattern = entry.getValue().toString();
                continue;
            }
            if ("mapping".equals(propName)) {
                mapping = (Map)entry.getValue();
                continue;
            }
            throw new IllegalArgumentException("Illegal dynamic template parameter: [" + propName + "]");
        }
        if (match == null && pathMatch == null && matchMappingType == null) {
            throw new MapperParsingException("template must have match, path_match or match_mapping_type set " + conf.toString());
        }
        if (mapping == null) {
            throw new MapperParsingException("template must have mapping set");
        }
        XContentFieldType xcontentFieldType = null;
        if (matchMappingType != null && !matchMappingType.equals("*")) {
            try {
                xcontentFieldType = XContentFieldType.fromString(matchMappingType);
            }
            catch (IllegalArgumentException e) {
                if (indexVersionCreated.onOrAfter(Version.V_6_0_0_alpha1)) {
                    throw e;
                }
                deprecationLogger.deprecated("match_mapping_type [" + matchMappingType + "] is invalid and will be ignored: " + e.getMessage(), new Object[0]);
                return null;
            }
        }
        MatchType matchType = MatchType.fromString(matchPattern);
        if (indexVersionCreated.onOrAfter(Version.V_6_3_0)) {
            for (String regex : new String[]{pathMatch, match, pathUnmatch, unmatch}) {
                if (regex == null) continue;
                try {
                    matchType.matches(regex, "");
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Pattern [" + regex + "] of type [" + (Object)((Object)matchType) + "] is invalid. Cannot create dynamic template [" + name + "].", e);
                }
            }
        }
        return new DynamicTemplate(name, pathMatch, pathUnmatch, match, unmatch, xcontentFieldType, matchType, mapping);
    }

    private DynamicTemplate(String name, String pathMatch, String pathUnmatch, String match, String unmatch, XContentFieldType xcontentFieldType, MatchType matchType, Map<String, Object> mapping) {
        this.name = name;
        this.pathMatch = pathMatch;
        this.pathUnmatch = pathUnmatch;
        this.match = match;
        this.unmatch = unmatch;
        this.matchType = matchType;
        this.xcontentFieldType = xcontentFieldType;
        this.mapping = mapping;
    }

    public String name() {
        return this.name;
    }

    public boolean match(String path, String name, XContentFieldType xcontentFieldType) {
        if (this.pathMatch != null && !this.matchType.matches(this.pathMatch, path)) {
            return false;
        }
        if (this.match != null && !this.matchType.matches(this.match, name)) {
            return false;
        }
        if (this.pathUnmatch != null && this.matchType.matches(this.pathUnmatch, path)) {
            return false;
        }
        if (this.unmatch != null && this.matchType.matches(this.unmatch, name)) {
            return false;
        }
        return this.xcontentFieldType == null || this.xcontentFieldType == xcontentFieldType;
    }

    public String mappingType(String dynamicType) {
        Object index;
        String type;
        if (this.mapping.containsKey("type")) {
            type = this.mapping.get("type").toString();
            type = type.replace("{dynamic_type}", dynamicType);
            type = type.replace("{dynamicType}", dynamicType);
        } else {
            type = dynamicType;
        }
        if (!type.equals(this.mapping.get("type")) && "text".equals(type) && ("not_analyzed".equals(index = this.mapping.get("index")) || "no".equals(index))) {
            type = "keyword";
        }
        return type;
    }

    public Map<String, Object> mappingForName(String name, String dynamicType) {
        return this.processMap(this.mapping, name, dynamicType);
    }

    private Map<String, Object> processMap(Map<String, Object> map, String name, String dynamicType) {
        HashMap<String, Object> processedMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().replace("{name}", name).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
            Map<String, Object> value = entry.getValue();
            if (value instanceof Map) {
                value = this.processMap(value, name, dynamicType);
            } else if (value instanceof List) {
                value = this.processList((List)((Object)value), name, dynamicType);
            } else if (value instanceof String) {
                value = value.toString().replace("{name}", name).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
            }
            processedMap.put(key, value);
        }
        return processedMap;
    }

    private List processList(List list, String name, String dynamicType) {
        ArrayList<Object> processedList = new ArrayList<Object>(list.size());
        for (Object value : list) {
            if (value instanceof Map) {
                value = this.processMap((Map)value, name, dynamicType);
            } else if (value instanceof List) {
                value = this.processList((List)value, name, dynamicType);
            } else if (value instanceof String) {
                value = value.toString().replace("{name}", name).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
            }
            processedList.add(value);
        }
        return processedList;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.match != null) {
            builder.field("match", this.match);
        }
        if (this.pathMatch != null) {
            builder.field("path_match", this.pathMatch);
        }
        if (this.unmatch != null) {
            builder.field("unmatch", this.unmatch);
        }
        if (this.pathUnmatch != null) {
            builder.field("path_unmatch", this.pathUnmatch);
        }
        if (this.xcontentFieldType != null) {
            builder.field("match_mapping_type", (Object)this.xcontentFieldType);
        } else if (this.match == null && this.pathMatch == null) {
            builder.field("match_mapping_type", "*");
        }
        if (this.matchType != MatchType.SIMPLE) {
            builder.field("match_pattern", (Object)this.matchType);
        }
        builder.field("mapping", new TreeMap<String, Object>(this.mapping));
        builder.endObject();
        return builder;
    }

    public static enum XContentFieldType {
        OBJECT{

            @Override
            public String defaultMappingType() {
                return "object";
            }

            public String toString() {
                return "object";
            }
        }
        ,
        STRING{

            @Override
            public String defaultMappingType() {
                return "text";
            }

            public String toString() {
                return "string";
            }
        }
        ,
        LONG{

            @Override
            public String defaultMappingType() {
                return NumberFieldMapper.NumberType.LONG.typeName();
            }

            public String toString() {
                return "long";
            }
        }
        ,
        DOUBLE{

            @Override
            public String defaultMappingType() {
                return NumberFieldMapper.NumberType.FLOAT.typeName();
            }

            public String toString() {
                return "double";
            }
        }
        ,
        BOOLEAN{

            @Override
            public String defaultMappingType() {
                return "boolean";
            }

            public String toString() {
                return "boolean";
            }
        }
        ,
        DATE{

            @Override
            public String defaultMappingType() {
                return "date";
            }

            public String toString() {
                return "date";
            }
        }
        ,
        BINARY{

            @Override
            public String defaultMappingType() {
                return "binary";
            }

            public String toString() {
                return "binary";
            }
        };


        public static XContentFieldType fromString(String value) {
            for (XContentFieldType v : XContentFieldType.values()) {
                if (!v.toString().equals(value)) continue;
                return v;
            }
            throw new IllegalArgumentException("No field type matched on [" + value + "], possible values are " + Arrays.toString((Object[])XContentFieldType.values()));
        }

        public abstract String defaultMappingType();
    }

    public static enum MatchType {
        SIMPLE{

            @Override
            public boolean matches(String pattern, String value) {
                return Regex.simpleMatch(pattern, value);
            }

            public String toString() {
                return "simple";
            }
        }
        ,
        REGEX{

            @Override
            public boolean matches(String pattern, String value) {
                return value.matches(pattern);
            }

            public String toString() {
                return "regex";
            }
        };


        public static MatchType fromString(String value) {
            for (MatchType v : MatchType.values()) {
                if (!v.toString().equals(value)) continue;
                return v;
            }
            throw new IllegalArgumentException("No matching pattern matched on [" + value + "]");
        }

        public abstract boolean matches(String var1, String var2);
    }
}

