/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions;

import org.apache.fulcrum.security.util.FulcrumSecurityException;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.Action;
import org.apache.turbine.om.security.User;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.security.SecurityService;
import org.apache.turbine.util.RunData;

public class LogoutUser
extends Action {
    @TurbineService
    private SecurityService security;
    @TurbineConfiguration(value="logout.message")
    private String logoutMessage;
    @TurbineConfiguration(value="action.logout")
    private String actionLogout = "LogoutUser";
    @TurbineConfiguration(value="screen.homepage")
    private String screenHomepage;

    @Override
    public void doPerform(PipelineData pipelineData) throws FulcrumSecurityException {
        RunData data = this.getRunData(pipelineData);
        Object user = data.getUserFromSession();
        if (!this.security.isAnonymousUser((User)user)) {
            if (!user.hasLoggedIn()) {
                return;
            }
            user.setHasLoggedIn(Boolean.FALSE);
            this.security.saveUser((User)user);
        }
        data.setMessage(this.logoutMessage);
        data.setACL(null);
        Object anonymousUser = this.security.getAnonymousUser();
        data.setUser(anonymousUser);
        data.save();
        data.getSession().removeAttribute("turbine.AccessControlList");
        if (!this.actionLogout.equals("LogoutUser")) {
            data.setScreen(this.screenHomepage);
        }
    }
}

