/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.BrowserOperatingSystemMappingComparator;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.data.IdentifiableComparator;
import net.sf.uadetector.internal.data.OrderedPatternComparator;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserOperatingSystemMapping;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.BrowserType;
import net.sf.uadetector.internal.data.domain.Device;
import net.sf.uadetector.internal.data.domain.DevicePattern;
import net.sf.uadetector.internal.data.domain.Identifiable;
import net.sf.uadetector.internal.data.domain.OperatingSystem;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.internal.data.domain.Robot;
import net.sf.uadetector.internal.util.RegularExpressionConverter;

@ThreadSafe
public final class IniDataWriter {
    private static final String EMPTY = "";

    private static void createBrowser(Browser browser, StringBuilder builder) {
        IniDataWriter.createKeyValuePair(browser, String.valueOf(browser.getType().getId()), builder);
        IniDataWriter.createKeyValuePair(browser, browser.getFamilyName(), builder);
        IniDataWriter.createKeyValuePair(browser, browser.getUrl(), builder);
        IniDataWriter.createKeyValuePair(browser, browser.getProducer(), builder);
        IniDataWriter.createKeyValuePair(browser, browser.getProducerUrl(), builder);
        IniDataWriter.createKeyValuePair(browser, browser.getIcon(), builder);
        IniDataWriter.createKeyValuePair(browser, browser.getInfoUrl(), builder);
    }

    private static void createBrowserOperatingSystemMappings(Data data, StringBuilder builder) {
        ArrayList<BrowserOperatingSystemMapping> mappings = new ArrayList<BrowserOperatingSystemMapping>(data.getBrowserToOperatingSystemMappings());
        Collections.sort(mappings, BrowserOperatingSystemMappingComparator.INSTANCE);
        IniDataWriter.createCategory("browser_os", builder);
        IniDataWriter.createComment("browser_id[] = \"OS id\"", builder);
        for (BrowserOperatingSystemMapping mapping : mappings) {
            IniDataWriter.createKeyValuePair(mapping.getBrowserId(), String.valueOf(mapping.getOperatingSystemId()), builder);
        }
    }

    private static void createBrowserPatterns(Data data, StringBuilder builder) {
        ArrayList patterns = new ArrayList(data.getBrowserPatterns().size());
        for (Map.Entry<Integer, SortedSet<BrowserPattern>> entry : data.getBrowserPatterns().entrySet()) {
            patterns.addAll(entry.getValue());
        }
        Collections.sort(patterns, new OrderedPatternComparator());
        IniDataWriter.createCategory("browser_reg", builder);
        IniDataWriter.createComment("browser_reg_id[] = \"Browser regstring\"", builder);
        IniDataWriter.createComment("browser_reg_id[] = \"Browser id\"", builder);
        for (BrowserPattern pattern : patterns) {
            String regex = RegularExpressionConverter.convertPatternToPerlRegex(pattern.getPattern());
            IniDataWriter.createKeyValuePair(pattern.getPosition(), regex, builder);
            IniDataWriter.createKeyValuePair(pattern.getPosition(), String.valueOf(pattern.getId()), builder);
        }
    }

    private static void createBrowsers(Data data, StringBuilder builder) {
        IniDataWriter.createCategory("browser", builder);
        IniDataWriter.createComment("browser_id[] = \"Browser type\"", builder);
        IniDataWriter.createComment("browser_id[] = \"Browser Name\"", builder);
        IniDataWriter.createComment("browser_id[] = \"Browser URL\"", builder);
        IniDataWriter.createComment("browser_id[] = \"Browser Company\"", builder);
        IniDataWriter.createComment("browser_id[] = \"Browser Company URL\"", builder);
        IniDataWriter.createComment("browser_id[] = \"Browser ico\"", builder);
        IniDataWriter.createComment("browser_id[] = \"Browser info URL\"", builder);
        ArrayList<Browser> browsers = new ArrayList<Browser>(data.getBrowsers());
        Collections.sort(browsers, IdentifiableComparator.INSTANCE);
        for (Browser browser : browsers) {
            IniDataWriter.createBrowser(browser, builder);
        }
    }

    private static void createBrowserTypes(Data data, StringBuilder builder) {
        IniDataWriter.createCategory("browser_type", builder);
        IniDataWriter.createComment("browser_type_id[] = \"Browser type\"", builder);
        ArrayList<BrowserType> browserTypes = new ArrayList<BrowserType>(data.getBrowserTypes().values());
        Collections.sort(browserTypes, IdentifiableComparator.INSTANCE);
        for (BrowserType browserType : browserTypes) {
            IniDataWriter.createKeyValuePair(browserType, browserType.getName(), builder);
        }
    }

    private static void createCategory(@Nonnull String category, @Nonnull StringBuilder builder) {
        builder.append('[');
        builder.append(category);
        builder.append(']');
        builder.append('\n');
    }

    private static void createComment(@Nonnull String comment, @Nonnull StringBuilder builder) {
        builder.append(';');
        builder.append(' ');
        builder.append(comment);
        builder.append('\n');
    }

    private static void createDescription(@Nonnull Data data, @Nonnull StringBuilder builder) {
        IniDataWriter.createComment("Data (format ini) for UASparser - http://user-agent-string.info/download/UASparser", builder);
        IniDataWriter.createComment("Version: " + data.getVersion(), builder);
        IniDataWriter.createComment("Checksum:", builder);
        IniDataWriter.createComment("MD5 - http://user-agent-string.info/rpc/get_data.php?format=ini&md5=y", builder);
        IniDataWriter.createComment("SHA1 - http://user-agent-string.info/rpc/get_data.php?format=ini&sha1=y", builder);
        builder.append(';');
        builder.append('\n');
    }

    private static void createDevice(Device device, StringBuilder builder) {
        IniDataWriter.createKeyValuePair(device, device.getName(), builder);
        IniDataWriter.createKeyValuePair(device, device.getIcon(), builder);
        IniDataWriter.createKeyValuePair(device, device.getInfoUrl(), builder);
    }

    private static void createDevicePatterns(Data data, StringBuilder builder) {
        ArrayList patterns = new ArrayList(data.getDevicePatterns().size());
        for (Map.Entry<Integer, SortedSet<DevicePattern>> entry : data.getDevicePatterns().entrySet()) {
            patterns.addAll(entry.getValue());
        }
        Collections.sort(patterns, new OrderedPatternComparator());
        IniDataWriter.createCategory("device_reg", builder);
        IniDataWriter.createComment("device_reg_id[] = \"Device regstring\"", builder);
        IniDataWriter.createComment("device_reg_id[] = \"Device id\"", builder);
        for (DevicePattern pattern : patterns) {
            String regex = RegularExpressionConverter.convertPatternToPerlRegex(pattern.getPattern());
            IniDataWriter.createKeyValuePair(pattern.getPosition(), regex, builder);
            IniDataWriter.createKeyValuePair(pattern.getPosition(), String.valueOf(pattern.getId()), builder);
        }
    }

    private static void createDevices(Data data, StringBuilder builder) {
        IniDataWriter.createCategory("device", builder);
        IniDataWriter.createComment("device_id[] = \"Device type\"", builder);
        IniDataWriter.createComment("device_id[] = \"Device ico\"", builder);
        IniDataWriter.createComment("device_id[] = \"Device info URL\"", builder);
        ArrayList<Device> devices = new ArrayList<Device>(data.getDevices());
        Collections.sort(devices, IdentifiableComparator.INSTANCE);
        for (Device device : devices) {
            IniDataWriter.createDevice(device, builder);
        }
    }

    private static void createKeyValuePair(@Nonnull Identifiable identifiable, @Nonnull String value, @Nonnull StringBuilder builder) {
        IniDataWriter.createKeyValuePair(identifiable.getId(), value, builder);
    }

    private static void createKeyValuePair(@Nonnull int id, @Nonnull String value, @Nonnull StringBuilder builder) {
        builder.append(id);
        builder.append('[');
        builder.append(']');
        builder.append(' ');
        builder.append('=');
        builder.append(' ');
        builder.append('\"');
        builder.append(value);
        builder.append('\"');
        builder.append('\n');
    }

    private static void createOperatingSystem(OperatingSystem operatingSystem, StringBuilder builder) {
        IniDataWriter.createKeyValuePair(operatingSystem, operatingSystem.getFamily(), builder);
        IniDataWriter.createKeyValuePair(operatingSystem, operatingSystem.getName(), builder);
        IniDataWriter.createKeyValuePair(operatingSystem, operatingSystem.getUrl(), builder);
        IniDataWriter.createKeyValuePair(operatingSystem, operatingSystem.getProducer(), builder);
        IniDataWriter.createKeyValuePair(operatingSystem, operatingSystem.getProducerUrl(), builder);
        IniDataWriter.createKeyValuePair(operatingSystem, operatingSystem.getIcon(), builder);
    }

    private static void createOperatingSystemPatterns(Data data, StringBuilder builder) {
        IniDataWriter.createCategory("os_reg", builder);
        IniDataWriter.createComment("os_reg_id[] = \"OS regstring\"", builder);
        IniDataWriter.createComment("os_reg_id[] = \"OS id\"", builder);
        ArrayList patterns = new ArrayList(data.getOperatingSystemPatterns().size());
        for (Map.Entry<Integer, SortedSet<OperatingSystemPattern>> entry : data.getOperatingSystemPatterns().entrySet()) {
            patterns.addAll(entry.getValue());
        }
        Collections.sort(patterns, new OrderedPatternComparator());
        for (OperatingSystemPattern pattern : patterns) {
            String regex = RegularExpressionConverter.convertPatternToPerlRegex(pattern.getPattern());
            IniDataWriter.createKeyValuePair(pattern.getPosition(), regex, builder);
            IniDataWriter.createKeyValuePair(pattern.getPosition(), String.valueOf(pattern.getId()), builder);
        }
    }

    private static void createOperatingSystems(Data data, StringBuilder builder) {
        IniDataWriter.createCategory("os", builder);
        IniDataWriter.createComment("os_id[] = \"OS Family\"", builder);
        IniDataWriter.createComment("os_id[] = \"OS Name\"", builder);
        IniDataWriter.createComment("os_id[] = \"OS URL\"", builder);
        IniDataWriter.createComment("os_id[] = \"OS Company\"", builder);
        IniDataWriter.createComment("os_id[] = \"OS Company URL\"", builder);
        IniDataWriter.createComment("os_id[] = \"OS ico\"", builder);
        ArrayList<OperatingSystem> operatingSystems = new ArrayList<OperatingSystem>(data.getOperatingSystems());
        Collections.sort(operatingSystems, IdentifiableComparator.INSTANCE);
        for (OperatingSystem operatingSystem : operatingSystems) {
            IniDataWriter.createOperatingSystem(operatingSystem, builder);
        }
    }

    private static void createRobot(Robot robot, StringBuilder builder) {
        IniDataWriter.createKeyValuePair(robot, robot.getUserAgentString(), builder);
        IniDataWriter.createKeyValuePair(robot, robot.getFamilyName(), builder);
        IniDataWriter.createKeyValuePair(robot, robot.getName(), builder);
        IniDataWriter.createKeyValuePair(robot, EMPTY, builder);
        IniDataWriter.createKeyValuePair(robot, robot.getProducer(), builder);
        IniDataWriter.createKeyValuePair(robot, robot.getProducerUrl(), builder);
        IniDataWriter.createKeyValuePair(robot, robot.getIcon(), builder);
        IniDataWriter.createKeyValuePair(robot, EMPTY, builder);
        IniDataWriter.createKeyValuePair(robot, robot.getInfoUrl(), builder);
    }

    private static void createRobots(Data data, StringBuilder builder) {
        IniDataWriter.createCategory("robots", builder);
        IniDataWriter.createComment("bot_id[] = \"bot useragentstring\"", builder);
        IniDataWriter.createComment("bot_id[] = \"bot Family\"", builder);
        IniDataWriter.createComment("bot_id[] = \"bot Name\"", builder);
        IniDataWriter.createComment("bot_id[] = \"bot URL\"", builder);
        IniDataWriter.createComment("bot_id[] = \"bot Company\"", builder);
        IniDataWriter.createComment("bot_id[] = \"bot Company URL\"", builder);
        IniDataWriter.createComment("bot_id[] = \"bot ico\"", builder);
        IniDataWriter.createComment("bot_id[] = \"bot OS id\"", builder);
        IniDataWriter.createComment("bot_id[] = \"bot info URL\"", builder);
        for (Robot robot : data.getRobots()) {
            IniDataWriter.createRobot(robot, builder);
        }
    }

    public static void write(@Nonnull Data data, @Nonnull OutputStream outputStream) throws IOException {
        Check.notNull((Object)data, (String)"data");
        Check.notNull((Object)outputStream, (String)"outputStream");
        StringBuilder doc = new StringBuilder(10000);
        IniDataWriter.createDescription(data, doc);
        IniDataWriter.createRobots(data, doc);
        IniDataWriter.createOperatingSystems(data, doc);
        IniDataWriter.createBrowsers(data, doc);
        IniDataWriter.createBrowserTypes(data, doc);
        IniDataWriter.createBrowserPatterns(data, doc);
        IniDataWriter.createBrowserOperatingSystemMappings(data, doc);
        IniDataWriter.createOperatingSystemPatterns(data, doc);
        IniDataWriter.createDevices(data, doc);
        IniDataWriter.createDevicePatterns(data, doc);
        outputStream.write(doc.toString().getBytes("UTF-8"));
    }

    private IniDataWriter() {
    }

    static interface Tag {
        public static final String BROWSER = "browser";
        public static final String BROWSER_OS = "browser_os";
        public static final String BROWSER_REG = "browser_reg";
        public static final String BROWSER_TYPE = "browser_type";
        public static final String DEVICE = "device";
        public static final String DEVICE_REG = "device_reg";
        public static final String OS = "os";
        public static final String OS_REG = "os_reg";
        public static final String ROBOTS = "robots";
    }

    static interface Char {
        public static final char EQUALS = '=';
        public static final char NEWLINE = '\n';
        public static final char QUOTE = '\"';
        public static final char SEMICOLON = ';';
        public static final char SQUARE_BRACKET_CLOSE = ']';
        public static final char SQUARE_BRACKET_OPEN = '[';
        public static final char WHITESPACE = ' ';
    }
}

