/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.exception.IllegalStateOfArgumentException;
import net.sf.uadetector.OperatingSystemFamily;
import net.sf.uadetector.ReadableVersionNumber;
import net.sf.uadetector.VersionParser;
import net.sf.uadetector.internal.util.AlphanumComparator;

public final class VersionNumber
implements ReadableVersionNumber,
Serializable {
    public static final String EMPTY_EXTENSION = "";
    public static final String EMPTY_GROUP = "";
    private static final int MIN_GROUP_SIZE = 3;
    private static final Pattern NUMERIC = Pattern.compile("\\d+");
    private static final char SEPARATOR = '.';
    private static final long serialVersionUID = 1L;
    public static final VersionNumber UNKNOWN = new VersionNumber("");
    @Nonnull
    private final String extension;
    @Nonnull
    private final List<String> groups;

    private static boolean isNumeric(String text) {
        return NUMERIC.matcher(text).matches();
    }

    public static VersionNumber parseLastVersionNumber(@Nonnull String text) {
        return VersionParser.parseLastVersionNumber((String)Check.notNull((Object)text, (String)"text"));
    }

    public static VersionNumber parseOperatingSystemVersion(@Nonnull OperatingSystemFamily family, @Nonnull String userAgent) {
        Check.notNull((Object)((Object)family), (String)"family");
        Check.notNull((Object)userAgent, (String)"userAgent");
        return VersionParser.parseOperatingSystemVersion(family, userAgent);
    }

    public static VersionNumber parseVersion(@Nonnull String version) {
        return VersionParser.parseVersion((String)Check.notNull((Object)version, (String)"version"));
    }

    public static List<String> replaceNullValueWithEmptyGroup(@Nonnull List<String> groups) {
        Check.notNull(groups, (String)"groups");
        ArrayList<String> result = new ArrayList<String>(groups.size());
        for (String group : groups) {
            if (group == null) {
                result.add("");
                continue;
            }
            result.add(group);
        }
        for (int i = result.size(); i < 3; ++i) {
            result.add("");
        }
        return result;
    }

    private static String toVersionString(@Nonnull List<String> groups) {
        StringBuilder builder = new StringBuilder(6);
        int count = 0;
        for (String segment : groups) {
            if ("".equals(segment)) break;
            if (count > 0) {
                builder.append('.');
            }
            builder.append(segment);
            ++count;
        }
        return builder.toString();
    }

    public VersionNumber(@Nonnull List<String> groups) {
        this(groups, "");
    }

    public VersionNumber(@Nonnull List<String> groups, @Nonnull String extension) {
        Check.notNull(groups, (String)"groups");
        Check.notNull((Object)extension, (String)"extension");
        List<String> segments = VersionNumber.replaceNullValueWithEmptyGroup(groups);
        int i = 0;
        for (String segment : segments) {
            if (!"".equals(segment) && !VersionNumber.isNumeric(segment)) {
                throw new IllegalStateOfArgumentException("The segment on position " + i + " (" + segment + ") must be a number.");
            }
            ++i;
        }
        this.groups = segments;
        this.extension = extension;
    }

    public VersionNumber(@Nonnull String major) {
        this((String)Check.notNull((Object)major, (String)"major"), "");
    }

    public VersionNumber(@Nonnull String major, @Nonnull String minor) {
        this((String)Check.notNull((Object)major, (String)"major"), (String)Check.notNull((Object)minor, (String)"minor"), "");
    }

    public VersionNumber(@Nonnull String major, @Nonnull String minor, @Nonnull String bugfix) {
        this((String)Check.notNull((Object)major, (String)"major"), (String)Check.notNull((Object)minor, (String)"minor"), (String)Check.notNull((Object)bugfix, (String)"bugfix"), "");
    }

    public VersionNumber(@Nonnull String major, @Nonnull String minor, @Nonnull String bugfix, @Nonnull String extension) {
        this(Arrays.asList((String)Check.notNull((Object)major, (String)"major"), (String)Check.notNull((Object)minor, (String)"minor"), (String)Check.notNull((Object)bugfix, (String)"bugfix")), (String)Check.notNull((Object)extension, (String)"extension"));
    }

    @Override
    public int compareTo(@Nullable ReadableVersionNumber other) {
        int result = 0;
        if (other == null) {
            result = -1;
        } else {
            Check.notNull(other.getGroups(), (String)"other.getGroups()");
            int length = this.groups.size() < other.getGroups().size() ? this.groups.size() : other.getGroups().size();
            AlphanumComparator comparator = new AlphanumComparator();
            result = comparator.compare(VersionNumber.toVersionString(this.groups.subList(0, length)), VersionNumber.toVersionString(other.getGroups().subList(0, length)));
            if (result == 0) {
                int n = this.groups.size() > other.getGroups().size() ? 1 : (result = this.groups.size() < other.getGroups().size() ? -1 : 0);
            }
            if (result == 0) {
                result = this.extension.compareTo(other.getExtension());
            }
            if (result == 0) {
                result = comparator.compare(this.toVersionString(), other.toVersionString());
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionNumber other = (VersionNumber)obj;
        if (!((Object)this.groups).equals(other.groups)) {
            return false;
        }
        return this.extension.equals(other.extension);
    }

    @Override
    public String getBugfix() {
        return this.groups.get(2);
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public List<String> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    @Override
    public String getMajor() {
        return this.groups.get(0);
    }

    @Override
    public String getMinor() {
        return this.groups.get(1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)this.groups).hashCode();
        result = 31 * result + this.extension.hashCode();
        return result;
    }

    @Nonnull
    public String toString() {
        return "VersionNumber [groups=" + this.groups + ", extension=" + this.extension + "]";
    }

    @Override
    @Nonnull
    public String toVersionString() {
        return VersionNumber.toVersionString(this.groups) + this.extension;
    }
}

