/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector;

import java.io.Serializable;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.OperatingSystemFamily;
import net.sf.uadetector.ReadableOperatingSystem;
import net.sf.uadetector.VersionNumber;

public final class OperatingSystem
implements ReadableOperatingSystem,
Serializable {
    public static final OperatingSystem EMPTY = new OperatingSystem(OperatingSystemFamily.UNKNOWN, "unknown", "unknown.png", "unknown", "", "", "", VersionNumber.UNKNOWN);
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final OperatingSystemFamily family;
    @Nonnull
    private final String familyName;
    @Nonnull
    private final String icon;
    @Nonnull
    private final String name;
    @Nonnull
    private final String producer;
    @Nonnull
    private final String producerUrl;
    @Nonnull
    private final String url;
    @Nonnull
    private final VersionNumber versionNumber;

    public OperatingSystem(@Nonnull OperatingSystemFamily family, @Nonnull String familyName, @Nonnull String icon, @Nonnull String name, @Nonnull String producer, @Nonnull String producerUrl, @Nonnull String url, @Nonnull VersionNumber versionNumber) {
        Check.notNull((Object)((Object)family), (String)"family");
        Check.notNull((Object)familyName, (String)"familyName");
        Check.notNull((Object)icon, (String)"icon");
        Check.notNull((Object)name, (String)"name");
        Check.notNull((Object)producer, (String)"producer");
        Check.notNull((Object)producerUrl, (String)"producerUrl");
        Check.notNull((Object)url, (String)"url");
        Check.notNull((Object)versionNumber, (String)"versionNumber");
        this.family = family;
        this.familyName = familyName;
        this.icon = icon;
        this.name = name;
        this.producer = producer;
        this.producerUrl = producerUrl;
        this.url = url;
        this.versionNumber = versionNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperatingSystem other = (OperatingSystem)obj;
        if (this.family != other.family) {
            return false;
        }
        if (!this.familyName.equals(other.familyName)) {
            return false;
        }
        if (!this.icon.equals(other.icon)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.producer.equals(other.producer)) {
            return false;
        }
        if (!this.producerUrl.equals(other.producerUrl)) {
            return false;
        }
        if (!this.url.equals(other.url)) {
            return false;
        }
        return this.versionNumber.equals(other.versionNumber);
    }

    @Override
    public OperatingSystemFamily getFamily() {
        return this.family;
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProducer() {
        return this.producer;
    }

    @Override
    public String getProducerUrl() {
        return this.producerUrl;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public VersionNumber getVersionNumber() {
        return this.versionNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.family.hashCode();
        result = 31 * result + this.familyName.hashCode();
        result = 31 * result + this.icon.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.producer.hashCode();
        result = 31 * result + this.producerUrl.hashCode();
        result = 31 * result + this.url.hashCode();
        result = 31 * result + this.versionNumber.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OperatingSystem [family=");
        builder.append((Object)this.family);
        builder.append(", familyName=");
        builder.append(this.familyName);
        builder.append(", icon=");
        builder.append(this.icon);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", producer=");
        builder.append(this.producer);
        builder.append(", producerUrl=");
        builder.append(this.producerUrl);
        builder.append(", url=");
        builder.append(this.url);
        builder.append(", versionNumber=");
        builder.append(this.versionNumber);
        builder.append("]");
        return builder.toString();
    }
}

