/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;
import net.sf.qualitycheck.exception.IllegalNumberArgumentException;
import net.sf.qualitycheck.exception.IllegalNumberRangeException;

public final class NumberInRange {
    public static final BigInteger BYTE_MIN = BigInteger.valueOf(-128L);
    public static final BigInteger BYTE_MAX = BigInteger.valueOf(127L);
    public static final BigInteger SHORT_MIN = BigInteger.valueOf(-32768L);
    public static final BigInteger SHORT_MAX = BigInteger.valueOf(32767L);
    public static final BigInteger INTEGER_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigDecimal FLOAT_MAX = new BigDecimal(3.4028234663852886E38);
    public static final BigDecimal FLOAT_MIN = new BigDecimal(-3.4028234663852886E38);
    public static final BigDecimal DOUBLE_MAX = new BigDecimal(Double.MAX_VALUE);
    public static final BigDecimal DOUBLE_MIN = new BigDecimal(-1.7976931348623157E308);

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    public static byte checkByte(@Nonnull Number number) {
        Check.notNull(number, "number");
        if (!NumberInRange.isInByteRange(number)) {
            throw new IllegalNumberRangeException(number.toString(), BYTE_MIN, BYTE_MAX);
        }
        return number.byteValue();
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    public static short checkShort(@Nonnull Number number) {
        Check.notNull(number, "number");
        if (!NumberInRange.isInShortRange(number)) {
            throw new IllegalNumberRangeException(number.toString(), SHORT_MIN, SHORT_MAX);
        }
        return number.shortValue();
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    public static int checkInteger(@Nonnull Number number) {
        Check.notNull(number, "number");
        if (!NumberInRange.isInIntegerRange(number)) {
            throw new IllegalNumberRangeException(number.toString(), INTEGER_MIN, INTEGER_MAX);
        }
        return number.intValue();
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    public static int checkLong(@Nonnull Number number) {
        Check.notNull(number, "number");
        if (!NumberInRange.isInLongRange(number)) {
            throw new IllegalNumberRangeException(number.toString(), LONG_MIN, LONG_MAX);
        }
        return number.intValue();
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    public static float checkFloat(@Nonnull Number number) {
        Check.notNull(number, "number");
        if (!NumberInRange.isInFloatRange(number)) {
            throw new IllegalNumberRangeException(number.toString(), FLOAT_MIN, FLOAT_MAX);
        }
        return number.floatValue();
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    public static double checkDouble(@Nonnull Number number) {
        Check.notNull(number, "number");
        if (!NumberInRange.isInDoubleRange(number)) {
            throw new IllegalNumberRangeException(number.toString(), DOUBLE_MIN, DOUBLE_MAX);
        }
        return number.doubleValue();
    }

    public static boolean isInByteRange(@Nonnull Number number) {
        return NumberInRange.isInRange(number, BYTE_MIN, BYTE_MAX);
    }

    public static boolean isInShortRange(@Nonnull Number number) {
        return NumberInRange.isInRange(number, SHORT_MIN, SHORT_MAX);
    }

    public static boolean isInIntegerRange(@Nonnull Number number) {
        return NumberInRange.isInRange(number, INTEGER_MIN, INTEGER_MAX);
    }

    public static boolean isInLongRange(@Nonnull Number number) {
        return NumberInRange.isInRange(number, LONG_MIN, LONG_MAX);
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    public static boolean isInRange(@Nonnull Number number, @Nonnull BigInteger min, @Nonnull BigInteger max) {
        Check.notNull(number, "number");
        Check.notNull(min, "min");
        Check.notNull(max, "max");
        BigInteger bigInteger = null;
        if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
            bigInteger = BigInteger.valueOf(number.longValue());
        } else if (number instanceof Float || number instanceof Double) {
            bigInteger = new BigDecimal(number.doubleValue()).toBigInteger();
        } else if (number instanceof BigInteger) {
            bigInteger = (BigInteger)number;
        } else if (number instanceof BigDecimal) {
            bigInteger = ((BigDecimal)number).toBigInteger();
        } else {
            throw new IllegalNumberArgumentException("Return value is no known subclass of 'java.lang.Number': " + number.getClass().getName());
        }
        return max.compareTo(bigInteger) >= 0 && min.compareTo(bigInteger) <= 0;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    public static boolean isInRange(@Nonnull Number number, @Nonnull BigDecimal min, @Nonnull BigDecimal max) {
        Check.notNull(number, "number");
        Check.notNull(min, "min");
        Check.notNull(max, "max");
        BigDecimal bigDecimal = null;
        if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
            bigDecimal = new BigDecimal(number.longValue());
        } else if (number instanceof Float || number instanceof Double) {
            bigDecimal = new BigDecimal(number.doubleValue());
        } else if (number instanceof BigInteger) {
            bigDecimal = new BigDecimal((BigInteger)number);
        } else if (number instanceof BigDecimal) {
            bigDecimal = (BigDecimal)number;
        } else {
            throw new IllegalNumberArgumentException("Return value is no known subclass of 'java.lang.Number': " + number.getClass().getName());
        }
        return max.compareTo(bigDecimal) >= 0 && min.compareTo(bigDecimal) <= 0;
    }

    public static boolean isInFloatRange(@Nonnull Number number) {
        return NumberInRange.isInRange(number, FLOAT_MIN, FLOAT_MAX);
    }

    public static boolean isInDoubleRange(@Nonnull Number number) {
        return NumberInRange.isInRange(number, DOUBLE_MIN, DOUBLE_MAX);
    }

    private NumberInRange() {
    }
}

