/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.AutoApplySession;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;
import java.util.Arrays;
import javax.security.auth.callback.Callback;

@AutoApplySession
@Interceptor
@Priority(value=200)
public class AutoApplySessionInterceptor {
    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        if (invocationContext.getMethod().getName().equals("validateRequest") && Arrays.equals(invocationContext.getMethod().getParameterTypes(), new Class[]{HttpServletRequest.class, HttpServletResponse.class, HttpMessageContext.class})) {
            return this.validateRequest(invocationContext);
        }
        return invocationContext.proceed();
    }

    private AuthenticationStatus validateRequest(InvocationContext invocationContext) throws Exception {
        HttpMessageContext httpMessageContext = (HttpMessageContext)invocationContext.getParameters()[2];
        Principal principal = httpMessageContext.getRequest().getUserPrincipal();
        if (principal == null) {
            Object authenticationStatus = invocationContext.proceed();
            if (AuthenticationStatus.SUCCESS.equals(authenticationStatus)) {
                httpMessageContext.getMessageInfo().getMap().put("jakarta.servlet.http.registerSession", "true");
            }
            return (AuthenticationStatus)authenticationStatus;
        }
        CallerPrincipalCallback callerPrincipalCallback = new CallerPrincipalCallback(httpMessageContext.getClientSubject(), principal);
        httpMessageContext.getHandler().handle(new Callback[]{callerPrincipalCallback});
        return AuthenticationStatus.SUCCESS;
    }
}

