/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.layers.conv2d_transpose.Backward_output;
import org.apache.sysml.scripts.nn.layers.conv2d_transpose.Forward_output;
import org.apache.sysml.scripts.nn.layers.conv2d_transpose.Init_bilinear_output;
import org.apache.sysml.scripts.nn.layers.conv2d_transpose.Init_output;

public class Conv2d_transpose
extends Script {
    public Conv2d_transpose() {
        String string = "scripts/nn/layers/conv2d_transpose.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Init_output init(Object object, Object object2, Object object3, Object object4) {
        String string = "source('scripts/nn/layers/conv2d_transpose.dml') as mlcontextns;[W, b] = mlcontextns::init(F, C, Hf, Wf);";
        Script script = new Script(string);
        script.in("F", object).in("C", object2).in("Hf", object3).in("Wf", object4).out("W").out("b");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("W");
        Matrix matrix2 = mLResults.getMatrix("b");
        Init_output init_output = new Init_output(matrix, matrix2);
        return init_output;
    }

    public String init__docs() {
        String string = "init = function(int F, int C, int Hf, int Wf)\n    return (matrix[double] W, matrix[double] b){\n  /*\n   * Utility function to initialize the parameters of this layer.\n   *\n   * We use the heuristic by He et al., which limits the magnification\n   * of inputs/gradients during forward/backward passes by scaling\n   * unit-Gaussian weights by a factor of sqrt(2/n), under the\n   * assumption of relu neurons.\n   *  - http://arxiv.org/abs/1502.01852\n   *\n   * Inputs:\n   *  - F: Number of filters.\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *\n   * Outputs:\n   *  - W: Weights, of shape (C, F*Hf*Wf).\n   *  - b: Biases, of shape (F, 1).\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(int F, int C, int Hf, int Wf)\n    return (matrix[double] W, matrix[double] b){\n  /*\n   * Utility function to initialize the parameters of this layer.\n   *\n   * We use the heuristic by He et al., which limits the magnification\n   * of inputs/gradients during forward/backward passes by scaling\n   * unit-Gaussian weights by a factor of sqrt(2/n), under the\n   * assumption of relu neurons.\n   *  - http://arxiv.org/abs/1502.01852\n   *\n   * Inputs:\n   *  - F: Number of filters.\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *\n   * Outputs:\n   *  - W: Weights, of shape (C, F*Hf*Wf).\n   *  - b: Biases, of shape (F, 1).\n   */\n  W = rand(rows=C, cols=F*Hf*Wf, pdf=\"normal\") * sqrt(2/(C*Hf*Wf))\n  b = matrix(0, rows=F, cols=1)\n}\n";
        return string;
    }

    public Forward_output forward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14) {
        String string = "source('scripts/nn/layers/conv2d_transpose.dml') as mlcontextns;[out, Hout, Wout] = mlcontextns::forward(X, W, b, C, Hin, Win, Hf, Wf, strideh, stridew, padh, padw, out_padh, out_padw);";
        Script script = new Script(string);
        script.in("X", object).in("W", object2).in("b", object3).in("C", object4).in("Hin", object5).in("Win", object6).in("Hf", object7).in("Wf", object8).in("strideh", object9).in("stridew", object10).in("padh", object11).in("padw", object12).in("out_padh", object13).in("out_padw", object14).out("out").out("Hout").out("Wout");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        long l = mLResults.getLong("Hout");
        long l2 = mLResults.getLong("Wout");
        Forward_output forward_output = new Forward_output(matrix, l, l2);
        return forward_output;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, matrix[double] W, matrix[double] b,\n                   int C, int Hin, int Win, int Hf, int Wf,\n                   int strideh, int stridew, int padh, int padw,\n                   int out_padh, int out_padw)\n    return (matrix[double] out, int Hout, int Wout){\n  /*\n   * Computes the forward pass for a 2D spatial transpose convolutional\n   * layer with F filters.  The input data has N examples, each\n   * represented as a 3D tensor flattened into a single vector.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (C, F*Hf*Wf).\n   *  - b: Biases, of shape (F, 1).\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *  - out_padh: extra padding for top side. This should\n   *      lie in [0, strideh-1].\n   *  - out_padw: extra padding for right side. This should\n   *      lie in [0, stridew-1].\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, F*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, matrix[double] W, matrix[double] b,\n                   int C, int Hin, int Win, int Hf, int Wf,\n                   int strideh, int stridew, int padh, int padw,\n                   int out_padh, int out_padw)\n    return (matrix[double] out, int Hout, int Wout){\n  /*\n   * Computes the forward pass for a 2D spatial transpose convolutional\n   * layer with F filters.  The input data has N examples, each\n   * represented as a 3D tensor flattened into a single vector.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (C, F*Hf*Wf).\n   *  - b: Biases, of shape (F, 1).\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *  - out_padh: extra padding for top side. This should\n   *      lie in [0, strideh-1].\n   *  - out_padw: extra padding for right side. This should\n   *      lie in [0, stridew-1].\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, F*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   */\n  N = nrow(X)\n  F = nrow(b)\n  Hout = strideh*(Hin-1) - 2*padh + Hf + out_padh\n  Wout = stridew*(Win-1) - 2*padw + Wf + out_padw\n\n  # Transpose convolution aims to go in the other direction of\n  # (direct) convolution, i.e., given input X, produce output O such\n  # that running convolution on O recovers X. This is achieved by\n  # conv2d_backward_data (since the derivative wrt data must produce\n  # output of same size as the input to conv2d). By reusing a built-in\n  # operator we achieve efficiency and restrict the number of built-in\n  # operators to manageable levels. Plus, most other deep-learning\n  # packages make use of the same strategy which means this\n  # implementation of transpose convolution is 'in-sync' with them.\n  #\n  # One potential downside of reusing conv2d_backward_data is the fact\n  # that it rotates the filter by 180 degrees before applying it. This\n  # needs to be kept in mind when interpreting the output of transpose\n  # convolution.\n  out = conv2d_backward_data(W, X, stride=[strideh,stridew], padding=[padh,padw],\n                             input_shape=[N,F,Hout,Wout], filter_shape=[C,F,Hf,Wf])\n\n  # Add bias term to each output filter\n  out = bias_add(out, b)\n}\n";
        return string;
    }

    public Backward_output backward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15) {
        String string = "source('scripts/nn/layers/conv2d_transpose.dml') as mlcontextns;[dX, dW, db] = mlcontextns::backward(dout, Hout, Wout, X, W, b, C, Hin, Win, Hf, Wf, strideh, stridew, padh, padw);";
        Script script = new Script(string);
        script.in("dout", object).in("Hout", object2).in("Wout", object3).in("X", object4).in("W", object5).in("b", object6).in("C", object7).in("Hin", object8).in("Win", object9).in("Hf", object10).in("Wf", object11).in("strideh", object12).in("stridew", object13).in("padh", object14).in("padw", object15).out("dX").out("dW").out("db");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        Matrix matrix2 = mLResults.getMatrix("dW");
        Matrix matrix3 = mLResults.getMatrix("db");
        Backward_output backward_output = new Backward_output(matrix, matrix2, matrix3);
        return backward_output;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, int Hout, int Wout,\n                    matrix[double] X, matrix[double] W, matrix[double] b,\n                    int C, int Hin, int Win, int Hf, int Wf,\n                    int strideh, int stridew, int padh, int padw)\n    return (matrix[double] dX, matrix[double] dW, matrix[double] db){\n  /*\n   * Computes the backward pass for a 2D spatial transpose\n   * convolutional layer with F filters.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of\n   *      shape (N, F*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (C, F*Hf*Wf).\n   *  - b: Biases, of shape (F, 1).\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   *  - dW: Gradient wrt `W`, of shape (C, F*Hf*Wf).\n   *  - db: Gradient wrt `b`, of shape (F, 1).\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, int Hout, int Wout,\n                    matrix[double] X, matrix[double] W, matrix[double] b,\n                    int C, int Hin, int Win, int Hf, int Wf,\n                    int strideh, int stridew, int padh, int padw)\n    return (matrix[double] dX, matrix[double] dW, matrix[double] db){\n  /*\n   * Computes the backward pass for a 2D spatial transpose\n   * convolutional layer with F filters.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of\n   *      shape (N, F*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (C, F*Hf*Wf).\n   *  - b: Biases, of shape (F, 1).\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   *  - dW: Gradient wrt `W`, of shape (C, F*Hf*Wf).\n   *  - db: Gradient wrt `b`, of shape (F, 1).\n   */\n  N = nrow(X)\n  F = nrow(b)\n\n  # conv2d_backward_filter takes the input and delta map as first and\n  # second args, respectively. Given that we need to compute the\n  # grad (wrt to filter) for transpose convolution where the roles of\n  # the input and output are reversed, we reverse the order of the\n  # args (along with setting input_shape to the delta map shape).\n  # Effectively, we are running a direct convolution with X as the\n  # filter and the dout as the input. To convince oneself that the\n  # interconnections between the cells of the filter, input and delta\n  # map are preserved please keep in mind that the forward of\n  # convolution transpose rotates the filter by 180 degrees before\n  # applying it.\n  dW = conv2d_backward_filter(dout, X, stride=[strideh,stridew], padding=[padh,padw],\n                              input_shape=[N,F,Hout,Wout], filter_shape=[C,F,Hf,Wf])\n\n  # Since the forward for transpose convolution makes a call to\n  # conv2d_backward_data, to compute its derivative wrt to data\n  # we can run conv2d by applying the filter on the delta\n  # map (this makes sense because convolution transpose is the\n  # 'reverse' of convolution). Its easy to see that this will produce\n  # output of the required size. To convince oneself that conv2d will\n  # respect the interconnections between the cells in the delta map\n  # and the filter, keep in mind that the forward function rotates the\n  # filter by 180 degrees before applying it.\n  dX = conv2d(dout, W, input_shape=[N,F,Hout,Wout], filter_shape=[C,F,Hf,Wf],\n              stride=[strideh,stridew], padding=[padh,padw])\n\n  # Partial derivatives for bias vector\n  db = util::channel_sums(dout, F, Hout, Wout)\n}\n";
        return string;
    }

    public Init_bilinear_output init_bilinear(Object object, Object object2) {
        String string = "source('scripts/nn/layers/conv2d_transpose.dml') as mlcontextns;[W, b] = mlcontextns::init_bilinear(C, K);";
        Script script = new Script(string);
        script.in("C", object).in("K", object2).out("W").out("b");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("W");
        Matrix matrix2 = mLResults.getMatrix("b");
        Init_bilinear_output init_bilinear_output = new Init_bilinear_output(matrix, matrix2);
        return init_bilinear_output;
    }

    public String init_bilinear__docs() {
        String string = "init_bilinear = function(int C, int K)\n    return (matrix[double] W, matrix[double] b){\n  /*\n   * Utility function to upsample using this layer.\n   *\n   * Upsampling the input by factor f (each side) requires\n   * channel-wise independent kernels of size K = 2f - f%2,\n   * stride = f and pad = ceil((f-1)/2). The weights are set\n   * via bilinear interpolation, bias is set to 0.\n   *\n   * Inputs:\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - K: Kernel size (upsampling requires a square filter\n   *      of size K X K).\n   *\n   * Outputs:\n   *  - W: Weights, of shape (C, C*K*K).\n   *  - b: Biases, of shape (C, 1).\n   */\n";
        return string;
    }

    public String init_bilinear__source() {
        String string = "init_bilinear = function(int C, int K)\n    return (matrix[double] W, matrix[double] b){\n  /*\n   * Utility function to upsample using this layer.\n   *\n   * Upsampling the input by factor f (each side) requires\n   * channel-wise independent kernels of size K = 2f - f%2,\n   * stride = f and pad = ceil((f-1)/2). The weights are set\n   * via bilinear interpolation, bias is set to 0.\n   *\n   * Inputs:\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - K: Kernel size (upsampling requires a square filter\n   *      of size K X K).\n   *\n   * Outputs:\n   *  - W: Weights, of shape (C, C*K*K).\n   *  - b: Biases, of shape (C, 1).\n   */\n  factor_up = ceil(K / 2)\n  center = (2 * factor_up - factor_up %% 2 - 1) / 2 / factor_up\n  vect = 1 - abs(seq(0, K-1) / factor_up - center)\n  weights = matrix(vect %*% t(vect), rows=1, cols=K*K)\n\n  # To create a multi-channel channel-independent upsampling filter,\n  # we need to intersperse the filter weights with 0s. For instance,\n  # consider the case of 2X upsampling. In this case, K=4 and we have\n  # K^2=16 weights to include into the 3D tensor representing the\n  # filter which should look like the following (assuming 3 channels):\n  #\n  #   <-16 weights-> <---------32 0s--------->\n  #   X X ...... X X 0 0 0 ............. 0 0 0\n  #   0 .......... 0 X X .... X X 0 ...... 0 0\n  #   0 0 0 ............... 0 0 0 X X .... X X\n  #\n  # To be clear, the second row should have 16 0s followed by 16\n  # weights followed by 16 0s.\n  #\n  # To create the above filter, we take advantage of the fact that\n  # between two sets of non-zero weights, there is always a sequence\n  # of C*K*K 0s. In the above example, C*K^2 = 48 (e.g., 32 trailing\n  # 0s in the first row and 16 leading 0s in the second row).\n  #\n  # Note that, in the special case of C=1 we do not need to\n  # intersperse with 0s (no question of being channel-wise independent\n  # since we have only 1 channel).\n\n  # Append C*K*K trailing 0s to the K*K kernel and replicate the\n  # resulting row C times\n  repl_weights = matrix(1, rows=C, cols=1) %*% cbind(weights, matrix(0, rows=1, cols=C*K*K))\n\n  # The above operation added extra C*K*K trailing 0s in the last row\n  # that we do not need. Thus, we need to:\n  #   1) reshape the resulting matrix into a row\n  #   2) 'Clip off' the last few 0s using indexing and reshape the\n  #      result into the expected filter shape ([C, C, K, K])\n  repl_weights_row = matrix(repl_weights, rows=1, cols=C*(C+1)*K^2)\n  W = matrix(repl_weights_row[1,1:(C*K)^2], rows=C, cols=C*K^2)\n\n  b = matrix(0, rows=C, cols=1)\n}\n";
        return string;
    }
}

