/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.gpu;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.gpu.BuiltinUnaryGPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysml.runtime.matrix.data.LibMatrixCuDNN;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.utils.GPUStatistics;

public class MatrixBuiltinGPUInstruction
extends BuiltinUnaryGPUInstruction {
    protected MatrixBuiltinGPUInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String instr) {
        super(op, in, out, 1, opcode, instr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary;
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        String opcode = this.getOpcode();
        MatrixObject mat = this.getMatrixInputForGPUInstruction(ec, this._input.getName());
        ec.setMetaData(this._output.getName(), mat.getNumRows(), mat.getNumColumns());
        switch (opcode) {
            case "exp": {
                LibMatrixCUDA.exp(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "sqrt": {
                LibMatrixCUDA.sqrt(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "log": {
                LibMatrixCUDA.log(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "round": {
                LibMatrixCUDA.round(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "floor": {
                LibMatrixCUDA.floor(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "ceil": {
                LibMatrixCUDA.ceil(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "abs": {
                LibMatrixCUDA.abs(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "sin": {
                LibMatrixCUDA.sin(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "cos": {
                LibMatrixCUDA.cos(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "tan": {
                LibMatrixCUDA.tan(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "sinh": {
                LibMatrixCUDA.sinh(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "cosh": {
                LibMatrixCUDA.cosh(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "tanh": {
                LibMatrixCUDA.tanh(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "asin": {
                LibMatrixCUDA.asin(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "acos": {
                LibMatrixCUDA.acos(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "atan": {
                LibMatrixCUDA.atan(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "sign": {
                LibMatrixCUDA.sign(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "sigmoid": {
                LibMatrixCUDA.sigmoid(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            case "softmax": {
                LibMatrixCuDNN.softmax(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported GPU operator:" + opcode);
            }
        }
        ec.releaseMatrixInputForGPUInstruction(this._input.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }
}

