/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.oval.AbstractCheck;
import net.sf.oval.Check;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.collection.CollectionFactory;
import net.sf.oval.configuration.CheckInitializationListener;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.annotation.AnnotationCheck;
import net.sf.oval.configuration.annotation.AnnotationCheckExclusion;
import net.sf.oval.configuration.annotation.Constraint;
import net.sf.oval.configuration.annotation.Constraints;
import net.sf.oval.configuration.annotation.Exclusion;
import net.sf.oval.configuration.annotation.IsInvariant;
import net.sf.oval.configuration.annotation.Validatable;
import net.sf.oval.configuration.pojo.elements.ClassConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstructorConfiguration;
import net.sf.oval.configuration.pojo.elements.FieldConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodPostExecutionConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodPreExecutionConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodReturnValueConfiguration;
import net.sf.oval.configuration.pojo.elements.ObjectConfiguration;
import net.sf.oval.configuration.pojo.elements.ParameterConfiguration;
import net.sf.oval.constraint.ConstraintsCheck;
import net.sf.oval.exception.OValException;
import net.sf.oval.exception.ReflectionException;
import net.sf.oval.guard.Guarded;
import net.sf.oval.guard.Post;
import net.sf.oval.guard.PostCheck;
import net.sf.oval.guard.PostValidateThis;
import net.sf.oval.guard.Pre;
import net.sf.oval.guard.PreCheck;
import net.sf.oval.guard.PreValidateThis;
import net.sf.oval.internal.util.ArrayUtils;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.internal.util.ReflectionUtils;

public class AnnotationsConfigurer
implements Configurer {
    protected final Set<CheckInitializationListener> listeners = new LinkedHashSet<CheckInitializationListener>(2);

    private List<ParameterConfiguration> _createParameterConfigs(Class<?>[] paramTypes, Annotation[][] paramAnnos, AnnotatedType[] annotatedParamTypes) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<ParameterConfiguration> paramCfgs = cf.createList(paramAnnos.length);
        List<Check> paramChecks = cf.createList(2);
        List paramCheckExclusions = cf.createList(2);
        int i = 0;
        while (i < paramAnnos.length) {
            Annotation[] annotationArray = paramAnnos[i];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation anno = annotationArray[n2];
                if (anno.annotationType().isAnnotationPresent(Constraint.class)) {
                    paramChecks.add(this.initializeCheck(anno, new ConstraintTarget[0]));
                } else if (anno.annotationType().isAnnotationPresent(Constraints.class)) {
                    this.initializeChecks(anno, paramChecks, new ConstraintTarget[0]);
                } else if (anno.annotationType().isAnnotationPresent(Exclusion.class)) {
                    paramCheckExclusions.add(this.initializeExclusion(anno));
                }
                ++n2;
            }
            this.initializeGenericTypeChecks(paramTypes[i], annotatedParamTypes[i], paramChecks);
            ParameterConfiguration paramCfg = new ParameterConfiguration();
            paramCfgs.add(paramCfg);
            paramCfg.type = paramTypes[i];
            if (!paramChecks.isEmpty()) {
                paramCfg.checks = paramChecks;
                paramChecks = cf.createList(2);
            }
            if (!paramCheckExclusions.isEmpty()) {
                paramCfg.checkExclusions = paramCheckExclusions;
                paramCheckExclusions = cf.createList(2);
            }
            ++i;
        }
        return paramCfgs;
    }

    public boolean addCheckInitializationListener(CheckInitializationListener listener) {
        Assert.argumentNotNull("listener", "[listener] must not be null");
        return this.listeners.add(listener);
    }

    protected void configureCtorParamChecks(ClassConfiguration classCfg) {
        Constructor<?>[] constructorArray = classCfg.type.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> ctor = constructorArray[n2];
            List<ParameterConfiguration> paramCfgs = this._createParameterConfigs(ctor.getParameterTypes(), ctor.getParameterAnnotations(), ctor.getAnnotatedParameterTypes());
            boolean postValidateThis = ctor.isAnnotationPresent(PostValidateThis.class);
            if (postValidateThis || !paramCfgs.isEmpty()) {
                if (classCfg.constructorConfigurations == null) {
                    classCfg.constructorConfigurations = Validator.getCollectionFactory().createSet(2);
                }
                ConstructorConfiguration cc = new ConstructorConfiguration();
                cc.parameterConfigurations = paramCfgs;
                cc.postCheckInvariants = postValidateThis;
                classCfg.constructorConfigurations.add(cc);
            }
            ++n2;
        }
    }

    protected void configureFieldChecks(ClassConfiguration classCfg) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<Check> checks = cf.createList(2);
        Field[] fieldArray = classCfg.type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Annotation[] annotationArray = field.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation anno = annotationArray[n4];
                if (anno.annotationType().isAnnotationPresent(Constraint.class)) {
                    checks.add(this.initializeCheck(anno, new ConstraintTarget[0]));
                } else if (anno.annotationType().isAnnotationPresent(Constraints.class)) {
                    this.initializeChecks(anno, checks, new ConstraintTarget[0]);
                }
                ++n4;
            }
            this.initializeGenericTypeChecks(field.getType(), field.getAnnotatedType(), checks);
            if (!checks.isEmpty()) {
                if (classCfg.fieldConfigurations == null) {
                    classCfg.fieldConfigurations = cf.createSet(2);
                }
                FieldConfiguration fc = new FieldConfiguration();
                fc.name = field.getName();
                fc.checks = checks;
                classCfg.fieldConfigurations.add(fc);
                checks = cf.createList(2);
            }
            ++n2;
        }
    }

    protected void configureMethodChecks(ClassConfiguration classCfg) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<Check> returnValueChecks = cf.createList(2);
        List preChecks = cf.createList(2);
        List postChecks = cf.createList(2);
        Method[] methodArray = classCfg.type.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            boolean preValidateThis = false;
            boolean postValidateThis = false;
            Annotation[] annotationArray = ReflectionUtils.getAnnotations(method, Boolean.TRUE.equals(classCfg.inspectInterfaces), classCfg.includedInterfaces, classCfg.excludedInterfaces);
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                AbstractCheck pc;
                Annotation anno = annotationArray[n4];
                if (anno instanceof Pre) {
                    pc = new PreCheck();
                    ((PreCheck)pc).configure((Pre)anno);
                    preChecks.add(pc);
                } else if (anno instanceof PreValidateThis) {
                    preValidateThis = true;
                } else if (anno instanceof Post) {
                    pc = new PostCheck();
                    ((PostCheck)pc).configure((Post)anno);
                    postChecks.add(pc);
                } else if (anno instanceof PostValidateThis) {
                    postValidateThis = true;
                } else if (anno.annotationType().isAnnotationPresent(Constraint.class)) {
                    returnValueChecks.add(this.initializeCheck(anno, new ConstraintTarget[0]));
                } else if (anno.annotationType().isAnnotationPresent(Constraints.class)) {
                    this.initializeChecks(anno, returnValueChecks, new ConstraintTarget[0]);
                }
                ++n4;
            }
            this.initializeGenericTypeChecks(method.getReturnType(), method.getAnnotatedReturnType(), returnValueChecks);
            if (Boolean.TRUE.equals(classCfg.inspectInterfaces)) {
                for (Method interfaceMethod : ReflectionUtils.getInterfaceMethods(method, classCfg.includedInterfaces, classCfg.excludedInterfaces)) {
                    this.initializeGenericTypeChecks(interfaceMethod.getReturnType(), interfaceMethod.getAnnotatedReturnType(), returnValueChecks);
                }
            }
            List<ParameterConfiguration> paramCfg = this._createParameterConfigs(method.getParameterTypes(), ReflectionUtils.getParameterAnnotations(method, Boolean.TRUE.equals(classCfg.inspectInterfaces), classCfg.includedInterfaces, classCfg.excludedInterfaces), method.getAnnotatedParameterTypes());
            if (preValidateThis || postValidateThis || !paramCfg.isEmpty() || !returnValueChecks.isEmpty() || !preChecks.isEmpty() || !postChecks.isEmpty()) {
                if (classCfg.methodConfigurations == null) {
                    classCfg.methodConfigurations = cf.createSet(2);
                }
                MethodConfiguration mc = new MethodConfiguration();
                mc.name = method.getName();
                mc.parameterConfigurations = paramCfg;
                mc.isInvariant = ReflectionUtils.isAnnotationPresent(method, IsInvariant.class, Boolean.TRUE.equals(classCfg.inspectInterfaces), classCfg.includedInterfaces, classCfg.excludedInterfaces);
                mc.preCheckInvariants = preValidateThis;
                mc.postCheckInvariants = postValidateThis;
                if (!returnValueChecks.isEmpty()) {
                    mc.returnValueConfiguration = new MethodReturnValueConfiguration();
                    mc.returnValueConfiguration.checks = returnValueChecks;
                    returnValueChecks = cf.createList(2);
                }
                if (!preChecks.isEmpty()) {
                    mc.preExecutionConfiguration = new MethodPreExecutionConfiguration();
                    mc.preExecutionConfiguration.checks = preChecks;
                    preChecks = cf.createList(2);
                }
                if (!postChecks.isEmpty()) {
                    mc.postExecutionConfiguration = new MethodPostExecutionConfiguration();
                    mc.postExecutionConfiguration.checks = postChecks;
                    postChecks = cf.createList(2);
                }
                classCfg.methodConfigurations.add(mc);
            }
            ++n2;
        }
    }

    protected void configureObjectLevelChecks(ClassConfiguration classCfg) {
        List<Check> checks = Validator.getCollectionFactory().createList(2);
        Annotation[] annotationArray = ReflectionUtils.getAnnotations(classCfg.type, Boolean.TRUE.equals(classCfg.inspectInterfaces), classCfg.includedInterfaces, classCfg.excludedInterfaces);
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno.annotationType().isAnnotationPresent(Constraint.class)) {
                checks.add(this.initializeCheck(anno, new ConstraintTarget[0]));
            } else if (anno.annotationType().isAnnotationPresent(Constraints.class)) {
                this.initializeChecks(anno, checks, new ConstraintTarget[0]);
            }
            ++n2;
        }
        if (!checks.isEmpty()) {
            classCfg.objectConfiguration = new ObjectConfiguration();
            classCfg.objectConfiguration.checks = checks;
        }
    }

    @Override
    public ClassConfiguration getClassConfiguration(Class<?> clazz) {
        ClassConfiguration classCfg = new ClassConfiguration();
        classCfg.type = clazz;
        Guarded guarded = clazz.getAnnotation(Guarded.class);
        Validatable validatable = clazz.getAnnotation(Validatable.class);
        if (guarded == null) {
            classCfg.applyFieldConstraintsToConstructors = false;
            classCfg.applyFieldConstraintsToSetters = false;
            classCfg.assertParametersNotNull = false;
            classCfg.checkInvariants = false;
            classCfg.inspectInterfaces = validatable == null || validatable.inspectInterfaces();
        } else {
            classCfg.applyFieldConstraintsToConstructors = guarded.applyFieldConstraintsToConstructors();
            classCfg.applyFieldConstraintsToSetters = guarded.applyFieldConstraintsToSetters();
            classCfg.assertParametersNotNull = guarded.assertParametersNotNull();
            classCfg.checkInvariants = guarded.checkInvariants();
            classCfg.inspectInterfaces = validatable == null ? guarded.inspectInterfaces() : validatable.inspectInterfaces();
        }
        if (validatable != null) {
            classCfg.excludedInterfaces = ArrayUtils.asSet(validatable.excludedInterfaces());
            classCfg.includedInterfaces = ArrayUtils.asSet(validatable.includedInterfaces());
        }
        this.configureObjectLevelChecks(classCfg);
        this.configureFieldChecks(classCfg);
        this.configureCtorParamChecks(classCfg);
        this.configureMethodChecks(classCfg);
        return classCfg;
    }

    @Override
    public ConstraintSetConfiguration getConstraintSetConfiguration(String constraintSetId) {
        return null;
    }

    protected <ConstraintAnnotation extends Annotation> AnnotationCheck<ConstraintAnnotation> initializeCheck(ConstraintAnnotation constraintAnnotation, ConstraintTarget ... targetOverrides) throws ReflectionException {
        assert (constraintAnnotation != null);
        Constraint constraint = constraintAnnotation.annotationType().getAnnotation(Constraint.class);
        Class<AnnotationCheck<ConstraintAnnotation>> checkClass = constraint.checkWith();
        AnnotationCheck<ConstraintAnnotation> check = this.newCheckInstance(checkClass);
        check.configure(constraintAnnotation);
        if (targetOverrides.length > 0) {
            check.setAppliesTo(targetOverrides);
        }
        for (CheckInitializationListener listener : this.listeners) {
            listener.onCheckInitialized(check);
        }
        return check;
    }

    protected <ConstraintsAnnotation extends Annotation> void initializeChecks(ConstraintsAnnotation constraintsAnnotation, List<Check> checks, ConstraintTarget ... targetOverrides) throws ReflectionException {
        try {
            Method getValue = constraintsAnnotation.annotationType().getDeclaredMethod("value", null);
            Object[] constraintAnnotations = (Object[])getValue.invoke(constraintsAnnotation, null);
            ConstraintsCheck constraintsCheck = new ConstraintsCheck();
            constraintsCheck.configure(constraintsAnnotation);
            constraintsCheck.checks = new ArrayList<Check>(constraintAnnotations.length);
            Object[] objectArray = constraintAnnotations;
            int n = constraintAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                Object ca = objectArray[n2];
                constraintsCheck.checks.add(this.initializeCheck((Annotation)ca, targetOverrides));
                ++n2;
            }
            checks.add(constraintsCheck);
        }
        catch (ReflectionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ReflectionException("Cannot initialize constraint check " + constraintsAnnotation.annotationType().getName(), ex);
        }
    }

    protected <ExclusionAnnotation extends Annotation> AnnotationCheckExclusion<ExclusionAnnotation> initializeExclusion(ExclusionAnnotation exclusionAnnotation) throws ReflectionException {
        assert (exclusionAnnotation != null);
        Exclusion constraint = exclusionAnnotation.annotationType().getAnnotation(Exclusion.class);
        Class<? extends AnnotationCheckExclusion<? extends Annotation>> exclusionClass = constraint.excludeWith();
        try {
            AnnotationCheckExclusion<? extends Annotation> exclusion = exclusionClass.newInstance();
            exclusion.configure(exclusionAnnotation);
            return exclusion;
        }
        catch (Exception ex) {
            throw new ReflectionException("Cannot initialize constraint exclusion " + exclusionClass.getName(), ex);
        }
    }

    protected void initializeGenericTypeChecks(Class<?> type, AnnotatedType annotatedType, List<Check> checks) {
        block12: {
            Annotation anno;
            AnnotatedParameterizedType fieldAPType;
            block13: {
                if (!(annotatedType instanceof AnnotatedParameterizedType)) break block12;
                fieldAPType = (AnnotatedParameterizedType)annotatedType;
                if (!Collection.class.isAssignableFrom(type)) break block13;
                AnnotatedType genericArgType = fieldAPType.getAnnotatedActualTypeArguments()[0];
                Annotation[] annotationArray = genericArgType.getAnnotations();
                int n = annotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation anno2 = annotationArray[n2];
                    if (anno2.annotationType().isAnnotationPresent(Constraint.class)) {
                        checks.add(this.initializeCheck(anno2, ConstraintTarget.VALUES));
                    } else if (anno2.annotationType().isAnnotationPresent(Constraints.class)) {
                        this.initializeChecks(anno2, checks, ConstraintTarget.VALUES);
                    }
                    ++n2;
                }
                break block12;
            }
            if (!Map.class.isAssignableFrom(type)) break block12;
            AnnotatedType genericArgType = fieldAPType.getAnnotatedActualTypeArguments()[0];
            Annotation[] annotationArray = genericArgType.getAnnotations();
            int n = annotationArray.length;
            int n3 = 0;
            while (n3 < n) {
                anno = annotationArray[n3];
                if (anno.annotationType().isAnnotationPresent(Constraint.class)) {
                    checks.add(this.initializeCheck(anno, ConstraintTarget.KEYS));
                } else if (anno.annotationType().isAnnotationPresent(Constraints.class)) {
                    this.initializeChecks(anno, checks, ConstraintTarget.KEYS);
                }
                ++n3;
            }
            genericArgType = fieldAPType.getAnnotatedActualTypeArguments()[1];
            annotationArray = genericArgType.getAnnotations();
            n = annotationArray.length;
            n3 = 0;
            while (n3 < n) {
                anno = annotationArray[n3];
                if (anno.annotationType().isAnnotationPresent(Constraint.class)) {
                    checks.add(this.initializeCheck(anno, ConstraintTarget.VALUES));
                } else if (anno.annotationType().isAnnotationPresent(Constraints.class)) {
                    this.initializeChecks(anno, checks, ConstraintTarget.VALUES);
                }
                ++n3;
            }
        }
    }

    protected <ConstraintAnnotation extends Annotation> AnnotationCheck<ConstraintAnnotation> newCheckInstance(Class<AnnotationCheck<ConstraintAnnotation>> checkClass) throws OValException {
        try {
            return checkClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new ReflectionException("Cannot initialize constraint check " + checkClass.getName(), ex);
        }
    }

    public boolean removeCheckInitializationListener(CheckInitializationListener listener) {
        return this.listeners.remove(listener);
    }
}

