/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.NetworkUtils;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ForwardedHandler
implements HttpHandler {
    public static final String BY = "by";
    public static final String FOR = "for";
    public static final String HOST = "host";
    public static final String PROTO = "proto";
    private static final String UNKNOWN = "unknown";
    private static final boolean DEFAULT_CHANGE_LOCAL_ADDR_PORT = Boolean.getBoolean("io.undertow.forwarded.change-local-addr-port");
    private static final String CHANGE_LOCAL_ADDR_PORT = "change-local-addr-port";
    private final boolean isChangeLocalAddrPort;
    private final HttpHandler next;
    private static final Map<String, Token> TOKENS;

    public ForwardedHandler(HttpHandler next) {
        this(next, DEFAULT_CHANGE_LOCAL_ADDR_PORT);
    }

    public ForwardedHandler(HttpHandler next, boolean isChangeLocalAddrPort) {
        this.next = next;
        this.isChangeLocalAddrPort = isChangeLocalAddrPort;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderValues forwarded = exchange.getRequestHeaders().get(Headers.FORWARDED);
        if (forwarded != null) {
            InetSocketAddress sourceAddress;
            InetSocketAddress destAddress;
            HashMap<Token, String> values = new HashMap<Token, String>();
            for (String val : forwarded) {
                ForwardedHandler.parseHeader(val, values);
            }
            String host = (String)values.get((Object)Token.HOST);
            String proto = (String)values.get((Object)Token.PROTO);
            String by = (String)values.get((Object)Token.BY);
            String forVal = (String)values.get((Object)Token.FOR);
            if (host != null) {
                exchange.getRequestHeaders().put(Headers.HOST, host);
                if (this.isChangeLocalAddrPort) {
                    exchange.setDestinationAddress(InetSocketAddress.createUnresolved(exchange.getHostName(), exchange.getHostPort()));
                }
            } else if (by != null && (destAddress = ForwardedHandler.parseAddress(by)) != null && this.isChangeLocalAddrPort) {
                exchange.setDestinationAddress(destAddress);
            }
            if (proto != null) {
                exchange.setRequestScheme(proto);
            }
            if (forVal != null && (sourceAddress = ForwardedHandler.parseAddress(forVal)) != null) {
                exchange.setSourceAddress(sourceAddress);
            }
        }
        this.next.handleRequest(exchange);
    }

    static InetSocketAddress parseAddress(String address) {
        try {
            if (address.equals(UNKNOWN)) {
                return null;
            }
            if (address.startsWith("_")) {
                return null;
            }
            if (address.startsWith("[")) {
                int index = address.indexOf("]");
                String ipPart = address.substring(1, index);
                int pos = address.indexOf(58, index);
                if (pos == -1) {
                    return new InetSocketAddress(NetworkUtils.parseIpv6Address(ipPart), 0);
                }
                return new InetSocketAddress(NetworkUtils.parseIpv6Address(ipPart), ForwardedHandler.parsePort(address.substring(pos + 1)));
            }
            int pos = address.indexOf(58);
            if (pos == -1) {
                return new InetSocketAddress(NetworkUtils.parseIpv4Address(address), 0);
            }
            return new InetSocketAddress(NetworkUtils.parseIpv4Address(address.substring(0, pos)), ForwardedHandler.parsePort(address.substring(pos + 1)));
        }
        catch (Exception e) {
            UndertowLogger.REQUEST_IO_LOGGER.debug("Failed to parse address", e);
            return null;
        }
    }

    private static int parsePort(String substring) {
        if (substring.startsWith("_")) {
            return 0;
        }
        return Integer.parseInt(substring);
    }

    static void parseHeader(String header, Map<Token, String> response) {
        if (response.size() == Token.values().length) {
            return;
        }
        char[] headerChars = header.toCharArray();
        SearchingFor searchingFor = SearchingFor.START_OF_NAME;
        int nameStart = 0;
        Token currentToken = null;
        int valueStart = 0;
        int escapeCount = 0;
        boolean containsEscapes = false;
        block7: for (int i = 0; i < headerChars.length; ++i) {
            switch (searchingFor) {
                case START_OF_NAME: {
                    if (headerChars[i] == ';' || Character.isWhitespace(headerChars[i])) continue block7;
                    nameStart = i;
                    searchingFor = SearchingFor.EQUALS_SIGN;
                    continue block7;
                }
                case EQUALS_SIGN: {
                    if (headerChars[i] != '=') continue block7;
                    String paramName = String.valueOf(headerChars, nameStart, i - nameStart);
                    currentToken = TOKENS.get(paramName.toLowerCase(Locale.ENGLISH));
                    searchingFor = SearchingFor.START_OF_VALUE;
                    continue block7;
                }
                case START_OF_VALUE: {
                    if (Character.isWhitespace(headerChars[i])) continue block7;
                    if (headerChars[i] == '\"') {
                        valueStart = i + 1;
                        searchingFor = SearchingFor.LAST_QUOTE;
                        continue block7;
                    }
                    valueStart = i;
                    searchingFor = SearchingFor.END_OF_VALUE;
                    continue block7;
                }
                case LAST_QUOTE: {
                    String value;
                    if (headerChars[i] == '\\') {
                        ++escapeCount;
                        containsEscapes = true;
                        continue block7;
                    }
                    if (headerChars[i] == '\"' && escapeCount % 2 == 0) {
                        value = String.valueOf(headerChars, valueStart, i - valueStart);
                        if (containsEscapes) {
                            StringBuilder sb = new StringBuilder();
                            boolean lastEscape = false;
                            for (int j = 0; j < value.length(); ++j) {
                                char c = value.charAt(j);
                                if (c == '\\' && !lastEscape) {
                                    lastEscape = true;
                                    continue;
                                }
                                lastEscape = false;
                                sb.append(c);
                            }
                            value = sb.toString();
                            containsEscapes = false;
                        }
                        if (currentToken != null && !response.containsKey((Object)currentToken)) {
                            response.put(currentToken, value);
                        }
                        searchingFor = SearchingFor.START_OF_NAME;
                        escapeCount = 0;
                        continue block7;
                    }
                    escapeCount = 0;
                    continue block7;
                }
                case END_OF_VALUE: {
                    if (headerChars[i] != ';' && headerChars[i] != ',' && !Character.isWhitespace(headerChars[i])) continue block7;
                    String value = String.valueOf(headerChars, valueStart, i - valueStart);
                    if (currentToken != null && !response.containsKey((Object)currentToken)) {
                        response.put(currentToken, value);
                    }
                    searchingFor = SearchingFor.START_OF_NAME;
                }
            }
        }
        if (searchingFor == SearchingFor.END_OF_VALUE) {
            String value = String.valueOf(headerChars, valueStart, headerChars.length - valueStart);
            if (currentToken != null && !response.containsKey((Object)currentToken)) {
                response.put(currentToken, value);
            }
        } else if (searchingFor != SearchingFor.START_OF_NAME) {
            throw UndertowMessages.MESSAGES.invalidHeader();
        }
    }

    public String toString() {
        return "forwarded()";
    }

    static {
        HashMap<String, Token> map = new HashMap<String, Token>();
        for (Token token : Token.values()) {
            map.put(token.name().toLowerCase(), token);
        }
        TOKENS = Collections.unmodifiableMap(map);
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final boolean isChangeLocalAddrPort;

        private Wrapper(boolean isChangeLocalAddrPort) {
            this.isChangeLocalAddrPort = isChangeLocalAddrPort;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new ForwardedHandler(handler, this.isChangeLocalAddrPort);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "forwarded";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put(ForwardedHandler.CHANGE_LOCAL_ADDR_PORT, Boolean.TYPE);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return ForwardedHandler.CHANGE_LOCAL_ADDR_PORT;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            Boolean isChangeLocalAddrPort = (Boolean)config.get(ForwardedHandler.CHANGE_LOCAL_ADDR_PORT);
            return new Wrapper(isChangeLocalAddrPort == null ? DEFAULT_CHANGE_LOCAL_ADDR_PORT : isChangeLocalAddrPort);
        }
    }

    private static enum SearchingFor {
        START_OF_NAME,
        EQUALS_SIGN,
        START_OF_VALUE,
        LAST_QUOTE,
        END_OF_VALUE;

    }

    static enum Token {
        BY,
        FOR,
        HOST,
        PROTO;

    }
}

