/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.version.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.version.PluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.plugin.version.PluginVersionResult;
import org.apache.maven.plugin.version.internal.DefaultPluginVersionResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.MetadataRequest;
import org.sonatype.aether.resolution.MetadataResult;
import org.sonatype.aether.util.listener.DefaultRepositoryEvent;
import org.sonatype.aether.util.metadata.DefaultMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PluginVersionResolver.class)
public class DefaultPluginVersionResolver
implements PluginVersionResolver {
    private static final String REPOSITORY_CONTEXT = "plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private MetadataReader metadataReader;

    @Override
    public PluginVersionResult resolve(PluginVersionRequest request) throws PluginVersionResolutionException {
        this.logger.debug("Resolving plugin version for " + request.getGroupId() + ":" + request.getArtifactId());
        PluginVersionResult result = this.resolveFromProject(request);
        if (result == null) {
            result = this.resolveFromRepository(request);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Resolved plugin version for " + request.getGroupId() + ":" + request.getArtifactId() + " to " + result.getVersion() + " from repository " + result.getRepository());
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolved plugin version for " + request.getGroupId() + ":" + request.getArtifactId() + " to " + result.getVersion() + " from POM " + request.getPom());
        }
        return result;
    }

    private PluginVersionResult resolveFromRepository(PluginVersionRequest request) throws PluginVersionResolutionException {
        DefaultPluginVersionResult result = new DefaultPluginVersionResult();
        DefaultMetadata metadata = new DefaultMetadata(request.getGroupId(), request.getArtifactId(), "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
        ArrayList<MetadataRequest> requests = new ArrayList<MetadataRequest>();
        requests.add(new MetadataRequest((org.sonatype.aether.metadata.Metadata)metadata, null, REPOSITORY_CONTEXT));
        for (RemoteRepository repository : request.getRepositories()) {
            requests.add(new MetadataRequest((org.sonatype.aether.metadata.Metadata)metadata, repository, REPOSITORY_CONTEXT));
        }
        List results = this.repositorySystem.resolveMetadata(request.getRepositorySession(), requests);
        LocalRepository localRepo = request.getRepositorySession().getLocalRepository();
        Versions versions = new Versions();
        for (MetadataResult res : results) {
            RemoteRepository repository = res.getRequest().getRepository();
            if (repository == null) {
                repository = request.getRepositorySession().getLocalRepository();
            }
            this.mergeMetadata(request.getRepositorySession(), versions, res.getMetadata(), (ArtifactRepository)repository);
        }
        if (StringUtils.isNotEmpty((String)versions.releaseVersion)) {
            result.setVersion(versions.releaseVersion);
            result.setRepository((ArtifactRepository)(versions.releaseRepository == null ? localRepo : versions.releaseRepository));
        } else if (StringUtils.isNotEmpty((String)versions.latestVersion)) {
            result.setVersion(versions.latestVersion);
            result.setRepository((ArtifactRepository)(versions.latestRepository == null ? localRepo : versions.latestRepository));
        } else {
            throw new PluginVersionResolutionException(request.getGroupId(), request.getArtifactId(), localRepo, request.getRepositories(), "Plugin not found in any plugin repository");
        }
        return result;
    }

    private void mergeMetadata(RepositorySystemSession session, Versions versions, org.sonatype.aether.metadata.Metadata metadata, ArtifactRepository repository) {
        if (metadata != null && metadata.getFile() != null && metadata.getFile().isFile()) {
            try {
                Map<String, Boolean> options = Collections.singletonMap("org.apache.maven.artifact.repository.metadata.io.isStrict", Boolean.FALSE);
                Metadata repoMetadata = this.metadataReader.read(metadata.getFile(), options);
                this.mergeMetadata(versions, repoMetadata, repository);
            }
            catch (IOException e) {
                this.invalidMetadata(session, metadata, repository, e);
            }
        }
    }

    private void invalidMetadata(RepositorySystemSession session, org.sonatype.aether.metadata.Metadata metadata, ArtifactRepository repository, Exception exception) {
        RepositoryListener listener = session.getRepositoryListener();
        if (listener != null) {
            DefaultRepositoryEvent event = new DefaultRepositoryEvent(session, metadata);
            event.setException(exception);
            event.setRepository(repository);
            listener.metadataInvalid((RepositoryEvent)event);
        }
    }

    private void mergeMetadata(Versions versions, Metadata source, ArtifactRepository repository) {
        Versioning versioning = source.getVersioning();
        if (versioning != null) {
            String timestamp = StringUtils.clean((String)versioning.getLastUpdated());
            if (StringUtils.isNotEmpty((String)versioning.getRelease()) && timestamp.compareTo(versions.releaseTimestamp) > 0) {
                versions.releaseVersion = versioning.getRelease();
                versions.releaseTimestamp = timestamp;
                versions.releaseRepository = repository;
            }
            if (StringUtils.isNotEmpty((String)versioning.getLatest()) && timestamp.compareTo(versions.latestTimestamp) > 0) {
                versions.latestVersion = versioning.getLatest();
                versions.latestTimestamp = timestamp;
                versions.latestRepository = repository;
            }
        }
    }

    private PluginVersionResult resolveFromProject(PluginVersionRequest request) {
        Build build;
        PluginVersionResult result = null;
        if (request.getPom() != null && request.getPom().getBuild() != null && (result = this.resolveFromProject(request, (build = request.getPom().getBuild()).getPlugins())) == null && build.getPluginManagement() != null) {
            result = this.resolveFromProject(request, build.getPluginManagement().getPlugins());
        }
        return result;
    }

    private PluginVersionResult resolveFromProject(PluginVersionRequest request, List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!request.getGroupId().equals(plugin.getGroupId()) || !request.getArtifactId().equals(plugin.getArtifactId())) continue;
            if (plugin.getVersion() != null) {
                return new DefaultPluginVersionResult(plugin.getVersion());
            }
            return null;
        }
        return null;
    }

    static class Versions {
        String releaseVersion = "";
        String releaseTimestamp = "";
        ArtifactRepository releaseRepository;
        String latestVersion = "";
        String latestTimestamp = "";
        ArtifactRepository latestRepository;

        Versions() {
        }
    }
}

