/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Field;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Transform;
import org.xnio.ClosedWorkerException;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.WriteTimeoutException;
import org.xnio.nio.NioXnioWorker;

@MessageLogger(projectCode="XNIO")
interface Log
extends BasicLogger {
    public static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)"org.xnio.nio");
    public static final Log socketLog = (Log)Logger.getMessageLogger(Log.class, (String)"org.xnio.nio.socket");
    public static final Log selectorLog = (Log)Logger.getMessageLogger(Log.class, (String)"org.xnio.nio.selector");
    public static final Log tcpServerLog = (Log)Logger.getMessageLogger(Log.class, (String)"org.xnio.nio.tcp.server");
    public static final Log tcpServerConnectionLimitLog = (Log)Logger.getMessageLogger(Log.class, (String)"org.xnio.nio.tcp.server.connection-limit");
    public static final Log udpServerChannelLog = (Log)Logger.getMessageLogger(Log.class, (String)"org.xnio.nio.udp.server.channel");

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="XNIO NIO Implementation Version %s")
    public void greeting(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11, value="Task %s failed with an exception")
    public void taskFailed(Runnable var1, @Cause Throwable var2);

    @Message(id=15, value="Parameter '%s' is out of range")
    public IllegalArgumentException parameterOutOfRange(String var1);

    @Message(id=39, value="Value for option '%s' is out of range")
    public IllegalArgumentException optionOutOfRange(String var1);

    @Message(id=800, value="Read timed out")
    public ReadTimeoutException readTimeout();

    @Message(id=801, value="Write timed out")
    public WriteTimeoutException writeTimeout();

    @Message(id=808, value="I/O operation was interrupted")
    public InterruptedIOException interruptedIO();

    public InterruptedIOException interruptedIO(@Field int var1);

    @Message(id=815, value="Worker is shut down: %s")
    public ClosedWorkerException workerShutDown(NioXnioWorker var1);

    @Message(id=900, value="Method '%s' is not supported on this implementation")
    public UnsupportedOperationException unsupported(String var1);

    @Message(id=1006, value="Failed to invoke file watch callback")
    @LogMessage(level=Logger.Level.ERROR)
    public void failedToInvokeFileWatchCallback(@Cause Throwable var1);

    @Message(id=7000, value="No threads configured")
    public IllegalArgumentException noThreads();

    @Message(id=7001, value="Balancing token count must be greater than zero and less than thread count")
    public IllegalArgumentException balancingTokens();

    @Message(id=7002, value="Balancing connection count must be greater than zero when tokens are used")
    public IllegalArgumentException balancingConnectionCount();

    @Message(id=7003, value="Buffer is too large")
    public IllegalArgumentException bufferTooLarge();

    @Message(id=7004, value="No functional selector provider is available")
    public IllegalStateException noSelectorProvider();

    @Message(id=7005, value="Unexpected exception opening a selector")
    public IllegalStateException unexpectedSelectorOpenProblem(@Cause Throwable var1);

    @Message(id=7006, value="XNIO IO factory is from the wrong provider")
    public IllegalArgumentException notNioProvider();

    @Message(id=7007, value="Thread is terminating")
    public RejectedExecutionException threadExiting();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8000, value="Received an I/O error on selection: %s")
    public void selectionError(IOException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8001, value="Socket accept failed, backing off for %2$d milliseconds: %1$s")
    public void acceptFailed(IOException var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Starting up with selector provider %s")
    public void selectorProvider(@Transform(value={Transform.TransformType.GET_CLASS}) SelectorProvider var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Using %s for main selectors and %s for temp selectors")
    public void selectors(Object var1, Object var2);
}

