/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KDF;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.KeyPairDSA;
import com.jcraft.jsch.KeyPairECDSA;
import com.jcraft.jsch.KeyPairEd25519;
import com.jcraft.jsch.KeyPairEd448;
import com.jcraft.jsch.KeyPairRSA;
import com.jcraft.jsch.PBKDF2;
import com.jcraft.jsch.SCrypt;
import com.jcraft.jsch.Signature;
import com.jcraft.jsch.Util;
import java.math.BigInteger;
import java.util.ArrayList;

class KeyPairPKCS8
extends KeyPair {
    private static final byte[] rsaEncryption = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 1};
    private static final byte[] dsaEncryption = new byte[]{42, -122, 72, -50, 56, 4, 1};
    private static final byte[] ecPublicKey = new byte[]{42, -122, 72, -50, 61, 2, 1};
    private static final byte[] ed25519 = new byte[]{43, 101, 112};
    private static final byte[] ed448 = new byte[]{43, 101, 113};
    private static final byte[] secp256r1 = new byte[]{42, -122, 72, -50, 61, 3, 1, 7};
    private static final byte[] secp384r1 = new byte[]{43, -127, 4, 0, 34};
    private static final byte[] secp521r1 = new byte[]{43, -127, 4, 0, 35};
    private static final byte[] pbes2 = new byte[]{42, -122, 72, -122, -9, 13, 1, 5, 13};
    private static final byte[] pbkdf2 = new byte[]{42, -122, 72, -122, -9, 13, 1, 5, 12};
    private static final byte[] scrypt = new byte[]{43, 6, 1, 4, 1, -38, 71, 4, 11};
    private static final byte[] hmacWithSha1 = new byte[]{42, -122, 72, -122, -9, 13, 2, 7};
    private static final byte[] hmacWithSha224 = new byte[]{42, -122, 72, -122, -9, 13, 2, 8};
    private static final byte[] hmacWithSha256 = new byte[]{42, -122, 72, -122, -9, 13, 2, 9};
    private static final byte[] hmacWithSha384 = new byte[]{42, -122, 72, -122, -9, 13, 2, 10};
    private static final byte[] hmacWithSha512 = new byte[]{42, -122, 72, -122, -9, 13, 2, 11};
    private static final byte[] hmacWithSha512224 = new byte[]{42, -122, 72, -122, -9, 13, 2, 12};
    private static final byte[] hmacWithSha512256 = new byte[]{42, -122, 72, -122, -9, 13, 2, 13};
    private static final byte[] aes128cbc = new byte[]{96, -122, 72, 1, 101, 3, 4, 1, 2};
    private static final byte[] aes192cbc = new byte[]{96, -122, 72, 1, 101, 3, 4, 1, 22};
    private static final byte[] aes256cbc = new byte[]{96, -122, 72, 1, 101, 3, 4, 1, 42};
    private static final byte[] descbc = new byte[]{43, 14, 3, 2, 7};
    private static final byte[] des3cbc = new byte[]{42, -122, 72, -122, -9, 13, 3, 7};
    private static final byte[] rc2cbc = new byte[]{42, -122, 72, -122, -9, 13, 3, 2};
    private static final byte[] rc5cbc = new byte[]{42, -122, 72, -122, -9, 13, 3, 9};
    private static final byte[] pbeWithMD2AndDESCBC = new byte[]{42, -122, 72, -122, -9, 13, 1, 5, 1};
    private static final byte[] pbeWithMD2AndRC2CBC = new byte[]{42, -122, 72, -122, -9, 13, 1, 5, 4};
    private static final byte[] pbeWithMD5AndDESCBC = new byte[]{42, -122, 72, -122, -9, 13, 1, 5, 3};
    private static final byte[] pbeWithMD5AndRC2CBC = new byte[]{42, -122, 72, -122, -9, 13, 1, 5, 6};
    private static final byte[] pbeWithSHA1AndDESCBC = new byte[]{42, -122, 72, -122, -9, 13, 1, 5, 10};
    private static final byte[] pbeWithSHA1AndRC2CBC = new byte[]{42, -122, 72, -122, -9, 13, 1, 5, 11};
    private KeyPair kpair = null;
    private static final byte[] begin = Util.str2byte("-----BEGIN DSA PRIVATE KEY-----");
    private static final byte[] end = Util.str2byte("-----END DSA PRIVATE KEY-----");

    KeyPairPKCS8(JSch.InstanceLogger instLogger) {
        super(instLogger);
    }

    @Override
    void generate(int key_size) throws JSchException {
    }

    @Override
    byte[] getBegin() {
        return begin;
    }

    @Override
    byte[] getEnd() {
        return end;
    }

    @Override
    byte[] getPrivateKey() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    boolean parse(byte[] plain) {
        boolean bl;
        KeyPair _key;
        byte[] _plain;
        byte[] prv_array;
        byte[] _data;
        block71: {
            boolean bl2;
            block70: {
                boolean bl3;
                block69: {
                    boolean bl4;
                    block68: {
                        _data = null;
                        prv_array = null;
                        _plain = null;
                        _key = null;
                        try {
                            KeyPair.ASN1 asn1 = new KeyPair.ASN1(plain);
                            if (!asn1.isSEQUENCE()) {
                                throw new KeyPair.ASN1Exception();
                            }
                            KeyPair.ASN1[] contents = asn1.getContents();
                            if (contents.length < 3) throw new KeyPair.ASN1Exception();
                            if (contents.length > 4) {
                                throw new KeyPair.ASN1Exception();
                            }
                            if (!contents[0].isINTEGER()) {
                                throw new KeyPair.ASN1Exception();
                            }
                            if (!contents[1].isSEQUENCE()) {
                                throw new KeyPair.ASN1Exception();
                            }
                            if (!contents[2].isOCTETSTRING()) {
                                throw new KeyPair.ASN1Exception();
                            }
                            if (contents.length > 3 && !contents[3].isCONTEXTCONSTRUCTED(0)) {
                                throw new KeyPair.ASN1Exception();
                            }
                            int version = KeyPairPKCS8.parseASN1IntegerAsInt(contents[0].getContent());
                            if (version != 0) {
                                throw new KeyPair.ASN1Exception();
                            }
                            KeyPair.ASN1 privateKeyAlgorithm = contents[1];
                            KeyPair.ASN1 privateKey = contents[2];
                            contents = privateKeyAlgorithm.getContents();
                            if (contents.length == 0) {
                                throw new KeyPair.ASN1Exception();
                            }
                            if (!contents[0].isOBJECT()) {
                                throw new KeyPair.ASN1Exception();
                            }
                            byte[] privateKeyAlgorithmID = contents[0].getContent();
                            _data = privateKey.getContent();
                            KeyPair _kpair = null;
                            if (Util.array_equals(privateKeyAlgorithmID, rsaEncryption)) {
                                if (contents.length != 2) {
                                    throw new KeyPair.ASN1Exception();
                                }
                                if (!contents[1].isNULL()) {
                                    throw new KeyPair.ASN1Exception();
                                }
                                _kpair = new KeyPairRSA(this.instLogger);
                                _kpair.copy(this);
                                if (!_kpair.parse(_data)) throw new JSchException("failed to parse RSA");
                                this.kpair = _kpair;
                                bl4 = true;
                                Util.bzero(_data);
                                break block68;
                            }
                            if (Util.array_equals(privateKeyAlgorithmID, dsaEncryption)) {
                                ArrayList<byte[]> values = new ArrayList<byte[]>(3);
                                if (contents.length > 1 && contents[1].isSEQUENCE()) {
                                    if ((contents = contents[1].getContents()).length != 3) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    if (!contents[0].isINTEGER()) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    if (!contents[1].isINTEGER()) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    if (!contents[2].isINTEGER()) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    values.add(contents[0].getContent());
                                    values.add(contents[1].getContent());
                                    values.add(contents[2].getContent());
                                }
                                asn1 = new KeyPair.ASN1(_data);
                                if (values.size() == 0) {
                                    if (!asn1.isSEQUENCE()) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    contents = asn1.getContents();
                                    if (contents.length != 2) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    if (!contents[0].isSEQUENCE()) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    if (!contents[1].isINTEGER()) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    prv_array = contents[1].getContent();
                                    if ((contents = contents[0].getContents()).length != 3) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    if (!contents[0].isINTEGER()) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    if (!contents[1].isINTEGER()) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    if (!contents[2].isINTEGER()) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    values.add(contents[0].getContent());
                                    values.add(contents[1].getContent());
                                    values.add(contents[2].getContent());
                                } else {
                                    if (!asn1.isINTEGER()) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    prv_array = asn1.getContent();
                                }
                                byte[] P_array = (byte[])values.get(0);
                                byte[] Q_array = (byte[])values.get(1);
                                byte[] G_array = (byte[])values.get(2);
                                byte[] pub_array = new BigInteger(G_array).modPow(new BigInteger(prv_array), new BigInteger(P_array)).toByteArray();
                                _key = new KeyPairDSA(this.instLogger, P_array, Q_array, G_array, pub_array, prv_array);
                                _plain = _key.getPrivateKey();
                                _kpair = new KeyPairDSA(this.instLogger);
                                _kpair.copy(this);
                                if (!_kpair.parse(_plain)) throw new JSchException("failed to parse DSA");
                                this.kpair = _kpair;
                                bl3 = true;
                                Util.bzero(_data);
                                break block69;
                            }
                            if (Util.array_equals(privateKeyAlgorithmID, ecPublicKey)) {
                                KeyPair.ASN1 publicKey;
                                byte[] name;
                                if (contents.length != 2) {
                                    throw new KeyPair.ASN1Exception();
                                }
                                if (!contents[1].isOBJECT()) {
                                    throw new KeyPair.ASN1Exception();
                                }
                                byte[] namedCurve = contents[1].getContent();
                                if (!Util.array_equals(namedCurve, secp256r1)) {
                                    name = Util.str2byte("nistp256");
                                } else if (!Util.array_equals(namedCurve, secp384r1)) {
                                    name = Util.str2byte("nistp384");
                                } else {
                                    if (Util.array_equals(namedCurve, secp521r1)) throw new JSchException("unsupported named curve oid: " + Util.toHex(namedCurve));
                                    name = Util.str2byte("nistp521");
                                }
                                KeyPair.ASN1 ecPrivateKey = new KeyPair.ASN1(_data);
                                if (!ecPrivateKey.isSEQUENCE()) {
                                    throw new KeyPair.ASN1Exception();
                                }
                                contents = ecPrivateKey.getContents();
                                if (contents.length < 3) throw new KeyPair.ASN1Exception();
                                if (contents.length > 4) {
                                    throw new KeyPair.ASN1Exception();
                                }
                                if (!contents[0].isINTEGER()) {
                                    throw new KeyPair.ASN1Exception();
                                }
                                if (!contents[1].isOCTETSTRING()) {
                                    throw new KeyPair.ASN1Exception();
                                }
                                version = KeyPairPKCS8.parseASN1IntegerAsInt(contents[0].getContent());
                                if (version != 1) {
                                    throw new KeyPair.ASN1Exception();
                                }
                                prv_array = contents[1].getContent();
                                if (contents.length == 3) {
                                    publicKey = contents[2];
                                } else {
                                    publicKey = contents[3];
                                    if (!contents[2].isCONTEXTCONSTRUCTED(0)) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    KeyPair.ASN1[] goo = contents[2].getContents();
                                    if (goo.length != 1) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    if (!goo[0].isOBJECT()) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                    if (!Util.array_equals(goo[0].getContent(), namedCurve)) {
                                        throw new KeyPair.ASN1Exception();
                                    }
                                }
                                if (!publicKey.isCONTEXTCONSTRUCTED(1)) {
                                    throw new KeyPair.ASN1Exception();
                                }
                                contents = publicKey.getContents();
                                if (contents.length != 1) {
                                    throw new KeyPair.ASN1Exception();
                                }
                                if (!contents[0].isBITSTRING()) {
                                    throw new KeyPair.ASN1Exception();
                                }
                                byte[] Q_array = contents[0].getContent();
                                byte[][] tmp = KeyPairECDSA.fromPoint(Q_array);
                                byte[] r_array = tmp[0];
                                byte[] s_array = tmp[1];
                                _key = new KeyPairECDSA(this.instLogger, name, r_array, s_array, prv_array);
                                _plain = _key.getPrivateKey();
                                _kpair = new KeyPairECDSA(this.instLogger);
                                _kpair.copy(this);
                                if (!_kpair.parse(_plain)) throw new JSchException("failed to parse ECDSA");
                                this.kpair = _kpair;
                                bl2 = true;
                                Util.bzero(_data);
                                break block70;
                            }
                            if (!Util.array_equals(privateKeyAlgorithmID, ed25519)) {
                                if (!Util.array_equals(privateKeyAlgorithmID, ed448)) throw new JSchException("unsupported privateKeyAlgorithm oid: " + Util.toHex(privateKeyAlgorithmID));
                            }
                            if (contents.length != 1) {
                                throw new KeyPair.ASN1Exception();
                            }
                            KeyPair.ASN1 curvePrivateKey = new KeyPair.ASN1(_data);
                            if (!curvePrivateKey.isOCTETSTRING()) {
                                throw new KeyPair.ASN1Exception();
                            }
                            prv_array = curvePrivateKey.getContent();
                            _kpair = Util.array_equals(privateKeyAlgorithmID, ed25519) ? new KeyPairEd25519(this.instLogger) : new KeyPairEd448(this.instLogger);
                            _kpair.copy(this);
                            if (_kpair.parse(prv_array)) {
                                this.kpair = _kpair;
                                bl = true;
                                Util.bzero(_data);
                                break block71;
                            }
                            throw new JSchException("failed to parse EdDSA");
                        }
                        catch (KeyPair.ASN1Exception e) {
                            if (this.instLogger.getLogger().isEnabled(3)) {
                                this.instLogger.getLogger().log(3, "PKCS8: failed to parse key: ASN1 parsing error", e);
                            }
                            boolean bl5 = false;
                            return bl5;
                        }
                        catch (Exception e) {
                            if (this.instLogger.getLogger().isEnabled(3)) {
                                this.instLogger.getLogger().log(3, "PKCS8: failed to parse key: " + e.getMessage(), e);
                            }
                            boolean bl6 = false;
                            return bl6;
                        }
                    }
                    Util.bzero(prv_array);
                    Util.bzero(_plain);
                    if (_key == null) return bl4;
                    _key.dispose();
                    return bl4;
                }
                Util.bzero(prv_array);
                Util.bzero(_plain);
                if (_key == null) return bl3;
                _key.dispose();
                return bl3;
            }
            Util.bzero(prv_array);
            Util.bzero(_plain);
            if (_key == null) return bl2;
            _key.dispose();
            return bl2;
        }
        Util.bzero(prv_array);
        Util.bzero(_plain);
        if (_key == null) return bl;
        _key.dispose();
        return bl;
        finally {
            Util.bzero(_data);
            Util.bzero(prv_array);
            Util.bzero(_plain);
            if (_key != null) {
                _key.dispose();
            }
        }
    }

    @Override
    public byte[] getPublicKeyBlob() {
        if (this.kpair != null) {
            return this.kpair.getPublicKeyBlob();
        }
        return super.getPublicKeyBlob();
    }

    @Override
    byte[] getKeyTypeName() {
        if (this.kpair != null) {
            return this.kpair.getKeyTypeName();
        }
        return new byte[0];
    }

    @Override
    public int getKeyType() {
        if (this.kpair != null) {
            return this.kpair.getKeyType();
        }
        return 4;
    }

    @Override
    public int getKeySize() {
        return this.kpair.getKeySize();
    }

    @Override
    public byte[] getSignature(byte[] data) {
        return this.kpair.getSignature(data);
    }

    @Override
    public byte[] getSignature(byte[] data, String alg) {
        return this.kpair.getSignature(data, alg);
    }

    @Override
    public Signature getVerifier() {
        return this.kpair.getVerifier();
    }

    @Override
    public Signature getVerifier(String alg) {
        return this.kpair.getVerifier(alg);
    }

    @Override
    public byte[] forSSHAgent() throws JSchException {
        return this.kpair.forSSHAgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean decrypt(byte[] _passphrase) {
        boolean bl;
        byte[] plain;
        byte[] key;
        byte[] _data;
        block62: {
            if (!this.isEncrypted()) {
                return true;
            }
            if (_passphrase == null) {
                if (this.isEncrypted()) return false;
                return true;
            }
            _data = null;
            key = null;
            plain = null;
            try {
                KDF kdfinst;
                String kdfname;
                KeyPair.ASN1 encryptparams;
                byte[] encryptfuncid;
                KeyPair.ASN1 asn1 = new KeyPair.ASN1(this.data);
                if (!asn1.isSEQUENCE()) {
                    throw new KeyPair.ASN1Exception();
                }
                KeyPair.ASN1[] contents = asn1.getContents();
                if (contents.length != 2) {
                    throw new KeyPair.ASN1Exception();
                }
                if (!contents[0].isSEQUENCE()) {
                    throw new KeyPair.ASN1Exception();
                }
                if (!contents[1].isOCTETSTRING()) {
                    throw new KeyPair.ASN1Exception();
                }
                _data = contents[1].getContent();
                KeyPair.ASN1 pbes = contents[0];
                if ((contents = pbes.getContents()).length != 2) {
                    throw new KeyPair.ASN1Exception();
                }
                if (!contents[0].isOBJECT()) {
                    throw new KeyPair.ASN1Exception();
                }
                if (!contents[1].isSEQUENCE()) {
                    throw new KeyPair.ASN1Exception();
                }
                byte[] pbesid = contents[0].getContent();
                KeyPair.ASN1 pbesparam = contents[1];
                if (Util.array_equals(pbesid, pbes2)) {
                    contents = pbesparam.getContents();
                    if (contents.length != 2) {
                        throw new KeyPair.ASN1Exception();
                    }
                    KeyPair.ASN1 kdf = contents[0];
                    KeyPair.ASN1 encryptfunc = contents[1];
                    if (!kdf.isSEQUENCE()) {
                        throw new KeyPair.ASN1Exception();
                    }
                    if (!encryptfunc.isSEQUENCE()) {
                        throw new KeyPair.ASN1Exception();
                    }
                    contents = encryptfunc.getContents();
                    if (contents.length != 2) {
                        throw new KeyPair.ASN1Exception();
                    }
                    if (!contents[0].isOBJECT()) {
                        throw new KeyPair.ASN1Exception();
                    }
                    encryptfuncid = contents[0].getContent();
                    encryptparams = contents[1];
                    contents = kdf.getContents();
                    if (contents.length != 2) {
                        throw new KeyPair.ASN1Exception();
                    }
                    if (!contents[0].isOBJECT()) {
                        throw new KeyPair.ASN1Exception();
                    }
                    if (!contents[1].isSEQUENCE()) {
                        throw new KeyPair.ASN1Exception();
                    }
                    byte[] kdfid = contents[0].getContent();
                    if (Util.array_equals(kdfid, pbkdf2)) {
                        KeyPair.ASN1 pbkdf2func = contents[1];
                        if (!pbkdf2func.isSEQUENCE()) {
                            throw new KeyPair.ASN1Exception();
                        }
                        KeyPair.ASN1 prf = null;
                        contents = pbkdf2func.getContents();
                        if (contents.length < 2) throw new KeyPair.ASN1Exception();
                        if (contents.length > 4) {
                            throw new KeyPair.ASN1Exception();
                        }
                        if (!contents[0].isOCTETSTRING()) {
                            throw new KeyPair.ASN1Exception();
                        }
                        if (!contents[1].isINTEGER()) {
                            throw new KeyPair.ASN1Exception();
                        }
                        if (contents.length == 4) {
                            if (!contents[2].isINTEGER()) {
                                throw new KeyPair.ASN1Exception();
                            }
                            if (!contents[3].isSEQUENCE()) {
                                throw new KeyPair.ASN1Exception();
                            }
                            prf = contents[3];
                        } else if (contents.length == 3) {
                            if (contents[2].isSEQUENCE()) {
                                prf = contents[2];
                            } else if (!contents[2].isINTEGER()) {
                                throw new KeyPair.ASN1Exception();
                            }
                        }
                        byte[] prfid = null;
                        byte[] salt = contents[0].getContent();
                        int iterations = KeyPairPKCS8.parseASN1IntegerAsInt(contents[1].getContent());
                        if (prf != null) {
                            contents = prf.getContents();
                            if (contents.length != 2) {
                                throw new KeyPair.ASN1Exception();
                            }
                            if (!contents[0].isOBJECT()) {
                                throw new KeyPair.ASN1Exception();
                            }
                            if (!contents[1].isNULL()) {
                                throw new KeyPair.ASN1Exception();
                            }
                            prfid = contents[0].getContent();
                        }
                        kdfname = KeyPairPKCS8.getPBKDF2Name(prfid);
                        PBKDF2 pbkdf2kdf = KeyPairPKCS8.getPBKDF2(kdfname);
                        pbkdf2kdf.init(salt, iterations);
                        kdfinst = pbkdf2kdf;
                    } else {
                        if (!Util.array_equals(kdfid, scrypt)) throw new JSchException("unsupported kdf oid: " + Util.toHex(kdfid));
                        if ((contents = contents[1].getContents()).length < 4) throw new KeyPair.ASN1Exception();
                        if (contents.length > 5) {
                            throw new KeyPair.ASN1Exception();
                        }
                        if (!contents[0].isOCTETSTRING()) {
                            throw new KeyPair.ASN1Exception();
                        }
                        if (!contents[1].isINTEGER()) {
                            throw new KeyPair.ASN1Exception();
                        }
                        if (!contents[2].isINTEGER()) {
                            throw new KeyPair.ASN1Exception();
                        }
                        if (!contents[3].isINTEGER()) {
                            throw new KeyPair.ASN1Exception();
                        }
                        if (contents.length > 4 && !contents[4].isINTEGER()) {
                            throw new KeyPair.ASN1Exception();
                        }
                        byte[] salt = contents[0].getContent();
                        int cost = KeyPairPKCS8.parseASN1IntegerAsInt(contents[1].getContent());
                        int blocksize = KeyPairPKCS8.parseASN1IntegerAsInt(contents[2].getContent());
                        int parallel = KeyPairPKCS8.parseASN1IntegerAsInt(contents[3].getContent());
                        kdfname = "scrypt";
                        SCrypt scryptkdf = KeyPairPKCS8.getSCrypt();
                        scryptkdf.init(salt, cost, blocksize, parallel);
                        kdfinst = scryptkdf;
                    }
                } else {
                    String message;
                    if (Util.array_equals(pbesid, pbeWithMD2AndDESCBC)) {
                        message = "pbeWithMD2AndDES-CBC unsupported";
                        throw new JSchException(message);
                    }
                    if (Util.array_equals(pbesid, pbeWithMD2AndRC2CBC)) {
                        message = "pbeWithMD2AndRC2-CBC unsupported";
                        throw new JSchException(message);
                    }
                    if (Util.array_equals(pbesid, pbeWithMD5AndDESCBC)) {
                        message = "pbeWithMD5AndDES-CBC unsupported";
                        throw new JSchException(message);
                    }
                    if (Util.array_equals(pbesid, pbeWithMD5AndRC2CBC)) {
                        message = "pbeWithMD5AndRC2-CBC unsupported";
                        throw new JSchException(message);
                    }
                    if (Util.array_equals(pbesid, pbeWithSHA1AndDESCBC)) {
                        message = "pbeWithSHA1AndDES-CBC unsupported";
                        throw new JSchException(message);
                    }
                    if (Util.array_equals(pbesid, pbeWithSHA1AndRC2CBC)) {
                        message = "pbeWithSHA1AndRC2-CBC unsupported";
                        throw new JSchException(message);
                    }
                    message = "unsupported encryption oid: " + Util.toHex(pbesid);
                    throw new JSchException(message);
                }
                byte[][] ivp = new byte[1][];
                Cipher cipher = KeyPairPKCS8.getCipher(encryptfuncid, encryptparams, ivp);
                byte[] iv = ivp[0];
                key = kdfinst.getKey(_passphrase, cipher.getBlockSize());
                if (key == null) {
                    throw new JSchException("failed to generate key from KDF " + kdfname);
                }
                cipher.init(1, key, iv);
                plain = new byte[_data.length];
                cipher.update(_data, 0, _data.length, plain, 0);
                if (this.parse(plain)) {
                    this.encrypted = false;
                    Util.bzero(this.data);
                    bl = true;
                    Util.bzero(_data);
                    break block62;
                }
                throw new JSchException("failed to parse decrypted key");
            }
            catch (KeyPair.ASN1Exception e) {
                if (this.instLogger.getLogger().isEnabled(3)) {
                    this.instLogger.getLogger().log(3, "PKCS8: failed to decrypt key: ASN1 parsing error", e);
                }
                boolean bl2 = false;
                return bl2;
            }
            catch (Exception e) {
                if (this.instLogger.getLogger().isEnabled(3)) {
                    this.instLogger.getLogger().log(3, "PKCS8: failed to decrypt key: " + e.getMessage(), e);
                }
                boolean bl3 = false;
                return bl3;
            }
        }
        Util.bzero(key);
        Util.bzero(plain);
        return bl;
        finally {
            Util.bzero(_data);
            Util.bzero(key);
            Util.bzero(plain);
        }
    }

    static String getPBKDF2Name(byte[] id) throws JSchException {
        String name = null;
        if (id == null || Util.array_equals(id, hmacWithSha1)) {
            name = "pbkdf2-hmac-sha1";
        } else if (Util.array_equals(id, hmacWithSha224)) {
            name = "pbkdf2-hmac-sha224";
        } else if (Util.array_equals(id, hmacWithSha256)) {
            name = "pbkdf2-hmac-sha256";
        } else if (Util.array_equals(id, hmacWithSha384)) {
            name = "pbkdf2-hmac-sha384";
        } else if (Util.array_equals(id, hmacWithSha512)) {
            name = "pbkdf2-hmac-sha512";
        } else {
            if (Util.array_equals(id, hmacWithSha512224)) {
                throw new JSchException("unsupported pbkdf2 function: pbkdf2-hmac-sha512-224");
            }
            if (Util.array_equals(id, hmacWithSha512256)) {
                throw new JSchException("unsupported pbkdf2 function: pbkdf2-hmac-sha512-256");
            }
        }
        if (name == null) {
            throw new JSchException("unsupported pbkdf2 function oid: " + Util.toHex(id));
        }
        return name;
    }

    static PBKDF2 getPBKDF2(String name) throws JSchException {
        try {
            Class<PBKDF2> c = Class.forName(JSch.getConfig(name)).asSubclass(PBKDF2.class);
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JSchException(name + " is not supported", e);
        }
    }

    static SCrypt getSCrypt() throws JSchException {
        try {
            Class<SCrypt> c = Class.forName(JSch.getConfig("scrypt")).asSubclass(SCrypt.class);
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JSchException("scrypt is not supported", e);
        }
    }

    static Cipher getCipher(byte[] id, KeyPair.ASN1 encryptparams, byte[][] ivp) throws Exception {
        String name = null;
        if (Util.array_equals(id, aes128cbc)) {
            name = "aes128-cbc";
        } else if (Util.array_equals(id, aes192cbc)) {
            name = "aes192-cbc";
        } else if (Util.array_equals(id, aes256cbc)) {
            name = "aes256-cbc";
        } else {
            if (Util.array_equals(id, descbc)) {
                throw new JSchException("unsupported cipher function: des-cbc");
            }
            if (Util.array_equals(id, des3cbc)) {
                throw new JSchException("unsupported cipher function: 3des-cbc");
            }
            if (Util.array_equals(id, rc2cbc)) {
                throw new JSchException("unsupported cipher function: rc2-cbc");
            }
            if (Util.array_equals(id, rc5cbc)) {
                throw new JSchException("unsupported cipher function: rc5-cbc");
            }
        }
        if (name == null) {
            throw new JSchException("unsupported cipher function oid: " + Util.toHex(id));
        }
        if (!encryptparams.isOCTETSTRING()) {
            throw new KeyPair.ASN1Exception();
        }
        ivp[0] = encryptparams.getContent();
        try {
            Class<Cipher> c = Class.forName(JSch.getConfig(name)).asSubclass(Cipher.class);
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JSchException(name + " is not supported", e);
        }
    }

    static int parseASN1IntegerAsInt(byte[] content) {
        return new BigInteger(content).intValueExact();
    }
}

