/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.common;

import com.p6spy.engine.logging.P6LogLoadableOptions;
import com.p6spy.engine.logging.P6LogOptions;
import com.p6spy.engine.logging.format.BinaryFormat;
import com.p6spy.engine.spy.P6SpyOptions;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Value {
    private Object value;

    public Value(Object valueToSet) {
        this();
        this.value = valueToSet;
    }

    public Value() {
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        return this.convertToString(this.value);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String convertToString(Object value) {
        String result;
        if (value == null) {
            return "NULL";
        }
        if (value instanceof byte[]) {
            P6LogLoadableOptions logOptions = P6LogOptions.getActiveInstance();
            if (logOptions != null && logOptions.getExcludebinary()) {
                result = "[binary]";
                return this.quoteIfNeeded(result, value);
            } else {
                BinaryFormat binaryFormat = P6SpyOptions.getActiveInstance().getDatabaseDialectBinaryFormatInstance();
                return binaryFormat.toString((byte[])value);
            }
        }
        result = value instanceof Timestamp ? new SimpleDateFormat(P6SpyOptions.getActiveInstance().getDatabaseDialectTimestampFormat()).format(value) : (value instanceof Date ? new SimpleDateFormat(P6SpyOptions.getActiveInstance().getDatabaseDialectDateFormat()).format(value) : (value instanceof Boolean ? ("numeric".equals(P6SpyOptions.getActiveInstance().getDatabaseDialectBooleanFormat()) ? (Boolean.FALSE.equals(value) ? "0" : "1") : value.toString()) : value.toString()));
        return this.quoteIfNeeded(result, value);
    }

    private String quoteIfNeeded(String stringValue, Object obj) {
        if (stringValue == null) {
            return null;
        }
        if (Number.class.isAssignableFrom(obj.getClass()) || Boolean.class.isAssignableFrom(obj.getClass())) {
            return stringValue;
        }
        return "'" + this.escape(stringValue) + "'";
    }

    private String escape(String stringValue) {
        return stringValue.replaceAll("'", "''");
    }
}

