/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.authentication;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.streampark.console.core.enums.AuthenticationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTUtil {
    private static final Logger log = LoggerFactory.getLogger(JWTUtil.class);
    private static Long ttlOfSecond;

    public static boolean verify(String token, String username, String secret) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("userName", username).build();
            verifier.verify(token);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static String getUserName(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("userName").asString();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static Long getUserId(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("userId").asLong();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static AuthenticationType getAuthType(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            int type = jwt.getClaim("type").asInt();
            return AuthenticationType.of(type);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static String sign(Long userId, String userName, String secret, AuthenticationType authType) {
        Long second = JWTUtil.getTTLOfSecond() * 1000L;
        Long ttl = System.currentTimeMillis() + second;
        return JWTUtil.sign(userId, userName, secret, authType, ttl);
    }

    public static String sign(Long userId, String userName, String secret, AuthenticationType authType, Long expireTime) {
        Date date = new Date(expireTime);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("userId", userId).withClaim("userName", userName).withClaim("type", Integer.valueOf(authType.get())).withExpiresAt(date).sign(algorithm);
    }

    public static Long getTTLOfSecond() {
        if (ttlOfSecond == null) {
            String ttl = System.getProperty("server.session.ttl", "24h").trim();
            String regexp = "^\\d+(s|m|h|d)$";
            Pattern pattern = Pattern.compile(regexp);
            if (!pattern.matcher(ttl).matches()) {
                throw new IllegalArgumentException("server.session.ttl is invalid, Time units must be [s|m|h|d], e.g: 24h, 2d... please check config.yaml ");
            }
            String unit = ttl.substring(ttl.length() - 1);
            String time = ttl.substring(0, ttl.length() - 1);
            Long second = Long.parseLong(time);
            switch (unit) {
                case "m": {
                    ttlOfSecond = second * 60L;
                    return ttlOfSecond;
                }
                case "h": {
                    ttlOfSecond = second * 60L * 60L;
                    return ttlOfSecond;
                }
                case "d": {
                    ttlOfSecond = second * 24L * 60L * 60L;
                    return ttlOfSecond;
                }
            }
            ttlOfSecond = second;
            return ttlOfSecond;
        }
        return ttlOfSecond;
    }
}

