/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.conf.ConfigConst;
import org.apache.streampark.console.base.exception.ApiAlertException;

public class YarnQueueLabelExpression {
    private static final String AT = "@";
    private static final String REGEX = "[a-zA-Z0-9_\\-]+";
    @VisibleForTesting
    public static final String ERR_FORMAT_HINTS = "Yarn queue label format should be in format {queue} or {queue}@{label1,label2}";
    private static final Pattern QUEUE_LABEL_PATTERN = Pattern.compile(String.format("^(%s)(.%s)*(%s(%s)(,%s)*)?$", "[a-zA-Z0-9_\\-]+", "[a-zA-Z0-9_\\-]+", "@", "[a-zA-Z0-9_\\-]+", "[a-zA-Z0-9_\\-]+"));
    private static final String QUEUE_LABEL_FORMAT = "%s@%s";
    private final String queue;
    @Nullable
    private final String labelExpression;

    private YarnQueueLabelExpression(String queue, String labelExpression) {
        this.labelExpression = StringUtils.isEmpty((CharSequence)labelExpression) ? null : labelExpression;
        this.queue = queue;
    }

    public Optional<String> getLabelExpression() {
        return Optional.ofNullable(this.labelExpression);
    }

    @Nonnull
    public String getQueue() {
        return this.queue;
    }

    public String toString() {
        return StringUtils.isEmpty((CharSequence)this.labelExpression) ? this.queue : String.format(QUEUE_LABEL_FORMAT, this.queue, this.labelExpression);
    }

    public static boolean isValid(String queueLabel, boolean ignoreEmpty) {
        if (StringUtils.isEmpty((CharSequence)queueLabel)) {
            return ignoreEmpty;
        }
        return QUEUE_LABEL_PATTERN.matcher(queueLabel).matches();
    }

    public static boolean isValid(String queueLabel) {
        return YarnQueueLabelExpression.isValid(queueLabel, false);
    }

    public static YarnQueueLabelExpression of(@Nonnull String queueLabelExpr) {
        ApiAlertException.throwIfFalse(YarnQueueLabelExpression.isValid(queueLabelExpr, false), ERR_FORMAT_HINTS);
        String[] strs = queueLabelExpr.split(AT);
        if (strs.length == 2) {
            return new YarnQueueLabelExpression(strs[0], strs[1]);
        }
        return new YarnQueueLabelExpression(strs[0], null);
    }

    public static YarnQueueLabelExpression of(@Nonnull String queue, @Nullable String labelExpression) {
        YarnQueueLabelExpression queueLabelExpression = new YarnQueueLabelExpression(queue, labelExpression);
        ApiAlertException.throwIfFalse(YarnQueueLabelExpression.isValid(queueLabelExpression.toString(), false), ERR_FORMAT_HINTS);
        return queueLabelExpression;
    }

    public static Map<String, String> getQueueLabelMap(String queueLabelExp) {
        if (StringUtils.isEmpty((CharSequence)queueLabelExp)) {
            return Collections.emptyMap();
        }
        YarnQueueLabelExpression yarnQueueLabelExpression = YarnQueueLabelExpression.of(queueLabelExp);
        HashMap<String, String> map = new HashMap<String, String>(2);
        yarnQueueLabelExpression.getLabelExpression().ifPresent(labelExp -> map.put(ConfigConst.KEY_YARN_APP_NODE_LABEL(), (String)labelExp));
        map.put(ConfigConst.KEY_YARN_APP_QUEUE(), yarnQueueLabelExpression.queue);
        return map;
    }
}

