/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.EdgeManager;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.executiongraph.failover.flip1.SchedulingPipelinedRegionComputeUtil;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalPipelinedRegion;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalTopology;
import org.apache.flink.runtime.jobgraph.topology.LogicalEdge;
import org.apache.flink.runtime.jobgraph.topology.LogicalVertex;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionVertex;
import org.apache.flink.runtime.scheduler.adapter.DefaultResultPartition;
import org.apache.flink.runtime.scheduler.adapter.DefaultSchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutionTopology
implements SchedulingTopology {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExecutionTopology.class);
    private final Map<ExecutionVertexID, DefaultExecutionVertex> executionVerticesById;
    private final List<DefaultExecutionVertex> executionVerticesList;
    private final Map<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionsById;
    private final Map<ExecutionVertexID, DefaultSchedulingPipelinedRegion> pipelinedRegionsByVertex;
    private final List<DefaultSchedulingPipelinedRegion> pipelinedRegions;
    private final EdgeManager edgeManager;

    private DefaultExecutionTopology(Map<ExecutionVertexID, DefaultExecutionVertex> executionVerticesById, List<DefaultExecutionVertex> executionVerticesList, Map<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionsById, Map<ExecutionVertexID, DefaultSchedulingPipelinedRegion> pipelinedRegionsByVertex, List<DefaultSchedulingPipelinedRegion> pipelinedRegions, EdgeManager edgeManager) {
        this.executionVerticesById = (Map)Preconditions.checkNotNull(executionVerticesById);
        this.executionVerticesList = (List)Preconditions.checkNotNull(executionVerticesList);
        this.resultPartitionsById = (Map)Preconditions.checkNotNull(resultPartitionsById);
        this.pipelinedRegionsByVertex = (Map)Preconditions.checkNotNull(pipelinedRegionsByVertex);
        this.pipelinedRegions = (List)Preconditions.checkNotNull(pipelinedRegions);
        this.edgeManager = edgeManager;
    }

    @Override
    public Iterable<DefaultExecutionVertex> getVertices() {
        return Collections.unmodifiableList(this.executionVerticesList);
    }

    @Override
    public DefaultExecutionVertex getVertex(ExecutionVertexID executionVertexId) {
        DefaultExecutionVertex executionVertex = this.executionVerticesById.get(executionVertexId);
        if (executionVertex == null) {
            throw new IllegalArgumentException("can not find vertex: " + executionVertexId);
        }
        return executionVertex;
    }

    @Override
    public DefaultResultPartition getResultPartition(IntermediateResultPartitionID intermediateResultPartitionId) {
        DefaultResultPartition resultPartition = this.resultPartitionsById.get(intermediateResultPartitionId);
        if (resultPartition == null) {
            throw new IllegalArgumentException("can not find partition: " + intermediateResultPartitionId);
        }
        return resultPartition;
    }

    @Override
    public Iterable<DefaultSchedulingPipelinedRegion> getAllPipelinedRegions() {
        Preconditions.checkNotNull(this.pipelinedRegions);
        return Collections.unmodifiableCollection(this.pipelinedRegions);
    }

    @Override
    public DefaultSchedulingPipelinedRegion getPipelinedRegionOfVertex(ExecutionVertexID vertexId) {
        Preconditions.checkNotNull(this.pipelinedRegionsByVertex);
        DefaultSchedulingPipelinedRegion pipelinedRegion = this.pipelinedRegionsByVertex.get(vertexId);
        if (pipelinedRegion == null) {
            throw new IllegalArgumentException("Unknown execution vertex " + vertexId);
        }
        return pipelinedRegion;
    }

    public EdgeManager getEdgeManager() {
        return this.edgeManager;
    }

    public static DefaultExecutionTopology fromExecutionGraph(DefaultExecutionGraph executionGraph) {
        Preconditions.checkNotNull((Object)executionGraph, (String)"execution graph can not be null");
        EdgeManager edgeManager = executionGraph.getEdgeManager();
        List<JobVertex> topologicallySortedJobVertices = IterableUtils.toStream(executionGraph.getVerticesTopologically()).map(ExecutionJobVertex::getJobVertex).collect(Collectors.toList());
        Iterable<DefaultLogicalPipelinedRegion> logicalPipelinedRegions = DefaultLogicalTopology.fromTopologicallySortedJobVertices(topologicallySortedJobVertices).getAllPipelinedRegions();
        ExecutionGraphIndex executionGraphIndex = DefaultExecutionTopology.computeExecutionGraphIndex(executionGraph.getAllExecutionVertices(), executionGraph.getTotalNumberOfVertices(), logicalPipelinedRegions, edgeManager);
        IndexedPipelinedRegions indexedPipelinedRegions = DefaultExecutionTopology.computePipelinedRegions(logicalPipelinedRegions, executionGraphIndex.sortedExecutionVerticesInPipelinedRegion::get, executionGraphIndex.executionVerticesById::get, executionGraphIndex.resultPartitionsById::get);
        DefaultExecutionTopology.ensureCoLocatedVerticesInSameRegion(indexedPipelinedRegions.pipelinedRegions, executionGraph);
        return new DefaultExecutionTopology(executionGraphIndex.executionVerticesById, executionGraphIndex.executionVerticesList, executionGraphIndex.resultPartitionsById, indexedPipelinedRegions.pipelinedRegionsByVertex, indexedPipelinedRegions.pipelinedRegions, edgeManager);
    }

    private static ExecutionGraphIndex computeExecutionGraphIndex(Iterable<ExecutionVertex> executionVertices, int vertexNumber, Iterable<DefaultLogicalPipelinedRegion> logicalPipelinedRegions, EdgeManager edgeManager) {
        HashMap<ExecutionVertexID, DefaultExecutionVertex> executionVerticesById = new HashMap<ExecutionVertexID, DefaultExecutionVertex>();
        ArrayList<DefaultExecutionVertex> executionVerticesList = new ArrayList<DefaultExecutionVertex>(vertexNumber);
        HashMap resultPartitionsById = new HashMap();
        IdentityHashMap<DefaultLogicalPipelinedRegion, List> sortedExecutionVerticesInPipelinedRegion = new IdentityHashMap<DefaultLogicalPipelinedRegion, List>();
        HashMap logicalPipelinedRegionByJobVertexId = new HashMap();
        for (DefaultLogicalPipelinedRegion logicalPipelinedRegion : logicalPipelinedRegions) {
            for (LogicalVertex logicalVertex : logicalPipelinedRegion.getVertices()) {
                logicalPipelinedRegionByJobVertexId.put(logicalVertex.getId(), logicalPipelinedRegion);
            }
        }
        for (ExecutionVertex vertex : executionVertices) {
            List<DefaultResultPartition> producedPartitions = DefaultExecutionTopology.generateProducedSchedulingResultPartition(vertex.getProducedPartitions(), edgeManager::getConsumerVertexGroupsForPartition, executionVerticesById::get);
            producedPartitions.forEach(partition -> resultPartitionsById.put(partition.getId(), partition));
            DefaultExecutionVertex defaultExecutionVertex = DefaultExecutionTopology.generateSchedulingExecutionVertex(vertex, producedPartitions, edgeManager.getConsumedPartitionGroupsForVertex(vertex.getID()), resultPartitionsById::get);
            executionVerticesById.put(defaultExecutionVertex.getId(), defaultExecutionVertex);
            sortedExecutionVerticesInPipelinedRegion.computeIfAbsent((DefaultLogicalPipelinedRegion)logicalPipelinedRegionByJobVertexId.get(defaultExecutionVertex.getId().getJobVertexId()), ignore -> new ArrayList()).add(defaultExecutionVertex);
            executionVerticesList.add(defaultExecutionVertex);
        }
        return new ExecutionGraphIndex(executionVerticesById, executionVerticesList, sortedExecutionVerticesInPipelinedRegion, resultPartitionsById);
    }

    private static List<DefaultResultPartition> generateProducedSchedulingResultPartition(Map<IntermediateResultPartitionID, IntermediateResultPartition> producedIntermediatePartitions, Function<IntermediateResultPartitionID, List<ConsumerVertexGroup>> partitionConsumerVertexGroups, Function<ExecutionVertexID, DefaultExecutionVertex> executionVertexRetriever) {
        ArrayList<DefaultResultPartition> producedSchedulingPartitions = new ArrayList<DefaultResultPartition>(producedIntermediatePartitions.size());
        producedIntermediatePartitions.values().forEach(irp -> producedSchedulingPartitions.add(new DefaultResultPartition(irp.getPartitionId(), irp.getIntermediateResult().getId(), irp.getResultType(), () -> irp.isConsumable() ? ResultPartitionState.CONSUMABLE : ResultPartitionState.CREATED, (List)partitionConsumerVertexGroups.apply(irp.getPartitionId()), executionVertexRetriever, irp::getConsumedPartitionGroups)));
        return producedSchedulingPartitions;
    }

    private static DefaultExecutionVertex generateSchedulingExecutionVertex(ExecutionVertex vertex, List<DefaultResultPartition> producedPartitions, List<ConsumedPartitionGroup> consumedPartitionGroups, Function<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionRetriever) {
        DefaultExecutionVertex schedulingVertex = new DefaultExecutionVertex(vertex.getID(), producedPartitions, vertex::getExecutionState, consumedPartitionGroups, resultPartitionRetriever);
        producedPartitions.forEach(partition -> partition.setProducer(schedulingVertex));
        return schedulingVertex;
    }

    private static IndexedPipelinedRegions computePipelinedRegions(Iterable<DefaultLogicalPipelinedRegion> logicalPipelinedRegions, Function<DefaultLogicalPipelinedRegion, List<DefaultExecutionVertex>> sortedExecutionVerticesInPipelinedRegion, Function<ExecutionVertexID, DefaultExecutionVertex> executionVertexRetriever, Function<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionRetriever) {
        long buildRegionsStartTime = System.nanoTime();
        Set<Set> rawPipelinedRegions = Collections.newSetFromMap(new IdentityHashMap());
        for (DefaultLogicalPipelinedRegion logicalPipelinedRegion : logicalPipelinedRegions) {
            List<DefaultExecutionVertex> schedulingExecutionVertices = sortedExecutionVerticesInPipelinedRegion.apply(logicalPipelinedRegion);
            if (DefaultExecutionTopology.containsIntraRegionAllToAllEdge(logicalPipelinedRegion)) {
                rawPipelinedRegions.add(new HashSet(schedulingExecutionVertices));
                continue;
            }
            rawPipelinedRegions.addAll(SchedulingPipelinedRegionComputeUtil.computePipelinedRegions((Iterable<? extends SchedulingExecutionVertex>)schedulingExecutionVertices, executionVertexRetriever, resultPartitionRetriever));
        }
        HashMap pipelinedRegionsByVertex = new HashMap();
        ArrayList<DefaultSchedulingPipelinedRegion> pipelinedRegions = new ArrayList<DefaultSchedulingPipelinedRegion>();
        for (Set rawPipelinedRegion : rawPipelinedRegions) {
            DefaultSchedulingPipelinedRegion pipelinedRegion = new DefaultSchedulingPipelinedRegion(rawPipelinedRegion, resultPartitionRetriever);
            pipelinedRegions.add(pipelinedRegion);
            for (SchedulingExecutionVertex executionVertex : rawPipelinedRegion) {
                pipelinedRegionsByVertex.put(executionVertex.getId(), pipelinedRegion);
            }
        }
        long buildRegionsDuration = (System.nanoTime() - buildRegionsStartTime) / 1000000L;
        LOG.info("Built {} pipelined regions in {} ms", (Object)pipelinedRegions.size(), (Object)buildRegionsDuration);
        return new IndexedPipelinedRegions(pipelinedRegionsByVertex, pipelinedRegions);
    }

    private static boolean containsIntraRegionAllToAllEdge(DefaultLogicalPipelinedRegion logicalPipelinedRegion) {
        for (LogicalVertex logicalVertex : logicalPipelinedRegion.getVertices()) {
            for (LogicalEdge logicalEdge : logicalVertex.getInputs()) {
                if (logicalEdge.getDistributionPattern() != DistributionPattern.ALL_TO_ALL || !logicalPipelinedRegion.contains(logicalEdge.getProducerVertexId())) continue;
                return true;
            }
        }
        return false;
    }

    private static void ensureCoLocatedVerticesInSameRegion(List<DefaultSchedulingPipelinedRegion> pipelinedRegions, ExecutionGraph executionGraph) {
        HashMap<CoLocationConstraint, DefaultSchedulingPipelinedRegion> constraintToRegion = new HashMap<CoLocationConstraint, DefaultSchedulingPipelinedRegion>();
        for (DefaultSchedulingPipelinedRegion region : pipelinedRegions) {
            for (DefaultExecutionVertex vertex : region.getVertices()) {
                CoLocationConstraint constraint = DefaultExecutionTopology.getCoLocationConstraint(vertex.getId(), executionGraph);
                if (constraint == null) continue;
                DefaultSchedulingPipelinedRegion regionOfConstraint = (DefaultSchedulingPipelinedRegion)constraintToRegion.get(constraint);
                Preconditions.checkState((regionOfConstraint == null || regionOfConstraint == region ? 1 : 0) != 0, (Object)"co-located tasks must be in the same pipelined region");
                constraintToRegion.putIfAbsent(constraint, region);
            }
        }
    }

    private static CoLocationConstraint getCoLocationConstraint(ExecutionVertexID executionVertexId, ExecutionGraph executionGraph) {
        CoLocationGroup coLocationGroup = Objects.requireNonNull(executionGraph.getJobVertex(executionVertexId.getJobVertexId())).getCoLocationGroup();
        return coLocationGroup == null ? null : coLocationGroup.getLocationConstraint(executionVertexId.getSubtaskIndex());
    }

    private static class IndexedPipelinedRegions {
        private final Map<ExecutionVertexID, DefaultSchedulingPipelinedRegion> pipelinedRegionsByVertex;
        private final List<DefaultSchedulingPipelinedRegion> pipelinedRegions;

        private IndexedPipelinedRegions(Map<ExecutionVertexID, DefaultSchedulingPipelinedRegion> pipelinedRegionsByVertex, List<DefaultSchedulingPipelinedRegion> pipelinedRegions) {
            this.pipelinedRegionsByVertex = (Map)Preconditions.checkNotNull(pipelinedRegionsByVertex);
            this.pipelinedRegions = (List)Preconditions.checkNotNull(pipelinedRegions);
        }
    }

    private static class ExecutionGraphIndex {
        private final Map<ExecutionVertexID, DefaultExecutionVertex> executionVerticesById;
        private final List<DefaultExecutionVertex> executionVerticesList;
        private final Map<DefaultLogicalPipelinedRegion, List<DefaultExecutionVertex>> sortedExecutionVerticesInPipelinedRegion;
        private final Map<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionsById;

        private ExecutionGraphIndex(Map<ExecutionVertexID, DefaultExecutionVertex> executionVerticesById, List<DefaultExecutionVertex> executionVerticesList, Map<DefaultLogicalPipelinedRegion, List<DefaultExecutionVertex>> sortedExecutionVerticesInPipelinedRegion, Map<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionsById) {
            this.executionVerticesById = (Map)Preconditions.checkNotNull(executionVerticesById);
            this.executionVerticesList = (List)Preconditions.checkNotNull(executionVerticesList);
            this.sortedExecutionVerticesInPipelinedRegion = (Map)Preconditions.checkNotNull(sortedExecutionVerticesInPipelinedRegion);
            this.resultPartitionsById = (Map)Preconditions.checkNotNull(resultPartitionsById);
        }
    }
}

