/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.error;

import coursierapi.shaded.coursier.core.Dependency;
import coursierapi.shaded.coursier.core.Module;
import coursierapi.shaded.coursier.core.Resolution;
import coursierapi.shaded.coursier.error.CoursierError;
import coursierapi.shaded.coursier.error.ResolutionError$;
import coursierapi.shaded.coursier.error.ResolutionError$Simple$;
import coursierapi.shaded.coursier.error.conflict.UnsatisfiedRule;
import coursierapi.shaded.coursier.params.rule.Rule;
import coursierapi.shaded.scala.collection.IterableOnceOps;
import coursierapi.shaded.scala.collection.IterableOps;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.collection.immutable.Set;
import java.io.Serializable;

public abstract class ResolutionError
extends CoursierError {
    private final Resolution resolution;

    public Resolution resolution() {
        return this.resolution;
    }

    public ResolutionError(Resolution resolution, String message, Throwable cause) {
        this.resolution = resolution;
        super(message, cause);
    }

    public static final class CantDownloadModule
    extends Simple {
        private final Module module;
        private final String version;
        private final Seq<String> perRepositoryErrors;

        public CantDownloadModule(Resolution resolution, Module module, String version, Seq<String> perRepositoryErrors) {
            this.module = module;
            this.version = version;
            this.perRepositoryErrors = perRepositoryErrors;
            super(resolution, new StringBuilder(19).append("Error downloading ").append(module).append(":").append(version).append(System.lineSeparator()).append(((IterableOnceOps)perRepositoryErrors.map(new Serializable(){

                public final String apply(String err) {
                    return new StringBuilder(2).append("  ").append(err.replace(System.lineSeparator(), new StringBuilder(2).append("  ").append(System.lineSeparator()).toString())).toString();
                }
            })).mkString(System.lineSeparator())).toString(), ResolutionError$Simple$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static final class ConflictingDependencies
    extends Simple {
        private final Set<Dependency> dependencies;

        public ConflictingDependencies(Resolution resolution, Set<Dependency> dependencies) {
            this.dependencies = dependencies;
            super(resolution, ResolutionError$.MODULE$.coursier$error$ResolutionError$$conflictingDependenciesErrorMessage(resolution), ResolutionError$Simple$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static final class MaximumIterationReached
    extends Simple {
        public MaximumIterationReached(Resolution resolution) {
            super(resolution, "Maximum number of iterations reached", ResolutionError$Simple$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static final class Several
    extends ResolutionError {
        private final Simple head;
        private final Seq<Simple> tail;

        public Simple head() {
            return this.head;
        }

        public Seq<Simple> tail() {
            return this.tail;
        }

        public Several(Simple head, Seq<Simple> tail) {
            this.head = head;
            this.tail = tail;
            Simple simple = head;
            super(head.resolution(), ((IterableOnceOps)((IterableOps)tail.$plus$colon(simple)).map(new Serializable(){

                public final String apply(Simple x$6) {
                    return x$6.getMessage();
                }
            })).mkString(System.lineSeparator()), ResolutionError$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static abstract class Simple
    extends ResolutionError {
        public Simple(Resolution resolution, String message, Throwable cause) {
            super(resolution, message, cause);
        }
    }

    public static abstract class UnsatisfiableRule
    extends Simple {
        private final Rule rule;
        private final UnsatisfiedRule conflict;

        public UnsatisfiableRule(Resolution resolution, Rule rule, UnsatisfiedRule conflict, String message) {
            this.rule = rule;
            this.conflict = conflict;
            super(resolution, message, conflict);
        }
    }
}

